/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.DummyModuleInfo;
import org.openide.modules.ModuleInfo;

class PatchChecker {
    private static final String JAR_EXTENSION = ".JAR";
    private static final String ZIP_EXTENSION = ".ZIP";
    private static ModuleInfo[] patchArray = null;

    private PatchChecker() {
    }

    static ModuleInfo[] getPatches() {
        if (patchArray == null) {
            List list = Autoupdater.Support.getPatchDirectories();
            ArrayList arrayList = new ArrayList();
            if (!list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PatchChecker.addPatches((File)iterator.next(), arrayList);
                }
            }
            patchArray = new ModuleInfo[arrayList.size()];
            arrayList.toArray(patchArray);
        }
        return patchArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPatches(File file, Collection collection) {
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toUpperCase().endsWith(PatchChecker.JAR_EXTENSION) || string.toUpperCase().endsWith(PatchChecker.ZIP_EXTENSION);
            }
        });
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(fileArray[i]);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) continue;
                DummyModuleInfo dummyModuleInfo = new DummyModuleInfo(manifest.getMainAttributes());
                Iterator iterator = collection.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    ModuleInfo moduleInfo = (ModuleInfo)iterator.next();
                    if (!dummyModuleInfo.getCodeNameBase().equals(moduleInfo.getCodeNameBase())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                collection.add(dummyModuleInfo);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

