/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.autoupdate.CertificateDialog;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.SelectModulesPanel;
import org.netbeans.modules.autoupdate.ServerPanel;
import org.netbeans.modules.autoupdate.SignVerifier;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

class ResultsPanel
extends JPanel {
    private static final String SPACE = " ";
    private static final String BAD_DOWNLOAD = " " + ResultsPanel.getBundle("CTL_BAD_DOWNLOAD") + " ";
    private static final String CORRUPTED = " " + ResultsPanel.getBundle("CTL_CORRUPTED") + " ";
    private static final String NOT_SIGNED = " " + ResultsPanel.getBundle("CTL_NOT_SIGNED") + " ";
    private static final String SIGNED = " " + ResultsPanel.getBundle("CTL_SIGNED") + " ";
    private static final String TRUSTED = " " + ResultsPanel.getBundle("CTL_TRUSTED") + " ";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.autoupdate.ResultsPanel");
    private Wizard.Validator validator;
    private int modulesOK;
    private JTable table;
    private ResultsTableModel model;
    private static JButton yesToAll;
    private boolean includeAll = false;
    private boolean globalAll = false;
    static final long serialVersionUID = -6053101371836354161L;
    private static File defaultDir;
    private ButtonGroup buttonGroup1;
    private JButton certificateButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton saveButton;

    public ResultsPanel(Wizard.Validator validator) {
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(3));
        this.setName(ResultsPanel.getBundle("LBL_View"));
        this.initComponents();
        this.validator = validator;
        this.model = new ResultsTableModel();
        this.table = new ServerPanel.AutoResizeTable((TableModel)this.model, 2);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new BooleanRenderer());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ResultsCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new BooleanRenderer());
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(48);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(480);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(48);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.jScrollPane1.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ResultsPanel.this.selectionChange();
            }
        });
        this.selectionChange();
        this.getAccessibleContext().setAccessibleName(ResultsPanel.getBundle("LBL_View"));
        this.getAccessibleContext().setAccessibleDescription(ResultsPanel.getBundle("LBL_41"));
        this.certificateButton.getAccessibleContext().setAccessibleDescription(ResultsPanel.getBundle("ACS_View"));
        this.table.getAccessibleContext().setAccessibleDescription(ResultsPanel.getBundle("ACS_Module_List"));
        this.jLabel1.setLabelFor(this.table);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.certificateButton = new JButton();
        this.saveButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jTextArea1.setBackground(this.getBackground());
        this.jTextArea1.setFont(new Font("Dialog", 0, this.jTextArea1.getFont().getSize()));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(ResultsPanel.getBundle("LBL_41"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jTextArea1.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResultsPanel.getBundle("LAB_ModulesList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.certificateButton, (String)ResultsPanel.getBundle("BTN_View"));
        this.buttonGroup1.add(this.certificateButton);
        this.certificateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.certificateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.certificateButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.saveButton, (String)ResultsPanel.getBundle("BTN_SaveCopy"));
        this.buttonGroup1.add(this.saveButton);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.saveButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 11, 0, 0);
        this.jPanel1.add((Component)this.saveButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        try {
            File file = this.getSaveCopyDir();
            if (file == null) {
                return;
            }
            ModuleUpdate moduleUpdate = this.getListSelection();
            File file2 = new File(file, moduleUpdate.getDistributionFilename());
            if (file2.exists()) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)ResultsPanel.getBundle("MSG_OverwriteConfirmation"), 0);
                if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) {
                    return;
                }
            }
            Downloader.saveCopy(this.getListSelection(), file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.attachLocalizedMessage((Throwable)fileNotFoundException, (String)NbBundle.getMessage(ResultsPanel.class, (String)"CTL_Directory_not_exits"));
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)fileNotFoundException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
    }

    private void certificateButtonActionPerformed(ActionEvent actionEvent) {
        int n = CertificateDialog.showDialog(this.getListSelection().getCerts(), this.getListSelection().getSecurity());
        this.doCertAction(n, this.getListSelection());
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    private void doInclude(ModuleUpdate moduleUpdate) {
        if (moduleUpdate.isForcedGlobal() && Downloader.bannedWriteToInstall(moduleUpdate)) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResultsPanel.class, (String)"MSG_CannotInstall_2", (Object)moduleUpdate.getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (moduleUpdate.getSecurity() == 2) {
            if (moduleUpdate.isInstallApproved()) {
                moduleUpdate.setInstallApproved(false);
                this.checkValidity();
            } else {
                Object object = null;
                if (!this.includeAll) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)ResultsPanel.getBundle("MSG_NotSignedConfirmation"), ResultsPanel.getBundle("CTL_NotSignedConfirmation"), 0);
                    confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, this.getYesToAll()});
                    object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object.equals(this.getYesToAll())) {
                        this.includeAll = true;
                    }
                }
                if (this.includeAll || object.equals(NotifyDescriptor.YES_OPTION)) {
                    moduleUpdate.setInstallApproved(true);
                    this.checkValidity();
                }
            }
        } else if (moduleUpdate.getSecurity() == 3 || moduleUpdate.getSecurity() == 4) {
            this.doCertAction(CertificateDialog.showDialog(moduleUpdate.getCerts(), moduleUpdate.getSecurity()), moduleUpdate);
        } else if (moduleUpdate.getSecurity() == 1) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_CorruptedJAR"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_BadDownload"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    private void doGlobal(ModuleUpdate moduleUpdate) throws IllegalArgumentException {
        if (moduleUpdate.isForcedGlobal()) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResultsPanel.class, (String)"MSG_InstallDepending", (Object)moduleUpdate.getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (Downloader.bannedWriteToInstall(moduleUpdate)) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_InstallNoWrite"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (moduleUpdate.isGlobal() != null) {
            if (moduleUpdate.isGlobal().booleanValue()) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResultsPanel.class, (String)"MSG_InstallGloballyForced", (Object)moduleUpdate.getName()), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResultsPanel.class, (String)"MSG_InstallLocallyForced", (Object)moduleUpdate.getName()), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        if (moduleUpdate.isToInstallDir()) {
            Object object = null;
            if ("".equals(ResultsPanel.getBundle("MSG_InstallLocallyConfirmation"))) {
                moduleUpdate.setToInstallDir(false);
            } else {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ResultsPanel.class, (String)"MSG_InstallLocallyConfirmation", (Object)moduleUpdate.getName()), 0);
                confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
                object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object.equals(NotifyDescriptor.YES_OPTION)) {
                    moduleUpdate.setToInstallDir(false);
                }
            }
        } else {
            Object object = null;
            if (!this.globalAll) {
                if ("".equals(ResultsPanel.getBundle("MSG_InstallGloballyConfirmation"))) {
                    moduleUpdate.setToInstallDir(false);
                } else {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ResultsPanel.class, (String)"MSG_InstallGloballyConfirmation", (Object)moduleUpdate.getName()), 0);
                    confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION, this.getYesToAll()});
                    object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object.equals(this.getYesToAll())) {
                        this.globalAll = true;
                    }
                }
            }
            if (this.globalAll || object.equals(NotifyDescriptor.YES_OPTION)) {
                moduleUpdate.setToInstallDir(true);
            }
        }
        this.table.invalidate();
        this.table.repaint();
        this.selectionChange();
    }

    void doCertAction(int n, ModuleUpdate moduleUpdate) {
        switch (n) {
            case 1: {
                this.setApproved4All(moduleUpdate.getCerts(), true, -1);
                this.checkValidity();
                break;
            }
            case 4: {
                this.setApproved4All(moduleUpdate.getCerts(), false, -1);
                this.checkValidity();
                break;
            }
            case 3: {
                this.setApproved4All(moduleUpdate.getCerts(), false, 3);
                this.checkValidity();
                try {
                    SignVerifier.removeCertificates(moduleUpdate.getCerts());
                }
                catch (CertificateException certificateException) {
                    LOG.log(Level.WARNING, null, certificateException);
                }
                catch (KeyStoreException keyStoreException) {
                    LOG.log(Level.WARNING, null, keyStoreException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    LOG.log(Level.WARNING, null, noSuchAlgorithmException);
                }
                break;
            }
            case 2: {
                this.setApproved4All(moduleUpdate.getCerts(), true, 4);
                this.checkValidity();
                try {
                    SignVerifier.addCertificates(moduleUpdate.getCerts());
                }
                catch (CertificateException certificateException) {
                    LOG.log(Level.WARNING, null, certificateException);
                }
                catch (KeyStoreException keyStoreException) {
                    LOG.log(Level.WARNING, null, keyStoreException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    LOG.log(Level.WARNING, null, noSuchAlgorithmException);
                }
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setApproved4All(Collection collection, boolean bl, int n) {
        if (collection == null) {
            return;
        }
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)this.model.getValueAt(i, 1);
            boolean bl2 = Downloader.bannedWriteToInstall(moduleUpdate);
            if (bl && moduleUpdate.isForcedGlobal() && bl2 || moduleUpdate.getCerts() == null || !collection.containsAll(moduleUpdate.getCerts())) continue;
            moduleUpdate.setInstallApproved(bl);
            if (n != 4 && n != 3) continue;
            moduleUpdate.setSecurity(n);
        }
    }

    int generateResults() {
        ModuleUpdate moduleUpdate;
        this.modulesOK = 0;
        ArrayList<ModuleUpdate> arrayList = new ArrayList<ModuleUpdate>();
        Collection collection = Wizard.getAllModules();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        int n = -1;
        while (iterator.hasNext()) {
            moduleUpdate = (ModuleUpdate)iterator.next();
            if (!moduleUpdate.isSelected()) continue;
            arrayList.add(moduleUpdate);
            if (moduleUpdate.isDownloadOK()) {
                ++this.modulesOK;
                if (n == -1 && !moduleUpdate.isInstallApproved()) {
                    n = arrayList.size() - 1;
                }
            }
            if (!moduleUpdate.isForcedGlobal()) continue;
            boolean bl2 = Downloader.bannedWriteToInstall(moduleUpdate);
            if (bl2) {
                moduleUpdate.setInstallApproved(false);
                bl = true;
            }
            moduleUpdate.setToInstallDir(true);
        }
        if (bl) {
            moduleUpdate = new NotifyDescriptor.Message((Object)ResultsPanel.getBundle("MSG_CannotInstall_1"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)moduleUpdate);
        }
        this.model.refreshContent(arrayList);
        if (n == -1) {
            n = 0;
        }
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
        this.checkValidity();
        this.selectionChange();
        this.includeAll = false;
        this.globalAll = false;
        return this.modulesOK;
    }

    private void selectionChange() {
        ModuleUpdate moduleUpdate = this.getListSelection();
        if (moduleUpdate != null && (moduleUpdate.getSecurity() == 3 || moduleUpdate.getSecurity() == 4)) {
            this.certificateButton.setEnabled(true);
        } else {
            this.certificateButton.setEnabled(false);
        }
        if (moduleUpdate != null && moduleUpdate.getSecurity() != 0) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
    }

    private ModuleUpdate getListSelection() {
        int n = this.table.getSelectionModel().getMinSelectionIndex();
        if (n < 0) {
            return null;
        }
        return (ModuleUpdate)this.model.getValueAt(n, 1);
    }

    private void checkValidity() {
        boolean bl = false;
        Collection collection = Wizard.getAllModules();
        for (ModuleUpdate moduleUpdate : collection) {
            if (!moduleUpdate.isSelected() || !moduleUpdate.isInstallApproved()) continue;
            bl = true;
        }
        this.validator.setValid(bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getSaveCopyDir() throws FileNotFoundException {
        Serializable serializable;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ResultsPanel.class, (String)"CTL_FileChooserSC_Title", (Object)this.getListSelection().getDistributionFilename()));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.canWrite();
            }

            public String getDescription() {
                return ResultsPanel.getBundle("CTL_FileFilterSCDescription");
            }
        });
        if (defaultDir == null) {
            defaultDir = SelectModulesPanel.getDefaultDir();
        }
        if (defaultDir != null) {
            serializable = defaultDir.getParentFile();
            if (serializable != null) {
                jFileChooser.setCurrentDirectory((File)serializable);
                jFileChooser.setSelectedFile(defaultDir);
            } else {
                jFileChooser.setCurrentDirectory(defaultDir);
            }
        }
        serializable = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        File file = null;
        if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), ResultsPanel.getBundle("CTL_Save")) == 0) {
            defaultDir = jFileChooser.getSelectedFile();
            if (!defaultDir.exists()) throw new FileNotFoundException(defaultDir.getAbsolutePath());
            file = defaultDir;
        } else {
            file = null;
        }
        if (serializable == null) return file;
        ((Window)serializable).toFront();
        return file;
    }

    private JButton getYesToAll() {
        if (yesToAll == null) {
            yesToAll = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)yesToAll, (String)ResultsPanel.getBundle("CTL_Yes_All"));
            yesToAll.getAccessibleContext().setAccessibleName(ResultsPanel.getBundle("ACSN_Yes_All"));
            yesToAll.getAccessibleContext().setAccessibleDescription(ResultsPanel.getBundle("ACSD_Yes_All"));
        }
        return yesToAll;
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(ResultsPanel.class, (String)string);
    }

    static Font doDeriveFont(Font font, int n) {
        if (Utilities.isMac()) {
            return new Font(font.getName(), n, font.getSize());
        }
        return font.deriveFont(n);
    }

    static {
        defaultDir = null;
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorder(new LineBorder((Color)UIManager.getDefaults().get("Button.focus")));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setBorderPainted(bl && jTable.getSelectedColumn() == n2);
            this.setSelected(object != null && (Boolean)object != false);
            return this;
        }
    }

    private class ResultsCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel nameLabel;
        private JLabel securityLabel;

        public ResultsCellRenderer() {
            this.initComponents();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = "";
            if (object == null) {
                object = ResultsPanel.this.model.getValueAt(n, n2);
            }
            switch (((ModuleUpdate)object).getSecurity()) {
                case 0: {
                    string = BAD_DOWNLOAD;
                    break;
                }
                case 1: {
                    string = CORRUPTED;
                    break;
                }
                case 2: {
                    string = NOT_SIGNED;
                    break;
                }
                case 3: {
                    StringBuffer stringBuffer = new StringBuffer(SIGNED);
                    stringBuffer.append(ResultsPanel.SPACE + ResultsPanel.getBundle("CTL_By"));
                    Collection collection = ((ModuleUpdate)object).getCerts();
                    for (Certificate certificate : collection) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        stringBuffer.append(ResultsPanel.SPACE).append(((X509Certificate)certificate).getSubjectDN().getName());
                    }
                    string = stringBuffer.toString();
                    break;
                }
                case 4: {
                    string = TRUSTED;
                }
            }
            if (bl) {
                this.setBackground((Color)UIManager.getDefaults().get("Table.selectionBackground"));
                this.nameLabel.setForeground((Color)UIManager.getDefaults().get("Table.selectionForeground"));
                this.securityLabel.setForeground((Color)UIManager.getDefaults().get("Table.selectionForeground"));
            } else {
                this.setBackground((Color)UIManager.getDefaults().get("Table.background"));
                this.nameLabel.setForeground((Color)UIManager.getDefaults().get("Table.Foreground"));
                this.securityLabel.setForeground((Color)UIManager.getDefaults().get("Table.Foreground"));
            }
            this.nameLabel.setText(((ModuleUpdate)object).getName() + "  " + ResultsPanel.getBundle("CTL_Version") + ((ModuleUpdate)object).getRemoteModule().getSpecificationVersion());
            this.securityLabel.setText(string);
            return this;
        }

        private void initComponents() {
            this.nameLabel = new JLabel();
            this.securityLabel = new JLabel();
            this.setLayout(new GridBagLayout());
            this.nameLabel.setFont(ResultsPanel.doDeriveFont(this.nameLabel.getFont(), 1));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            this.add((Component)this.nameLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.securityLabel, gridBagConstraints);
        }
    }

    class ResultsTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{ResultsPanel.access$300("LBL_42"), ResultsPanel.access$300("LBL_43"), ResultsPanel.access$300("LBL_Global")};
        private List modulelist = new ArrayList();

        ResultsTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.modulelist.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((ModuleUpdate)this.modulelist.get(n)).isInstallApproved() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (n2 == 1) {
                return this.modulelist.get(n);
            }
            ModuleUpdate moduleUpdate = (ModuleUpdate)this.modulelist.get(n);
            return moduleUpdate.isToInstallDir();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (object instanceof Boolean) {
                if (n2 == 0) {
                    ResultsPanel.this.doInclude((ModuleUpdate)this.modulelist.get(n));
                } else {
                    try {
                        ResultsPanel.this.doGlobal((ModuleUpdate)this.modulelist.get(n));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOG.log(Level.WARNING, null, illegalArgumentException);
                    }
                }
            }
        }

        void refreshContent(List list) {
            this.modulelist = list;
        }
    }
}

