/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.DownloadProgressPanel;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.util.NbBundle;

class SignVerifier {
    private static final String KS_PSSWD = "open4all";
    private static final String ENTRY_SEPARATOR = "/";
    private static final String NBM_MAIN = "main";
    private static final String NBM_MODULES = "netbeans/modules";
    private static final String NBM_AUTOLOAD = "netbeans/modules/autoload";
    private static final String NBM_EAGER = "netbeans/modules/eager";
    private static final String JAR_EXT = ".jar";
    public static final int NOT_CHECKED = -1;
    public static final int BAD_DOWNLOAD = 0;
    public static final int CORRUPTED = 1;
    public static final int NOT_SIGNED = 2;
    public static final int SIGNED = 3;
    public static final int TRUSTED = 4;
    private static final String NEW_LINE = "\n";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    DownloadProgressPanel progressDialog;
    private Wizard.Validator validator;
    private int verifySize;
    private int totalVerified;
    private long modulesCount;
    private boolean verifyCanceled = false;
    private boolean wizardCanceled = false;
    ProgressHandle partialHandle;
    ProgressHandle overallHandle;
    long startTime;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate");

    SignVerifier(DownloadProgressPanel downloadProgressPanel, Wizard.Validator validator) {
        this.validator = validator;
        this.progressDialog = downloadProgressPanel;
    }

    void doVerify() {
        this.verifyCanceled = false;
        this.progressDialog.setPartialLabel(SignVerifier.getBundle("CTL_PreparingVerify_Label"));
        this.verifySize = this.getTotalVerifySize();
        err.log(Level.FINE, "Runing doVerify, check the total size " + this.verifySize + ", verifyCanceled? " + this.verifyCanceled);
        if (this.verifyCanceled) {
            return;
        }
        this.verifyAll();
        err.log(Level.FINE, "Verification done.");
        if (this.verifyCanceled) {
            return;
        }
        this.validator.setValid(true);
    }

    private int getTotalVerifySize() {
        int n = 0;
        this.modulesCount = 0L;
        for (ModuleUpdate moduleUpdate : Wizard.getAllModules()) {
            if (!moduleUpdate.isSelected() || !moduleUpdate.isDownloadOK() || moduleUpdate.getSecurity() != -1 && moduleUpdate.getSecurity() != 0) continue;
            File file = Downloader.getNBM(moduleUpdate);
            n = (int)((long)n + file.length());
            ++this.modulesCount;
        }
        return n;
    }

    void verifyAll() {
        Object object;
        this.overallHandle = this.getOverallHandle(this.verifySize);
        this.progressDialog.setPartialLabel("");
        this.progressDialog.setOverallLabel("");
        this.progressDialog.setExtraLabel("");
        int n = 0;
        this.totalVerified = 0;
        Iterator iterator = Wizard.getAllModules().iterator();
        while (iterator.hasNext()) {
            if (this.verifyCanceled) {
                return;
            }
            object = (ModuleUpdate)iterator.next();
            if (!((ModuleUpdate)object).isSelected() || !((ModuleUpdate)object).isDownloadOK() || ((ModuleUpdate)object).getSecurity() != -1 && ((ModuleUpdate)object).getSecurity() != 0) continue;
            if (this.verifyCanceled) {
                return;
            }
            this.progressDialog.setPartialLabel(((ModuleUpdate)object).getName() + " [" + (n + 1) + ENTRY_SEPARATOR + this.modulesCount + "]");
            File file = Downloader.getNBM((ModuleUpdate)object);
            try {
                Collection collection = this.verifyJar(file, (ModuleUpdate)object);
                if (collection == null) {
                    err.log(Level.FINE, ((ModuleUpdate)object).getName() + " was verified as NOT_SIGNED");
                    ((ModuleUpdate)object).setSecurity(2);
                    ((ModuleUpdate)object).setInstallApproved(false);
                } else {
                    ((ModuleUpdate)object).setCerts(collection);
                    if (this.isTrusted(collection)) {
                        err.log(Level.FINE, ((ModuleUpdate)object).getName() + " was verified as TRUSTED");
                        ((ModuleUpdate)object).setSecurity(4);
                        ((ModuleUpdate)object).setInstallApproved(true);
                    } else {
                        err.log(Level.FINE, ((ModuleUpdate)object).getName() + " was verified as SIGNED");
                        ((ModuleUpdate)object).setSecurity(3);
                        ((ModuleUpdate)object).setInstallApproved(false);
                    }
                }
            }
            catch (SecurityException securityException) {
                err.log(Level.FINE, ((ModuleUpdate)object).getName() + " was verified as CORRUPTED");
                ((ModuleUpdate)object).setSecurity(1);
                ((ModuleUpdate)object).setInstallApproved(false);
            }
            catch (IOException iOException) {
                err.log(Level.FINE, ((ModuleUpdate)object).getName() + " was verified as BAD_DOWNLOAD");
                ((ModuleUpdate)object).setSecurity(0);
                ((ModuleUpdate)object).setInstallApproved(false);
                ((ModuleUpdate)object).setDownloadOK(false);
            }
            catch (NullPointerException nullPointerException) {
                err.log(Level.FINE, ((ModuleUpdate)object).getName() + " was verified as BAD_DOWNLOAD");
                ((ModuleUpdate)object).setSecurity(0);
                ((ModuleUpdate)object).setInstallApproved(false);
                ((ModuleUpdate)object).setDownloadOK(false);
            }
            ++n;
            this.overallHandle.progress(this.totalVerified);
        }
        this.overallHandle.finish();
        object = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.verifySize / 1024), new Integer(this.verifySize / 1024)});
        this.progressDialog.setOverallLabel((String)object);
    }

    static void processJarEntry(JarEntry jarEntry, ModuleUpdate moduleUpdate) {
        if (jarEntry.getName().startsWith("netbeans/lib/")) {
            moduleUpdate.setDepending(true);
        }
        if (jarEntry.getName().startsWith(NBM_MAIN)) {
            moduleUpdate.setSafeToInstall(false);
        }
        String string = null;
        if (jarEntry.getName().startsWith(NBM_AUTOLOAD) && jarEntry.getName().endsWith(JAR_EXT)) {
            string = SignVerifier.getJarModuleName(jarEntry.getName(), "netbeans/modules/autoload/");
            if (string != null) {
                moduleUpdate.addToJarList(string);
            }
        } else if (jarEntry.getName().startsWith(NBM_EAGER) && jarEntry.getName().endsWith(JAR_EXT)) {
            string = SignVerifier.getJarModuleName(jarEntry.getName(), "netbeans/modules/eager/");
            if (string != null) {
                moduleUpdate.addToJarList(string);
            }
        } else if (jarEntry.getName().startsWith(NBM_MODULES) && jarEntry.getName().endsWith(JAR_EXT) && (string = SignVerifier.getJarModuleName(jarEntry.getName(), "netbeans/modules/")) != null) {
            moduleUpdate.addToJarList(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection verifyJar(File file, ModuleUpdate moduleUpdate) throws SecurityException, IOException {
        Cloneable cloneable;
        Object var3_3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = (int)file.length();
        this.partialHandle = this.getPartialHandle(n2);
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        LinkedList<JarEntry> linkedList = new LinkedList<JarEntry>();
        byte[] byArray = new byte[8192];
        try {
            while (enumeration.hasMoreElements()) {
                Collection collection;
                cloneable = enumeration.nextElement();
                SignVerifier.processJarEntry((JarEntry)cloneable, moduleUpdate);
                linkedList.add((JarEntry)cloneable);
                Object object = null;
                try {
                    int n3;
                    object = jarFile.getInputStream((ZipEntry)cloneable);
                    while ((n3 = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
                        if (++n % 4096 == 0) {
                            this.partialHandle.progress(n < n2 ? n : n2);
                        }
                        if (!this.verifyCanceled) continue;
                        collection = null;
                        if (object == null) break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                    this.totalVerified = (int)((long)this.totalVerified + ((ZipEntry)cloneable).getCompressedSize());
                    String string = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                    this.progressDialog.setOverallLabel(string);
                    throw throwable;
                }
                {
                    block18: {
                        ((InputStream)object).close();
                    }
                    this.totalVerified = (int)((long)this.totalVerified + ((ZipEntry)cloneable).getCompressedSize());
                    String string = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                    this.progressDialog.setOverallLabel(string);
                    return collection;
                }
                if (object != null) {
                    ((InputStream)object).close();
                }
                this.totalVerified = (int)((long)this.totalVerified + ((ZipEntry)cloneable).getCompressedSize());
                String object2 = NbBundle.getMessage(SignVerifier.class, (String)"FMT_VerifiedTotal", (Object[])new Object[]{new Integer(this.totalVerified / 1024), new Integer(this.verifySize / 1024)});
                this.progressDialog.setOverallLabel(object2);
            }
            err.log(Level.FINE, "Update " + moduleUpdate.getCodeNameBase() + " was verified as forced to intall global: " + moduleUpdate.isForcedGlobal() + " and safeToInstall: " + moduleUpdate.isSafeToInstall());
            if (this.verifyCanceled) {
                cloneable = null;
                return cloneable;
            }
        }
        finally {
            jarFile.close();
            if (this.wizardCanceled) {
                Downloader.getNBM(moduleUpdate).delete();
            }
        }
        this.partialHandle.finish();
        cloneable = new HashSet();
        if (manifest != null) {
            for (JarEntry jarEntry : linkedList) {
                String string = jarEntry.getName();
                Certificate[] certificateArray = jarEntry.getCertificates();
                boolean bl3 = certificateArray != null && certificateArray.length > 0;
                bl |= bl3;
                if (certificateArray != null) {
                    for (int i = 0; i < certificateArray.length; ++i) {
                        cloneable.add(certificateArray[i]);
                        if (!this.verifyCanceled) continue;
                        return null;
                    }
                    continue;
                }
                if (jarEntry.isDirectory() || string.toUpperCase().startsWith("META-INF/") || jarEntry.getSize() == 0L) continue;
                bl2 = true;
            }
        }
        if (bl && bl2) {
            throw new SecurityException(SignVerifier.getBundle("EXC_NotSignedEntity"));
        }
        return bl ? cloneable : null;
    }

    public static String formatCerts(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 300);
        for (Certificate certificate : collection) {
            if (certificate instanceof X509Certificate) {
                try {
                    stringBuffer.append("\n\n");
                    stringBuffer.append(SignVerifier.X509CertToString((X509Certificate)certificate));
                }
                catch (Exception exception) {
                    stringBuffer.append(certificate.toString());
                }
            } else {
                stringBuffer.append(certificate.toString());
            }
            stringBuffer.append("\n\n");
        }
        return stringBuffer.toString();
    }

    boolean isTrusted(Collection collection) {
        Collection collection2 = this.getTrustedCerts();
        if (collection2.size() <= 0 || collection.size() <= 0) {
            return false;
        }
        return collection2.containsAll(collection);
    }

    static void addCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getKSFile(), KS_PSSWD, null);
        for (Certificate certificate : collection) {
            if (keyStore.getCertificateAlias(certificate) != null) continue;
            String string = null;
            for (int i = 0; i < 9999 && keyStore.containsAlias(string = "genAlias" + i); ++i) {
            }
            if (string == null) {
                throw new KeyStoreException(SignVerifier.getBundle("EXC_TooManyCertificates"));
            }
            keyStore.setCertificateEntry(string, certificate);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getKSFile(), KS_PSSWD, null);
    }

    static void removeCertificates(Collection collection) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = SignVerifier.getKeyStore(Autoupdater.Support.getKSFile(), KS_PSSWD, null);
        for (Certificate certificate : collection) {
            String string = keyStore.getCertificateAlias(certificate);
            if (string == null) continue;
            keyStore.deleteEntry(string);
        }
        SignVerifier.saveKeyStore(keyStore, Autoupdater.Support.getKSFile(), KS_PSSWD, null);
    }

    Collection getTrustedCerts() {
        ArrayList arrayList = new ArrayList(10);
        File file = Autoupdater.Support.getKSFile();
        try {
            if (file.canRead()) {
                KeyStore keyStore = SignVerifier.getKeyStore(file, KS_PSSWD, null);
                arrayList.addAll(SignVerifier.getCertificates(keyStore));
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (IOException iOException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return arrayList;
    }

    private static KeyStore getKeyStore(File file, String string, String string2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (file == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        KeyStore keyStore = null;
        if (string2 == null) {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, string.toCharArray());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return keyStore;
    }

    public static void saveKeyStore(KeyStore keyStore, File file, String string, String string2) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        if (file == null) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        keyStore.store(fileOutputStream, string.toCharArray());
        ((OutputStream)fileOutputStream).close();
    }

    public static Collection getCertificates(KeyStore keyStore) throws KeyStoreException {
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>(10);
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }

    void cancelVerify(boolean bl) {
        this.verifyCanceled = true;
        this.wizardCanceled = bl;
    }

    private static String X509CertToString(X509Certificate x509Certificate) throws Exception {
        return SignVerifier.getBundle("MSG_Owner") + SPACE + x509Certificate.getSubjectDN() + NEW_LINE + SignVerifier.getBundle("MSG_Issuer") + SPACE + x509Certificate.getIssuerDN() + NEW_LINE + SignVerifier.getBundle("MSG_SerNumber") + SPACE + x509Certificate.getSerialNumber().toString(16) + NEW_LINE + SignVerifier.getBundle("MSG_Valid") + SPACE + x509Certificate.getNotBefore().toString() + SPACE + SignVerifier.getBundle("MSG_Until") + SPACE + x509Certificate.getNotAfter().toString() + NEW_LINE + SignVerifier.getBundle("MSG_CertFinger") + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_MD5") + SPACE + SPACE + SignVerifier.getCertFingerPrint("MD5", x509Certificate) + NEW_LINE + SPACE + TAB + SignVerifier.getBundle("MSG_SHA1") + SPACE + SignVerifier.getCertFingerPrint("SHA1", x509Certificate);
    }

    private static String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return SignVerifier.toHexString(byArray2);
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            SignVerifier.byte2hex(byArray[i], stringBuffer);
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private static String getJarModuleName(String string, String string2) {
        if (string.substring(string2.length()).indexOf(ENTRY_SEPARATOR) == -1) {
            String string3 = "netbeans/modules/";
            return string.substring(string3.length());
        }
        return null;
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(SignVerifier.class, (String)string);
    }

    private ProgressHandle getPartialHandle(int n) {
        assert (this.progressDialog != null);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)SignVerifier.getBundle("DownloadProgressPanel_partialHandle_name"));
        this.progressDialog.setPartialProgressComponent(progressHandle);
        progressHandle.start(n);
        return progressHandle;
    }

    private ProgressHandle getOverallHandle(int n) {
        assert (this.progressDialog != null);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)SignVerifier.getBundle("DownloadProgressPanel_overallHandle_name"));
        this.progressDialog.setOverallProgressComponent(progressHandle);
        progressHandle.start(n);
        return progressHandle;
    }
}

