/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.autoupdate.DependencyChecker;
import org.netbeans.modules.autoupdate.Downloader;
import org.netbeans.modules.autoupdate.DuplicateWarningDialog;
import org.netbeans.modules.autoupdate.ExternalDialog;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.LicenceDialog;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Notification;
import org.netbeans.modules.autoupdate.PreparedModules;
import org.netbeans.modules.autoupdate.SelectedListCellRenderer;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.UpdateNode;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class UpdatePanel
extends JPanel {
    private static final String EMPTY_STRING = "";
    private static final Dimension PREFERRED_SIZE = new Dimension(600, 500);
    private static final String SPACE = " ";
    private static final transient HashSet acceptedLicencies = new HashSet(10);
    private ExplorerView explorerView;
    private DefaultListModel selectedListModel;
    private long totalSize;
    private Wizard.Validator validator;
    private UpdateNode.AllServers allNodes;
    private int duplicateStatus = 0;
    private PropertyChangeListener nodeListener;
    static final long serialVersionUID = 897622109141801200L;
    static final String LINE_SEPARATOR = "<br>";
    private JButton addButton;
    private JButton addallButton;
    private JLabel avLabel;
    private JTextField avTextField;
    private JEditorPane description;
    private JLabel ivLabel;
    private JTextField ivTextField;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton moreButton;
    private JLabel panel1Label;
    private JButton removeButton;
    private JButton removeallButton;
    private JLabel scrollpaneLabel;
    private JLabel totalsizeLabel;
    private JTextField totalsizeTextField;

    public UpdatePanel(Wizard.Validator validator) {
        Serializable serializable;
        this.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.putClientProperty("WizardPanel_contentData", new String[]{UpdatePanel.getBundle("WIZ_First"), UpdatePanel.getBundle("WIZ_Select"), UpdatePanel.getBundle("WIZ_Download"), UpdatePanel.getBundle("WIZ_View")});
        this.initComponents();
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        if (styleSheet.getStyleSheets() == null) {
            serializable = new StyleSheet();
            Font font = this.jList1.getFont();
            int n = this.jList1.getFont().getSize();
            serializable.addRule(new StringBuffer("body { font-size: ").append(n).append("; font-family: ").append(font.getName()).append("; }").toString());
            serializable.addStyleSheet(styleSheet);
            hTMLEditorKit.setStyleSheet((StyleSheet)serializable);
        }
        this.description.setEditorKit(hTMLEditorKit);
        this.setName(UpdatePanel.getBundle("LAB_Select2"));
        this.validator = validator;
        this.explorerView = new ExplorerView();
        this.explorerView.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "selectedNodes") {
                    UpdatePanel.this.selectionChange(true);
                }
            }
        });
        this.jList1.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                UpdatePanel.this.unselectLeft();
                if (UpdatePanel.this.jList1.getSelectedIndex() == -1 && UpdatePanel.this.selectedListModel.getSize() > 0) {
                    UpdatePanel.this.jList1.setSelectedIndex(0);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).insets = new Insets(0, 3, 0, 3);
        this.jPanel1.add((Component)this.explorerView, serializable);
        this.jList1.setCellRenderer(new SelectedListCellRenderer());
        this.selectedListModel = new DefaultListModel();
        this.jList1.setModel(this.selectedListModel);
        this.jList1.getSelectionModel().setSelectionMode(2);
        this.jList1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                UpdatePanel.this.selectionChange(false);
            }
        });
        this.panel1Label.setLabelFor(this.explorerView);
        this.getAccessibleContext().setAccessibleName(UpdatePanel.getBundle("ACS_UpdatePanel"));
        this.getAccessibleContext().setAccessibleDescription(UpdatePanel.getBundle("ACSD_UpdatePanel") + UpdatePanel.getBundle("LAB_227"));
        this.moreButton.getAccessibleContext().setAccessibleDescription(UpdatePanel.getBundle("ACS_More"));
        this.jList1.getAccessibleContext().setAccessibleDescription(UpdatePanel.getBundle("ACS_InstallList"));
        this.explorerView.setName(UpdatePanel.getBundle("ACSN_ExplorerView"));
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    private void initComponents() {
        this.panel1Label = new JLabel();
        this.jPanel1 = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.addallButton = new JButton();
        this.removeallButton = new JButton();
        this.scrollpaneLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel3 = new JPanel();
        this.totalsizeLabel = new JLabel();
        this.totalsizeTextField = new JTextField();
        this.jPanel2 = new JPanel();
        this.avLabel = new JLabel();
        this.avTextField = new JTextField();
        this.ivLabel = new JLabel();
        this.ivTextField = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.description = new JEditorPane();
        this.moreButton = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.panel1Label, (String)UpdatePanel.getBundle("LAB_221"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.panel1Label, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)UpdatePanel.getBundle("BTN_Add_2"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 12, 0, 12);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)UpdatePanel.getBundle("BTN_Remove_2"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addallButton, (String)UpdatePanel.getBundle("BTN_AddAll_2"));
        this.addallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.addallButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.addallButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeallButton, (String)UpdatePanel.getBundle("BTN_RemoveAll_2"));
        this.removeallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.removeallButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.removeallButton, gridBagConstraints);
        this.scrollpaneLabel.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.scrollpaneLabel, (String)UpdatePanel.getBundle("LAB_222"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.scrollpaneLabel, gridBagConstraints);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                UpdatePanel.this.jList1MouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(1, 2, 6, 0));
        this.totalsizeLabel.setHorizontalAlignment(4);
        this.totalsizeLabel.setLabelFor(this.totalsizeTextField);
        Mnemonics.setLocalizedText((JLabel)this.totalsizeLabel, (String)UpdatePanel.getBundle("LAB_223"));
        this.jPanel3.add(this.totalsizeLabel);
        this.totalsizeTextField.setEditable(false);
        this.totalsizeTextField.setDisabledTextColor(Color.black);
        this.totalsizeTextField.setMinimumSize(new Dimension(6, 20));
        this.jPanel3.add(this.totalsizeTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.avLabel.setLabelFor(this.avTextField);
        Mnemonics.setLocalizedText((JLabel)this.avLabel, (String)UpdatePanel.getBundle("LAB_224"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 0, 0);
        this.jPanel2.add((Component)this.avLabel, gridBagConstraints);
        this.avTextField.setEditable(false);
        this.avTextField.setDisabledTextColor(Color.black);
        this.avTextField.setMinimumSize(new Dimension(60, 21));
        this.avTextField.setPreferredSize(new Dimension(60, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.jPanel2.add((Component)this.avTextField, gridBagConstraints);
        this.ivLabel.setLabelFor(this.ivTextField);
        Mnemonics.setLocalizedText((JLabel)this.ivLabel, (String)UpdatePanel.getBundle("LAB_225"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.jPanel2.add((Component)this.ivLabel, gridBagConstraints);
        this.ivTextField.setEditable(false);
        this.ivTextField.setDisabledTextColor(Color.black);
        this.ivTextField.setMinimumSize(new Dimension(60, 21));
        this.ivTextField.setPreferredSize(new Dimension(63, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.jPanel2.add((Component)this.ivTextField, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(22, 52));
        this.description.setEditable(false);
        this.jScrollPane2.setViewportView(this.description);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 4, 0);
        this.jPanel2.add((Component)this.jScrollPane2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)UpdatePanel.getBundle("BTN_More"));
        this.moreButton.setHorizontalTextPosition(0);
        this.moreButton.setIconTextGap(0);
        this.moreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.moreButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(6, 11, 4, 4);
        this.jPanel2.add((Component)this.moreButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void moreButtonActionPerformed(ActionEvent actionEvent) {
        ModuleUpdate moduleUpdate = this.getSingleSelection();
        if (moduleUpdate != null && moduleUpdate.getHomePage() != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(moduleUpdate.getHomePage());
        }
    }

    private void removeallButtonActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            ((ModuleUpdate)this.selectedListModel.get(i)).setSelected(false);
            ((ModuleUpdate)this.selectedListModel.get(i)).setDownloadOK(false);
            ((ModuleUpdate)this.selectedListModel.get(i)).setSecurity(-1);
        }
        this.refreshNodes();
        this.selectedListModel.clear();
        Downloader.deleteDownload();
        this.showSize();
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.buttonsCheck();
    }

    private void addallButtonActionPerformed(ActionEvent actionEvent) {
        Collection collection = Wizard.getAllModules();
        for (ModuleUpdate moduleUpdate : collection) {
            if (moduleUpdate.isSelected() || !DependencyChecker.checkPlatformDependency(moduleUpdate.getRemoteModule()) || this.addModule(moduleUpdate)) continue;
            this.removeallButtonActionPerformed(actionEvent);
            return;
        }
        this.buttonsCheck();
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jList1.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = nArray.length - 1; i >= 0; --i) {
            arrayList.add(this.selectedListModel.get(nArray[i]));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.removeModule((ModuleUpdate)iterator.next());
        }
        this.refreshNodes();
        this.showSize();
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.buttonsCheck();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.explorerView.getSelectedNodes();
        ArrayList<ModuleUpdate> arrayList = new ArrayList<ModuleUpdate>();
        ModuleUpdate moduleUpdate2 = null;
        for (int i = 0; i < nodeArray.length; ++i) {
            moduleUpdate2 = (ModuleUpdate)nodeArray[i].getCookie(ModuleUpdate.class);
            if (moduleUpdate2 != null) {
                arrayList.add(moduleUpdate2);
                continue;
            }
            arrayList.addAll(this.getUnselectedChildren(nodeArray[i]));
        }
        for (ModuleUpdate moduleUpdate2 : arrayList) {
            if (this.addModule(moduleUpdate2, arrayList)) continue;
            return;
        }
        this.buttonsCheck();
    }

    private void jList1MouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            int n = this.jList1.locationToIndex(mouseEvent.getPoint());
            if (n >= 0 && n < this.selectedListModel.size()) {
                this.removeModule((ModuleUpdate)this.selectedListModel.get(n));
                this.showSize();
                this.validator.setValid(this.selectedListModel.size() > 0);
                this.refreshNodes();
            }
            this.buttonsCheck();
        }
    }

    void setUpdates(int n) {
        boolean bl = true;
        this.allNodes = null;
        this.selectedListModel.clear();
        this.totalSize = 0L;
        for (ModuleUpdate moduleUpdate : Wizard.getAllModules()) {
            if (moduleUpdate.isSelected() && !this.selectedListModel.contains(moduleUpdate)) {
                this.selectedListModel.addElement(moduleUpdate);
                this.totalSize += moduleUpdate.getDownloadSize();
            }
            if (!bl || n != 1 && !moduleUpdate.isPurchased()) continue;
            this.addModule(moduleUpdate);
        }
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.totalsizeTextField.setText(this.totalSize / 1024L + SPACE + UpdatePanel.getBundle("CTL_UpdatePanel_KB"));
        this.buttonsCheck();
        this.showSize();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpdatePanel.this.refreshNodes();
            }
        });
        this.nodeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("nodeDefaultAction".equals(propertyChangeEvent.getPropertyName())) {
                    final Node[] nodeArray = UpdatePanel.this.explorerView.getSelectedNodes();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ModuleUpdate moduleUpdate;
                            if (nodeArray.length == 1 && (moduleUpdate = (ModuleUpdate)nodeArray[0].getCookie(ModuleUpdate.class)) != null && !UpdatePanel.this.addModule(moduleUpdate)) {
                                UpdatePanel.this.buttonsCheck();
                            }
                        }
                    });
                }
            }
        };
        Settings.getShared().addPropertyChangeListener(this.nodeListener);
    }

    private ModuleUpdate getSingleSelection() {
        if (this.jList1.getSelectedIndex() >= 0) {
            return (ModuleUpdate)this.selectedListModel.get(this.jList1.getSelectedIndex());
        }
        Node[] nodeArray = this.explorerView.getSelectedNodes();
        if (nodeArray.length != 1) {
            return null;
        }
        return (ModuleUpdate)nodeArray[0].getCookie(ModuleUpdate.class);
    }

    private void unselectLeft() {
        try {
            this.explorerView.getExplorerManager().setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private String formatDescription(ModuleUpdate moduleUpdate) {
        Date date = moduleUpdate.getReleaseDate();
        String string = date != null ? ModuleUpdate.DATE_FORMAT.format(date) : EMPTY_STRING;
        String string2 = moduleUpdate.getModuleAuthor() == null ? EMPTY_STRING : moduleUpdate.getModuleAuthor();
        String string3 = UpdatePanel.getBundle("LAB_226") + SPACE + moduleUpdate.getDownloadSize() / 1024L + SPACE + UpdatePanel.getBundle("CTL_UpdatePanel_KB") + LINE_SEPARATOR + (string2.length() == 0 ? EMPTY_STRING : UpdatePanel.getBundle("LAB_AuthorName") + SPACE + string2 + LINE_SEPARATOR) + (string.length() == 0 ? EMPTY_STRING : UpdatePanel.getBundle("LAB_ReleaseDate") + SPACE + string + LINE_SEPARATOR) + moduleUpdate.getDescription();
        return string3;
    }

    private void selectionChange(boolean bl) {
        ModuleUpdate moduleUpdate;
        if (bl && this.explorerView.getSelectedNodes().length > 0) {
            this.jList1.clearSelection();
        }
        if ((moduleUpdate = this.getSingleSelection()) == null) {
            this.ivTextField.setText(EMPTY_STRING);
            this.avTextField.setText(EMPTY_STRING);
            this.description.setText(EMPTY_STRING);
        } else {
            this.ivTextField.setText(moduleUpdate.getLocalModule() == null ? UpdatePanel.getBundle("CTL_UpdatePanel_ModuleNotInstalled") : (moduleUpdate.getLocalModule().getSpecificationVersion() == null ? EMPTY_STRING : moduleUpdate.getLocalModule().getSpecificationVersion().toString()));
            SpecificationVersion specificationVersion = moduleUpdate.getRemoteModule().getSpecificationVersion();
            this.avTextField.setText(specificationVersion == null ? EMPTY_STRING : specificationVersion.toString());
            this.description.setText(this.formatDescription(moduleUpdate));
            this.description.setCaretPosition(0);
        }
        this.buttonsCheck();
    }

    private void buttonsCheck() {
        if (this.selectedListModel.getSize() > 0) {
            this.removeallButton.setEnabled(true);
            if (this.jList1.getSelectedIndex() != -1) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        } else {
            this.removeButton.setEnabled(false);
            this.removeallButton.setEnabled(false);
        }
        if (this.existUnselectedModule()) {
            this.addallButton.setEnabled(true);
            if (this.isLeftSelection()) {
                this.addButton.setEnabled(true);
            } else {
                this.addButton.setEnabled(false);
            }
        } else {
            this.addButton.setEnabled(false);
            this.addallButton.setEnabled(false);
        }
        ModuleUpdate moduleUpdate = this.getSingleSelection();
        this.moreButton.setEnabled(moduleUpdate != null && moduleUpdate.getHomePage() != null);
    }

    private boolean isLeftSelection() {
        Node[] nodeArray = this.explorerView.getSelectedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i].getCookie(ModuleUpdate.class) != null) {
                return true;
            }
            List list = this.getUnselectedChildren(nodeArray[i]);
            if (list.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List getUnselectedChildren(Node node) {
        Node[] nodeArray = node.getChildren().getNodes();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object object;
            if (nodeArray[i].getCookie(ModuleUpdate.class) != null) {
                object = (ModuleUpdate)nodeArray[i].getCookie(ModuleUpdate.class);
                if (((ModuleUpdate)object).isSelected()) continue;
                arrayList.add(object);
                continue;
            }
            object = this.getUnselectedChildren(nodeArray[i]);
            if (object.size() <= 0) continue;
            arrayList.addAll((Collection<Object>)object);
        }
        return arrayList;
    }

    private boolean addModule(ModuleUpdate moduleUpdate) {
        return this.addModule(moduleUpdate, null);
    }

    private boolean addModule(ModuleUpdate moduleUpdate, List list) {
        return this.addModule(moduleUpdate, list, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addModule(ModuleUpdate moduleUpdate, List list, boolean bl) {
        List list2;
        Object object;
        Object object2;
        CharSequence charSequence;
        Object object3;
        if (this.selectedListModel.contains(moduleUpdate)) {
            return true;
        }
        String string = PreparedModules.getPrepared().getPreparedVersion(moduleUpdate.getCodeNameBase());
        if (string != null) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UpdatePanel.class, (String)"MSG_Prepared_Module", (Object)moduleUpdate.getName(), (Object)string), UpdatePanel.getBundle("CTL_Prepared_Title"), 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation).equals(NotifyDescriptor.YES_OPTION)) return true;
            PreparedModules.getPrepared().removeModule(moduleUpdate.getCodeNameBase());
        }
        boolean bl2 = false;
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            object3 = (ModuleUpdate)this.selectedListModel.get(i);
            charSequence = null;
            if (moduleUpdate instanceof L10NUpdate) {
                charSequence = ((L10NUpdate)moduleUpdate).getLangcode();
            }
            charSequence = charSequence == null ? EMPTY_STRING : charSequence;
            object2 = null;
            if (object3 instanceof L10NUpdate) {
                object2 = ((L10NUpdate)object3).getLangcode();
            }
            Object object4 = object2 = object2 == null ? EMPTY_STRING : object2;
            if (((ModuleUpdate)object3).getCodeNameBase().equals(moduleUpdate.getCodeNameBase()) && ((String)object2).equals(charSequence)) {
                if (bl) {
                    if (this.duplicateStatus == 1) {
                        bl2 = true;
                    } else {
                        if (this.duplicateStatus == 3) {
                            return true;
                        }
                        object = DuplicateWarningDialog.getDialog(moduleUpdate.getName());
                        ((Dialog)object).setVisible(true);
                        this.duplicateStatus = DuplicateWarningDialog.getResult();
                        if (this.duplicateStatus != 0 && this.duplicateStatus != 1) return true;
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            this.removeModule((ModuleUpdate)object3, moduleUpdate);
            break;
        }
        if (moduleUpdate.getNotification() != null && moduleUpdate.getNotification().length() > 0 && !moduleUpdate.getNotificationAccepted()) {
            if (!Notification.performModuleNotification(moduleUpdate.getNotification())) return false;
            moduleUpdate.setNotificationAccepted(true);
        }
        if ((list2 = moduleUpdate.getExternals()) != null) {
            object3 = list2.iterator();
            while (object3.hasNext()) {
                ExternalDialog.showExternal(moduleUpdate.getName(), (ModuleUpdate.External)object3.next());
            }
        }
        object3 = new DependencyChecker();
        charSequence = new StringBuffer();
        object2 = ((DependencyChecker)object3).modulesToAdd(moduleUpdate, this.selectedListModel.elements(), list, (StringBuffer)charSequence);
        if (((StringBuffer)charSequence).length() > 0) {
            return false;
        }
        this.selectedListModel.add(this.findPosition(moduleUpdate), moduleUpdate);
        object = object2.iterator();
        while (object.hasNext()) {
            ModuleUpdate moduleUpdate2 = (ModuleUpdate)object.next();
            if (this.addModule(moduleUpdate2, null, false)) continue;
            this.selectedListModel.removeElement(moduleUpdate);
            this.totalSize += moduleUpdate.getDownloadSize();
            return false;
        }
        this.showSize();
        this.validator.setValid(this.selectedListModel.size() > 0);
        this.jList1.revalidate();
        moduleUpdate.setSelected(true);
        this.refreshNodes();
        return true;
    }

    boolean checkLicencies() {
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            ModuleUpdate moduleUpdate = (ModuleUpdate)this.selectedListModel.get(i);
            if (moduleUpdate.getLicenceText() == null || moduleUpdate.getLicenceID() == null || acceptedLicencies.contains(moduleUpdate.getLicenceID())) continue;
            if (LicenceDialog.acceptLicence(moduleUpdate.getLicenceText())) {
                acceptedLicencies.add(moduleUpdate.getLicenceID());
                continue;
            }
            return false;
        }
        return true;
    }

    private int findPosition(ModuleUpdate moduleUpdate) {
        int n = 0;
        Collection collection = Wizard.getAllModules();
        for (ModuleUpdate moduleUpdate2 : collection) {
            if (moduleUpdate == moduleUpdate2) {
                return n;
            }
            if (!this.selectedListModel.contains(moduleUpdate2)) continue;
            ++n;
        }
        return n;
    }

    private void removeModule(ModuleUpdate moduleUpdate) {
        this.removeModule(moduleUpdate, null);
    }

    private void removeModule(ModuleUpdate moduleUpdate, ModuleUpdate moduleUpdate2) {
        if (!this.selectedListModel.contains(moduleUpdate)) {
            return;
        }
        int n = this.selectedListModel.indexOf(moduleUpdate);
        this.totalSize -= moduleUpdate.getDownloadSize();
        this.selectedListModel.remove(n);
        if (moduleUpdate.isDownloadStarted()) {
            Downloader.deleteModuleNBM(moduleUpdate);
        }
        DependencyChecker dependencyChecker = new DependencyChecker();
        Collection collection = dependencyChecker.modulesToRemove(moduleUpdate, moduleUpdate2);
        for (ModuleUpdate moduleUpdate3 : collection) {
            this.removeModule(moduleUpdate3);
        }
        moduleUpdate.setSelected(false);
        moduleUpdate.setDownloadOK(false);
        moduleUpdate.setSecurity(-1);
    }

    void showSize() {
        this.totalSize = 0L;
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            if (((ModuleUpdate)this.selectedListModel.get(i)).isDownloadOK()) continue;
            this.totalSize += ((ModuleUpdate)this.selectedListModel.get(i)).getDownloadSize();
        }
        this.totalsizeTextField.setText(this.totalSize / 1024L + SPACE + UpdatePanel.getBundle("CTL_UpdatePanel_KB"));
    }

    int modulesToDownload() {
        int n = 0;
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            if (((ModuleUpdate)this.selectedListModel.get(i)).isDownloadOK() && !((ModuleUpdate)this.selectedListModel.get(i)).isNotChecked()) continue;
            ++n;
        }
        return n;
    }

    private boolean existUnselectedModule() {
        Collection collection = Wizard.getAllModules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (((ModuleUpdate)iterator.next()).isSelected()) continue;
            return true;
        }
        return false;
    }

    void markSelectedModules() {
        Collection collection = Wizard.getAllModules();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((ModuleUpdate)iterator.next()).setSelected(false);
        }
        for (int i = 0; i < this.selectedListModel.size(); ++i) {
            ((ModuleUpdate)this.selectedListModel.get(i)).setSelected(true);
        }
    }

    private void refreshNodes() {
        if (this.allNodes == null) {
            this.allNodes = UpdateNode.getAllServers();
            this.explorerView.getExplorerManager().setRootContext((Node)this.allNodes);
            this.explorerView.expandAll();
            Runnable runnable = new Runnable(){

                public void run() {
                    if (!UpdatePanel.this.allNodes.isLeaf()) {
                        UpdatePanel.this.explorerView.getExplorerManager().setExploredContext(UpdatePanel.this.allNodes.getChildren().getNodes()[0]);
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable, 300);
        } else {
            this.allNodes.refreshContent(true);
        }
    }

    void removeListeners() {
        if (this.nodeListener != null) {
            Settings.getShared().removePropertyChangeListener(this.nodeListener);
        }
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(UpdatePanel.class, (String)string);
    }

    static class ExplorerView
    extends JComponent
    implements ExplorerManager.Provider {
        private ExplorerManager em;
        private BeanTreeView btv;
        static final long serialVersionUID = -5811911993587966912L;

        ExplorerView() {
            UpdateNode.Wait wait = new UpdateNode.Wait();
            this.createContent((Node)wait);
        }

        private void createContent(Node node) {
            this.btv = new BeanTreeView();
            this.btv.setPopupAllowed(false);
            this.btv.setDefaultActionAllowed(true);
            this.btv.setBorder(UIManager.getBorder("ScrollPane.border"));
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)this.btv);
            this.getExplorerManager().setRootContext(node);
            this.btv.setRootVisible(false);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(dimension.width, 450), Math.max(dimension.height, 300));
        }

        void expandAll() {
            this.expandChildren(this.getExplorerManager().getRootContext());
        }

        public void addNotify() {
            super.addNotify();
            this.btv.requestFocus();
        }

        private void expandChildren(Node node) {
            Node[] nodeArray = node.getChildren().getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i].getDisplayName().startsWith("L10N")) continue;
                this.btv.expandNode(nodeArray[i]);
                if (nodeArray[i].getChildren() == Children.LEAF) continue;
                this.expandChildren(nodeArray[i]);
            }
        }

        Node[] getSelectedNodes() {
            return this.getExplorerManager().getSelectedNodes();
        }

        public ExplorerManager getExplorerManager() {
            if (this.em == null) {
                this.em = new ExplorerManager();
            }
            return this.em;
        }
    }
}

