/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ModuleDeleterImpl
implements ModuleDeleter {
    private static final String ELEMENT_MODULE = "module";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_FILE_NAME = "name";
    private static final String UPDATE_TRACKING = "update_tracking";
    private static final String INST_ORIGIN = "updater";
    private static final boolean ONLY_FROM_AUTOUPDATE = false;
    private static final int TIME_TO_CHECK = 2000;
    private static final int MAX_CHECKS_OF_STATE = 50;
    private static final int HOLD_ON_PROPAGATE_DISABLE = 1000;
    private Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.catalog.ModuleDeleterImpl");

    public boolean canDelete(Module module) {
        if (module.isFixed()) {
            this.err.log(Level.FINE, "Cannot delete module because module " + module.getCodeName() + " isFixed.");
        } else if (module.isAutoload()) {
            this.err.log(Level.FINE, "Cannot delete module because module " + module.getCodeName() + " isAutoload. See issue #74819.");
        } else if (module.isEager()) {
            this.err.log(Level.FINE, "Cannot delete module because module " + module.getCodeName() + " isEager. See issue #74819.");
        }
        return ModuleNodeUtils.isUninstallAllowed(module) && this.findUpdateTracking(module, false);
    }

    public void delete(final Module module) throws IOException {
        if (module == null) {
            throw new IllegalArgumentException("Module argument cannot be null.");
        }
        this.err.log(Level.FINE, "Locate and remove config file of " + module.getCodeNameBase());
        this.removeControlModuleFile(module);
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                try {
                    ModuleDeleterImpl.this.removeModuleFiles(module);
                }
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)("ERROR: During processing removeModuleFiles (" + module.getDisplayName() + ")"));
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new HackModuleListRefresher());
        }
        if (!module.isAutoload() && !module.isEager()) {
            RequestProcessor.getDefault().post((Runnable)new ModuleStateChecker(module, task), 2000);
        } else {
            task.run();
        }
    }

    private File locateControlFile(Module module) {
        String string = "config/Modules/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, module.getCodeNameBase(), false);
    }

    private void removeControlModuleFile(Module module) throws IOException {
        File file = null;
        while ((file = this.locateControlFile(module)) != null) {
            if (file != null && file.exists()) {
                this.err.log(Level.FINE, "Try delete the config File " + file);
                FileUtil.toFileObject((File)file).delete();
                continue;
            }
            this.err.log(Level.FINE, "Warning: Config File " + file + " doesn't exist!");
        }
    }

    private File locateUpdateTracking(Module module) {
        String string = "update_tracking/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        return InstalledFileLocator.getDefault().locate(string, module.getCodeNameBase(), false);
    }

    private boolean findUpdateTracking(Module module, boolean bl) {
        File file = this.locateUpdateTracking(module);
        if (file != null && file.exists()) {
            if (!file.getParentFile().canWrite()) {
                this.err.log(Level.FINE, "Cannot delete module " + module.getCodeName() + " because no write permission to directory " + file.getParent());
                return false;
            }
            if (bl) {
                boolean bl2 = this.fromAutoupdate(this.getModuleConfiguration(file));
                this.err.log(Level.FINE, "Is Module " + module.getCodeName() + " installed by AutoUpdate? " + bl2);
                return bl2;
            }
            return true;
        }
        this.err.log(Level.FINE, "Cannot delete module " + module.getCodeName() + " because no update_tracking file found.");
        return false;
    }

    private boolean fromAutoupdate(Node node) {
        Node node2 = node.getAttributes().getNamedItem(ATTR_ORIGIN);
        assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_ORIGIN attribute.";
        String string = node2.getNodeValue();
        return INST_ORIGIN.equals(string);
    }

    private void removeModuleFiles(Module module) throws IOException {
        this.err.log(Level.FINE, "Entry removing files of module " + module);
        File file = null;
        while ((file = this.locateUpdateTracking(module)) != null) {
            this.removeModuleFilesInCluster(module, file);
        }
        this.err.log(Level.FINE, "Exit removing files of module " + module);
    }

    private void removeModuleFilesInCluster(Module module, File file) throws IOException {
        this.err.log(Level.FINE, "Read update_tracking " + file + " file.");
        Set set = this.readModuleFiles(this.getModuleConfiguration(file));
        String string = "config/Modules/" + module.getCodeNameBase().replace('.', '-') + ".xml";
        if (set.contains(string)) {
            File file2 = InstalledFileLocator.getDefault().locate(string, module.getCodeNameBase(), false);
            assert (file2 == null || !file2.exists()) : "Config file " + string + " must be already removed.";
        }
        for (String string2 : set) {
            File file3;
            if (string2.equals(string) || (file3 = InstalledFileLocator.getDefault().locate(string2, module.getCodeNameBase(), false)).equals(file)) continue;
            assert (file3.exists()) : "File " + file3 + " exists.";
            if (!file3.exists()) continue;
            this.err.log(Level.FINE, "File " + file3 + " is deleted.");
            try {
                FileUtil.toFileObject((File)file3).delete();
            }
            catch (IOException iOException) {
                assert (false) : "Waring: IOException " + iOException.getMessage() + " was caught. Propably file lock on the file.";
                this.err.log(Level.FINE, "Waring: IOException " + iOException.getMessage() + " was caught. Propably file lock on the file.");
                this.err.log(Level.FINE, "Try call File.deleteOnExit() on " + file3);
                file3.deleteOnExit();
            }
        }
        FileUtil.toFileObject((File)file).delete();
        this.err.log(Level.FINE, "File " + file + " is deleted.");
    }

    private Node getModuleConfiguration(File file) {
        Document document = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)false, null, (EntityResolver)EntityCatalog.getDefault());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (SAXException sAXException) {
            this.err.log(Level.WARNING, null, sAXException);
            return null;
        }
        catch (IOException iOException) {
            this.err.log(Level.WARNING, null, iOException);
        }
        assert (document.getDocumentElement() != null) : "File " + file + " must contain <module> element.";
        return this.getModuleElement(document.getDocumentElement());
    }

    private Node getModuleElement(Element element) {
        Node node = null;
        assert (ELEMENT_MODULE.equals(element.getTagName())) : "The root element is: module but was: " + element.getTagName();
        NodeList nodeList = element.getElementsByTagName(ELEMENT_VERSION);
        for (int i = 0; i < nodeList.getLength() && (node = this.getModuleLastVersion(nodeList.item(i))) == null; ++i) {
        }
        return node;
    }

    private Node getModuleLastVersion(Node node) {
        Node node2 = node.getAttributes().getNamedItem(ATTR_LAST);
        assert (node2 != null) : "ELEMENT_VERSION must contain ATTR_LAST attribute.";
        if (Boolean.valueOf(node2.getNodeValue()).booleanValue()) {
            return node;
        }
        return null;
    }

    private Set readModuleFiles(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).hasAttributes()) continue;
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            hashSet.add(namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
            this.err.log(Level.FINE, "Mark to delete: " + namedNodeMap.getNamedItem(ATTR_FILE_NAME).getNodeValue());
        }
        return hashSet;
    }

    private class HackModuleListRefresher
    implements Runnable {
        private HackModuleListRefresher() {
        }

        public void run() {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
            ModuleDeleterImpl.this.err.log(Level.FINE, "It's a hack: Call refresh on " + fileObject + " file object.");
            if (fileObject != null) {
                fileObject.refresh();
            }
        }
    }

    private class ModuleStateChecker
    implements Runnable {
        RequestProcessor.Task cleaner;
        Module m;
        int checks;

        public ModuleStateChecker(Module module, RequestProcessor.Task task) {
            this.cleaner = task;
            this.m = module;
            this.checks = 0;
        }

        public void run() {
            ++this.checks;
            if (this.m.isEnabled() && this.m.isValid()) {
                if (this.checks < 50) {
                    ModuleDeleterImpl.this.err.log(Level.FINE, "Module " + this.m.getCodeNameBase() + " is still valid, repost later.");
                    RequestProcessor.getDefault().post((Runnable)this, 2000);
                } else {
                    ModuleDeleterImpl.this.err.log(Level.FINE, "Warning: Module " + this.m.getCodeNameBase() + " is still valid but time-out. Task is terminated.");
                }
                return;
            }
            this.cleaner.schedule(1000);
        }
    }
}

