/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.catalog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.netbeans.modules.autoupdate.catalog.ModuleBean;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleter;
import org.netbeans.modules.autoupdate.catalog.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeActions;
import org.netbeans.modules.autoupdate.catalog.ModuleNodeUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ModuleNode
extends AbstractNode {
    private static final String MODULE_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/moduleItem.gif";
    private static final String MODULE_ITEM_DISABLED_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemDisabled.gif";
    private static final String MODULE_ITEM_ERROR_BASE = "org/netbeans/modules/autoupdate/resources/moduleItemError.gif";
    private static final String MODULE_TEST_ITEM_ICON_BASE = "org/netbeans/modules/autoupdate/resources/testModuleItem.gif";
    private static final String MODULES_ICON_BASE = "org/netbeans/modules/autoupdate/resources/modules.gif";
    private static ModuleDeleter deleter;
    private static final String KEY_SORT_MODE = "moduleSortMode";

    private static Preferences getPreferences() {
        return NbPreferences.forModule(ModuleNode.class);
    }

    static SortMode getModuleSortMode() {
        return SortMode.valueOf(ModuleNode.getPreferences().get(KEY_SORT_MODE, SortMode.BY_CATEGORY.name()));
    }

    static void setModuleSortMode(SortMode sortMode) {
        ModuleNode.getPreferences().put(KEY_SORT_MODE, sortMode.name());
    }

    public ModuleNode() {
        super((Children)new Modules());
        this.setName("Modules");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ModuleNode.class);
    }

    private static ModuleBean.AllModulesBean getAllModules() {
        return ModuleBean.AllModulesBean.getDefault();
    }

    private static ModuleDeleter getModuleDeleter() {
        if (deleter == null) {
            deleter = new ModuleDeleterImpl();
        }
        return deleter;
    }

    private static final class BridgeChildren
    extends DirectModuleChildren {
        private BridgeChildren() {
        }

        protected boolean contains(ModuleBean moduleBean) {
            return moduleBean.isEager();
        }
    }

    private static final class BridgeNode
    extends ModuleFolderNode {
        BridgeNode() {
            super(new BridgeChildren());
            this.setName("bridges");
            this.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"LBL_ModuleNode_bridges"));
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
        }

        protected boolean supportsEnabledProperty() {
            return false;
        }

        protected boolean contains(ModuleBean moduleBean) {
            throw new AssertionError();
        }
    }

    private static final class CategoryChildren
    extends DirectModuleChildren {
        private final String category;

        public CategoryChildren(String string) {
            this.category = string;
        }

        protected boolean contains(ModuleBean moduleBean) {
            return this.category.equals(moduleBean.getCategory());
        }
    }

    private static final class CategoryNode
    extends ModuleFolderNode {
        private final String category;

        CategoryNode(String string) {
            super(new CategoryChildren(string));
            this.category = string;
            this.setName(string);
            this.updateDisplayStuff();
            this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, null));
        }

        protected boolean supportsEnabledProperty() {
            return true;
        }

        protected boolean contains(ModuleBean moduleBean) {
            return moduleBean.getJar() != null && !moduleBean.isAutoload() && !moduleBean.isEager() && this.category.equals(moduleBean.getCategory());
        }
    }

    private static final class ClusterChildren
    extends DirectModuleChildren {
        private final File cluster;

        public ClusterChildren(File file) {
            this.cluster = file;
        }

        protected boolean contains(ModuleBean moduleBean) {
            return this.cluster.equals(moduleBean.getCluster());
        }
    }

    private static final class ClusterNode
    extends ModuleFolderNode {
        private final File cluster;

        ClusterNode(File file) {
            super(new ClusterChildren(file));
            this.cluster = file;
            this.setName(file.getAbsolutePath());
            this.setDisplayName(file.getName());
            this.updateDisplayStuff();
            this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, null));
        }

        protected boolean supportsEnabledProperty() {
            return true;
        }

        protected boolean contains(ModuleBean moduleBean) {
            return this.cluster.equals(moduleBean.getCluster());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DirectModuleChildren
    extends Children.Keys<ModuleBean>
    implements PropertyChangeListener {
        private DirectModuleChildren() {
        }

        protected void addNotify() {
            this.refreshKeys();
            ModuleNode.getAllModules().addPropertyChangeListener(this);
        }

        protected void removeNotify() {
            ModuleNode.getAllModules().removePropertyChangeListener(this);
            this.setKeys(Collections.emptySet());
        }

        public Node findChild(String string) {
            ModuleNode.getAllModules().waitForModules().waitFinished();
            this.refreshKeys();
            return super.findChild(string);
        }

        protected abstract boolean contains(ModuleBean var1);

        private void refreshKeys() {
            ArrayList<ModuleBean> arrayList = new ArrayList<ModuleBean>();
            for (ModuleBean moduleBean : ModuleNode.getAllModules().getModules()) {
                if (!this.contains(moduleBean)) continue;
                arrayList.add(moduleBean);
            }
            final Collator collator = Collator.getInstance();
            Collections.sort(arrayList, new Comparator<ModuleBean>(){

                @Override
                public int compare(ModuleBean moduleBean, ModuleBean moduleBean2) {
                    return collator.compare(moduleBean.getDisplayName(), moduleBean2.getDisplayName());
                }
            });
            this.setKeys(arrayList);
        }

        protected Node[] createNodes(ModuleBean moduleBean) {
            return new Node[]{new Item(moduleBean)};
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refreshKeys();
        }
    }

    static class Item
    extends AbstractNode
    implements PropertyChangeListener {
        private ModuleBean item;
        private boolean listeningToAllModules = false;

        public Item(ModuleBean moduleBean) {
            super(Children.LEAF, Lookups.singleton((Object)moduleBean));
            this.item = moduleBean;
            this.setName(moduleBean.getCodeNameBase());
            moduleBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)moduleBean));
            this.updateDisplayStuff();
        }

        ModuleBean getItem() {
            assert (this.item != null) : "Cannot be called untill item is null.";
            return this.item;
        }

        void uninstall() {
            ModuleDeleter moduleDeleter = ModuleNode.getModuleDeleter();
            assert (moduleDeleter != null) : "ModuleDeleter must be available.";
            boolean bl = moduleDeleter.canDelete(this.item.getModule());
            if (bl) {
                try {
                    moduleDeleter.delete(this.item.getModule());
                }
                catch (IOException iOException) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)iOException));
                }
            } else if (this.canDestroy()) {
                this.item.delete();
            }
        }

        private void updateDisplayStuff() {
            this.setDisplayName(this.item.getDisplayName());
            this.setShortDescription(this.item.getShortDescription());
            this.setIconBaseWithExtension(this.item.isEnabled() ? (this.item.isReloadable() ? ModuleNode.MODULE_TEST_ITEM_ICON_BASE : ModuleNode.MODULE_ITEM_ICON_BASE) : (this.item.isProblematic() ? ModuleNode.MODULE_ITEM_ERROR_BASE : ModuleNode.MODULE_ITEM_DISABLED_BASE));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateDisplayStuff();
            this.firePropertyChange(null, null, null);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(Item.class);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(ModuleNodeActions.EnableDisableAction.class), SystemAction.get(ModuleNodeActions.EnableAllAction.class), null, SystemAction.get(ModuleNodeActions.UninstallAction.class), null, SystemAction.get(ModuleNodeActions.SortAction.class), null, SystemAction.get(PropertiesAction.class)};
        }

        public Action getPreferredAction() {
            return SystemAction.get(PropertiesAction.class);
        }

        public void destroy() {
            if (ModuleNodeUtils.confirmUninstall(new Node[]{this})) {
                this.uninstall();
            }
        }

        public boolean canDestroy() {
            boolean bl = ModuleNode.getModuleDeleter().canDelete(this.item.getModule());
            if (!bl) {
                return this.item.getJar() != null && ModuleNodeUtils.isUninstallAllowed(this.item.getModule());
            }
            return true;
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("properties");
            Sheet.Set set2 = Sheet.createExpertSet();
            sheet.put(set2);
            try {
                PropertySupport.Reflection reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getDisplayName", null);
                reflection.setName("displayName");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_name"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_name"));
                set.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getSpecificationVersion", null);
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setName("specificationVersion");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_specversion"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_specversion"));
                set.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getImplementationVersion", null);
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setName("implementationVersion");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_implversion"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_implversion"));
                set2.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getBuildVersion", null);
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setName("buildVersion");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_buildversion"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_buildversion"));
                set2.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getShortDescription", null);
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setName("shortDescription");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_shortDescription"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_shortDescription"));
                set.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getLongDescription", null);
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setName("longDescription");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_longDescription"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_longDescription"));
                set.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getCategory", null);
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setName("category");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_category"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_category"));
                set2.put((Node.Property)reflection);
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class EnabledOrReloadableProp
                extends PropertySupport.Reflection<Boolean> {
                    public EnabledOrReloadableProp(String string, String string2) throws NoSuchMethodException {
                        super((Object)Item.this.item, Boolean.TYPE, string, string2);
                    }

                    public boolean canWrite() {
                        if (!super.canWrite()) {
                            return false;
                        }
                        if (this.getName().equals("enabled")) {
                            return Item.this.item.getJar() != null && !Item.this.item.isProblematic() && !Item.this.item.isAutoload() && !Item.this.item.isEager();
                        }
                        if (this.getName().equals("reloadable")) {
                            return Item.this.item.getJar() != null && (Item.this.item.isReloadable() || Item.this.item.getJar().getParentFile().canWrite());
                        }
                        throw new IllegalStateException();
                    }
                }
                reflection = new EnabledOrReloadableProp("isEnabled", "setEnabled");
                reflection.setName("enabled");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_enabled"));
                set.put((Node.Property)reflection);
                reflection = new EnabledOrReloadableProp("isReloadable", "setReloadable");
                reflection.setName("reloadable");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_reloadable"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_reloadable"));
                set2.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String.class, "getCodeName", null);
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setName("codeName");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_codename"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_codename"));
                set2.put((Node.Property)reflection);
                if (this.item.getJar() != null) {
                    reflection = new PropertySupport.Reflection((Object)this.item, File.class, "getJar", null);
                    reflection.setName("jar");
                    reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_jar"));
                    reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_jar"));
                    set2.put((Node.Property)reflection);
                }
                class ClasspathProperty
                extends PropertySupport.ReadOnly {
                    public ClasspathProperty() {
                        super("classpath", Item.getNbClassPathOrStringClass(), NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_classpath"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_classpath"));
                    }

                    public Object getValue() throws InvocationTargetException {
                        String string = Item.this.item.getEffectiveClasspath();
                        if (this.getValueType() == String.class) {
                            return string;
                        }
                        try {
                            Constructor constructor = this.getValueType().getConstructor(String.class);
                            return constructor.newInstance(string);
                        }
                        catch (Exception exception) {
                            throw new InvocationTargetException(exception);
                        }
                    }
                }
                set2.put((Node.Property)new ClasspathProperty());
                reflection = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isAutoload", null);
                reflection.setName("autoload");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_autoload"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_autoload"));
                set2.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, Boolean.TYPE, "isEager", null);
                reflection.setName("eager");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_eager"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_eager"));
                set2.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String[].class, "getProvides", null);
                reflection.setName("provides");
                reflection.setValue("suppressCustomEditor", (Object)true);
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_provides"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_provides"));
                set2.put((Node.Property)reflection);
                reflection = new PropertySupport.Reflection((Object)this.item, String[].class, "getProblemDescriptions", null);
                reflection.setName("problemDescriptions");
                reflection.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_problemDescriptions"));
                reflection.setShortDescription(NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_problemDescriptions"));
                set2.put((Node.Property)reflection);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Exceptions.printStackTrace((Throwable)noSuchMethodException);
            }
            set2.put((Node.Property)new UsedByProp());
            return sheet;
        }

        private static Class getNbClassPathOrStringClass() {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            try {
                return classLoader.loadClass("org.openide.execution.NbClassPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return String.class;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class UsedByProp
        extends PropertySupport.ReadOnly<String[]>
        implements ModuleBean.AllModulesBean.RelationCallback,
        PropertyChangeListener {
            private String[] value;

            public UsedByProp() {
                super("usedBy", String[].class, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_usedby"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_usedby"));
                this.value = null;
            }

            public String[] getValue() {
                if (this.value != null) {
                    return this.value;
                }
                ModuleBean.AllModulesBean allModulesBean = ModuleBean.AllModulesBean.getDefault();
                allModulesBean.getRelations(Item.this.item, 3, this);
                if (!Item.this.listeningToAllModules) {
                    Item.this.listeningToAllModules = true;
                    allModulesBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)allModulesBean));
                    ModuleBean[] moduleBeanArray = allModulesBean.getModules();
                    for (int i = 0; i < moduleBeanArray.length; ++i) {
                        if (moduleBeanArray[i] == Item.this.item) continue;
                        moduleBeanArray[i].addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)moduleBeanArray[i]));
                    }
                }
                return new String[]{NbBundle.getMessage(ModuleNode.class, (String)"LBL_please_wait_modules_usedby")};
            }

            @Override
            public void result(Set<ModuleBean> set) {
                ArrayList<String> arrayList = new ArrayList<String>(Math.max(set.size(), 1));
                if (Item.this.item.isEnabled()) {
                    for (ModuleBean moduleBean : set) {
                        if (!moduleBean.isEnabled()) continue;
                        arrayList.add(moduleBean.getDisplayName());
                    }
                    Collections.sort(arrayList, Collator.getInstance());
                }
                String[] stringArray = this.value;
                this.value = arrayList.toArray(new String[arrayList.size()]);
                Item.this.firePropertyChange("usedBy", stringArray, this.value);
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.value = null;
                Item.this.firePropertyChange("usedBy", null, null);
            }
        }
    }

    private static final class LibraryChildren
    extends DirectModuleChildren {
        private LibraryChildren() {
        }

        protected boolean contains(ModuleBean moduleBean) {
            return moduleBean.getJar() == null || moduleBean.isAutoload();
        }
    }

    private static final class LibraryNode
    extends ModuleFolderNode {
        LibraryNode() {
            super(new LibraryChildren());
            this.setName("libraries");
            this.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"LBL_ModuleNode_libraries"));
            this.setIconBaseWithExtension(ModuleNode.MODULES_ICON_BASE);
        }

        protected boolean supportsEnabledProperty() {
            return false;
        }

        protected boolean contains(ModuleBean moduleBean) {
            throw new AssertionError();
        }
    }

    private static abstract class ModuleFolderNode
    extends AbstractNode
    implements PropertyChangeListener {
        protected ModuleFolderNode(DirectModuleChildren directModuleChildren) {
            super((Children)directModuleChildren);
        }

        public boolean canDestroy() {
            return ModuleNodeUtils.canUninstall(new Node[]{this});
        }

        public void destroy() {
            ModuleNodeUtils.doUninstall(new Node[]{this});
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(ModuleNode.class);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.updateDisplayStuff();
            }
        }

        protected void updateDisplayStuff() {
            Boolean bl = ModuleNodeUtils.isEnableCandidate(this.getChildren().getNodes());
            this.setIconBaseWithExtension(bl != null && bl != false ? ModuleNode.MODULE_ITEM_DISABLED_BASE : ModuleNode.MODULES_ICON_BASE);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{SystemAction.get(ModuleNodeActions.EnableDisableAction.class), SystemAction.get(ModuleNodeActions.EnableAllAction.class), null, SystemAction.get(ModuleNodeActions.UninstallAction.class), null, SystemAction.get(ModuleNodeActions.SortAction.class), null, SystemAction.get(PropertiesAction.class)};
        }

        protected abstract boolean supportsEnabledProperty();

        protected abstract boolean contains(ModuleBean var1);

        protected Sheet createSheet() {
            if (!this.supportsEnabledProperty()) {
                return super.createSheet();
            }
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("properties");
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class EnabledProp
            extends PropertySupport.ReadWrite<Boolean>
            implements PropertyChangeListener {
                private Set<ModuleBean> modules;
                private PropertyEditor editor;

                public EnabledProp() {
                    super("enabled", Boolean.TYPE, NbBundle.getMessage(ModuleNode.class, (String)"PROP_modules_enabled"), NbBundle.getMessage(ModuleNode.class, (String)"HINT_modules_enabled"));
                    this.modules = new HashSet<ModuleBean>();
                    this.editor = null;
                    this.calculateModules();
                    ModuleNode.getAllModules().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ModuleNode.getAllModules()));
                }

                public Boolean getValue() {
                    Boolean bl = null;
                    for (ModuleBean moduleBean : this.modules) {
                        if (moduleBean.isEnabled()) {
                            if (bl == null) {
                                bl = true;
                                continue;
                            }
                            if (bl.booleanValue()) continue;
                            return null;
                        }
                        if (bl == null) {
                            bl = false;
                            continue;
                        }
                        if (!bl.booleanValue()) continue;
                        return null;
                    }
                    return bl;
                }

                public void setValue(Boolean bl) {
                    ModuleNode.getAllModules().pause();
                    for (ModuleBean moduleBean : this.modules) {
                        moduleBean.setEnabled(bl);
                    }
                    ModuleNode.getAllModules().resume();
                }

                public boolean canWrite() {
                    for (ModuleBean moduleBean : this.modules) {
                        if (!moduleBean.isAutoload() && moduleBean.getJar() != null && !moduleBean.isEager() && !moduleBean.isProblematic()) continue;
                        return false;
                    }
                    return true;
                }

                private void calculateModules() {
                    HashSet<ModuleBean> hashSet = new HashSet<ModuleBean>();
                    for (ModuleBean moduleBean : ModuleNode.getAllModules().getModules()) {
                        if (!ModuleFolderNode.this.contains(moduleBean)) continue;
                        hashSet.add(moduleBean);
                        if (this.modules.contains(moduleBean)) continue;
                        moduleBean.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)moduleBean));
                    }
                    this.modules = hashSet;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ModuleFolderNode.this.firePropertyChange("enabled", null, null);
                    this.calculateModules();
                }

                public PropertyEditor getPropertyEditor() {
                    if (this.editor == null) {
                        this.editor = super.getPropertyEditor();
                    }
                    return this.editor;
                }
            }
            set.put((Node.Property)new EnabledProp());
            return sheet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Modules
    extends Children.Keys<Object>
    implements PropertyChangeListener {
        private static final Object LIBRARY_KEY = new Object();
        private static final Object BRIDGE_KEY = new Object();
        private static final Object NO_CLUSTER_KEY = new Object();
        private PreferenceChangeListener prefsListener;

        private void refreshKeys() {
            if (this.prefsListener == null) {
                this.addNotify();
            }
            ModuleBean[] moduleBeanArray = ModuleNode.getAllModules().getModules();
            switch (ModuleNode.getModuleSortMode()) {
                case BY_CATEGORY: {
                    final Collator collator = Collator.getInstance();
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class CategoryComparator
                    implements Comparator<Object> {
                        CategoryComparator() {
                        }

                        @Override
                        public int compare(Object object, Object object2) {
                            if (object == LIBRARY_KEY) {
                                if (object2 == LIBRARY_KEY) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (object2 == LIBRARY_KEY) {
                                return -1;
                            }
                            if (object == BRIDGE_KEY) {
                                if (object2 == BRIDGE_KEY) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (object2 == BRIDGE_KEY) {
                                return -1;
                            }
                            String string = object instanceof ModuleBean ? ((ModuleBean)object).getDisplayName() : (String)object;
                            String string2 = object2 instanceof ModuleBean ? ((ModuleBean)object2).getDisplayName() : (String)object2;
                            return collator.compare(string, string2);
                        }
                    }
                    TreeSet<Object> treeSet = new TreeSet<Object>(new CategoryComparator());
                    for (ModuleBean moduleBean : moduleBeanArray) {
                        if (moduleBean.getJar() == null || moduleBean.isAutoload()) {
                            treeSet.add(LIBRARY_KEY);
                            continue;
                        }
                        if (moduleBean.isEager()) {
                            treeSet.add(BRIDGE_KEY);
                            continue;
                        }
                        String string = moduleBean.getCategory();
                        if (string != null) {
                            treeSet.add(string);
                            continue;
                        }
                        treeSet.add(moduleBean);
                    }
                    this.setKeys(treeSet);
                    break;
                }
                case BY_DISPLAY_NAME: {
                    ArrayList<ModuleBean> arrayList = new ArrayList<ModuleBean>(Arrays.asList(moduleBeanArray));
                    Collections.sort(arrayList, new Comparator<ModuleBean>(){
                        Collator coll = Collator.getInstance();

                        @Override
                        public int compare(ModuleBean moduleBean, ModuleBean moduleBean2) {
                            return this.coll.compare(moduleBean.getDisplayName(), moduleBean2.getDisplayName());
                        }
                    });
                    this.setKeys(arrayList);
                    break;
                }
                case BY_CLUSTER: {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class ClusterComparator
                    implements Comparator<Object> {
                        ClusterComparator() {
                        }

                        @Override
                        public int compare(Object object, Object object2) {
                            if (object == NO_CLUSTER_KEY) {
                                if (object2 == NO_CLUSTER_KEY) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (object2 == NO_CLUSTER_KEY) {
                                return -1;
                            }
                            return ((File)object).compareTo((File)object2);
                        }
                    }
                    TreeSet<Object> treeSet = new TreeSet<Object>(new ClusterComparator());
                    for (ModuleBean moduleBean : moduleBeanArray) {
                        File file = moduleBean.getCluster();
                        if (file == null) {
                            treeSet.add(NO_CLUSTER_KEY);
                            continue;
                        }
                        treeSet.add(file);
                    }
                    this.setKeys(treeSet);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public void addNotify() {
            this.prefsListener = new PreferenceChangeListener(){

                public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                    Modules.this.refreshKeys();
                }
            };
            ModuleNode.getPreferences().addPreferenceChangeListener(this.prefsListener);
            ModuleNode.getAllModules().addPropertyChangeListener(this);
            this.refreshKeys();
        }

        public void removeNotify() {
            if (this.prefsListener != null) {
                ModuleNode.getPreferences().removePreferenceChangeListener(this.prefsListener);
            }
            ModuleNode.getAllModules().removePropertyChangeListener(this);
            ModuleBean[] moduleBeanArray = ModuleNode.getAllModules().getModules();
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                moduleBeanArray[i].removePropertyChangeListener(this);
            }
        }

        public Node findChild(String string) {
            ModuleNode.getAllModules().waitForModules().waitFinished();
            this.refreshKeys();
            return super.findChild(string);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refreshKeys();
        }

        protected Node[] createNodes(Object object) {
            if (object == LIBRARY_KEY) {
                return new Node[]{new LibraryNode()};
            }
            if (object == BRIDGE_KEY) {
                return new Node[]{new BridgeNode()};
            }
            if (object == NO_CLUSTER_KEY) {
                return new Node[]{new NoClusterNode()};
            }
            if (object instanceof String) {
                return new Node[]{new CategoryNode((String)object)};
            }
            if (object instanceof File) {
                return new Node[]{new ClusterNode((File)object)};
            }
            return new Node[]{new Item((ModuleBean)object)};
        }
    }

    private static final class NoClusterChildren
    extends DirectModuleChildren {
        protected boolean contains(ModuleBean moduleBean) {
            return moduleBean.getCluster() == null;
        }
    }

    private static final class NoClusterNode
    extends ModuleFolderNode {
        NoClusterNode() {
            super(new NoClusterChildren());
            this.setName("noCluster");
            this.setDisplayName(NbBundle.getMessage(ModuleNode.class, (String)"LBL_ModuleNode_no_cluster"));
            this.updateDisplayStuff();
            this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, null));
        }

        protected boolean supportsEnabledProperty() {
            return true;
        }

        protected boolean contains(ModuleBean moduleBean) {
            return moduleBean.getCluster() == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SortMode {
        BY_CATEGORY,
        BY_DISPLAY_NAME,
        BY_CLUSTER;

    }
}

