/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisibilityQuery {
    private static final VisibilityQuery INSTANCE = new VisibilityQuery();
    private final ResultListener resultListener = new ResultListener();
    private final VqiChangedListener vqiListener = new VqiChangedListener();
    private final List<ChangeListener> listeners = Collections.synchronizedList(new ArrayList());
    private Lookup.Result<VisibilityQueryImplementation> vqiResult = null;
    private Set<VisibilityQueryImplementation> cachedVqiInstances = null;

    public static final VisibilityQuery getDefault() {
        return INSTANCE;
    }

    private VisibilityQuery() {
    }

    public boolean isVisible(FileObject fileObject) {
        VisibilityQueryImplementation visibilityQueryImplementation;
        boolean bl = true;
        Iterator<VisibilityQueryImplementation> iterator = this.getVqiInstances().iterator();
        while (iterator.hasNext() && (bl = (visibilityQueryImplementation = iterator.next()).isVisible(fileObject))) {
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] changeListenerArray;
        Object object = this.listeners;
        synchronized (object) {
            if (this.listeners.isEmpty()) {
                return;
            }
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    private synchronized Set<VisibilityQueryImplementation> getVqiInstances() {
        if (this.cachedVqiInstances == null) {
            this.vqiResult = Lookup.getDefault().lookupResult(VisibilityQueryImplementation.class);
            this.vqiResult.addLookupListener((LookupListener)this.resultListener);
            this.setupChangeListeners(this.cachedVqiInstances, new LinkedHashSet<VisibilityQueryImplementation>(this.vqiResult.allInstances()));
        }
        return this.cachedVqiInstances;
    }

    private synchronized void setupChangeListeners(Set<VisibilityQueryImplementation> set, Set<VisibilityQueryImplementation> set2) {
        HashSet<VisibilityQueryImplementation> hashSet;
        if (set != null) {
            hashSet = new HashSet<VisibilityQueryImplementation>(set);
            hashSet.removeAll(set2);
            for (VisibilityQueryImplementation visibilityQueryImplementation : hashSet) {
                visibilityQueryImplementation.removeChangeListener(this.vqiListener);
            }
        }
        hashSet = new HashSet<VisibilityQueryImplementation>(set2);
        if (set != null) {
            hashSet.removeAll(set);
        }
        for (VisibilityQueryImplementation visibilityQueryImplementation : hashSet) {
            visibilityQueryImplementation.addChangeListener(this.vqiListener);
        }
        this.cachedVqiInstances = set2;
    }

    private class ResultListener
    implements LookupListener {
        private ResultListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            VisibilityQuery.this.setupChangeListeners(VisibilityQuery.this.cachedVqiInstances, new LinkedHashSet(VisibilityQuery.this.vqiResult.allInstances()));
            VisibilityQuery.this.fireChange();
        }
    }

    private class VqiChangedListener
    implements ChangeListener {
        private VqiChangedListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            VisibilityQuery.this.fireChange();
        }
    }
}

