/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.netbeans.modules.subversion.Subversion;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class FileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOTVERSIONED_NOTMANAGED = 1;
    public static final int STATUS_NOTVERSIONED_EXCLUDED = 2;
    public static final int STATUS_NOTVERSIONED_NEWLOCALLY = 4;
    public static final int STATUS_VERSIONED_UPTODATE = 8;
    public static final int STATUS_VERSIONED_MODIFIEDLOCALLY = 16;
    public static final int STATUS_VERSIONED_MODIFIEDINREPOSITORY = 32;
    public static final int STATUS_VERSIONED_CONFLICT = 64;
    public static final int STATUS_VERSIONED_MERGE = 128;
    public static final int STATUS_VERSIONED_REMOVEDLOCALLY = 256;
    public static final int STATUS_VERSIONED_NEWINREPOSITORY = 512;
    public static final int STATUS_VERSIONED_REMOVEDINREPOSITORY = 1024;
    public static final int STATUS_VERSIONED_DELETEDLOCALLY = 2048;
    public static final int STATUS_VERSIONED_ADDEDLOCALLY = 4096;
    public static final int STATUS_ALL = -1;
    public static final int STATUS_MANAGED = -2;
    public static final int STATUS_VERSIONED = 7672;
    public static final int STATUS_IN_REPOSITORY = 4088;
    public static final int STATUS_LOCAL_CHANGE = 6612;
    public static final int STATUS_REVERTIBLE_CHANGE = 6608;
    public static final int STATUS_REMOTE_CHANGE = 1696;
    private final int status;
    private final int propStatus;
    private transient ISVNStatus entry;
    private final boolean isDirectory;
    private static final String STATUS_UNKNOWN_EXT = "W";
    private static final String STATUS_NOTVERSIONED_NOTMANAGED_EXT = "Z";
    private static final String STATUS_NOTVERSIONED_EXCLUDED_EXT = "I";
    private static final String STATUS_NOTVERSIONED_NEWLOCALLY_EXT = "?";
    private static final String STATUS_VERSIONED_UPTODATE_EXT = "S";
    private static final String STATUS_VERSIONED_MODIFIEDLOCALLY_EXT = "M";
    private static final String STATUS_VERSIONED_MODIFIEDINREPOSITORY_EXT = "G";
    private static final String STATUS_VERSIONED_CONFLICT_EXT = "C";
    private static final String STATUS_VERSIONED_MERGE_EXT = "P";
    private static final String STATUS_VERSIONED_REMOVEDLOCALLY_EXT = "R";
    private static final String STATUS_VERSIONED_NEWINREPOSITORY_EXT = "N";
    private static final String STATUS_VERSIONED_REMOVEDINREPOSITORY_EXT = "D";
    private static final String STATUS_VERSIONED_DELETEDLOCALLY_EXT = "E";
    private static final String STATUS_VERSIONED_ADDEDLOCALLY_EXT = "A";
    private final Exception origin;

    public FileInformation() {
        this.status = 0;
        this.propStatus = 0;
        this.isDirectory = false;
        this.origin = new RuntimeException("allocated at:");
    }

    private FileInformation(int n, int n2, ISVNStatus iSVNStatus, boolean bl) {
        this.status = n;
        this.propStatus = n2;
        this.entry = iSVNStatus;
        this.isDirectory = bl;
        this.origin = new RuntimeException("allocated at:");
    }

    FileInformation(int n, ISVNStatus iSVNStatus) {
        this(n, 0, iSVNStatus, iSVNStatus.getNodeKind() == SVNNodeKind.DIR);
    }

    FileInformation(int n, boolean bl) {
        this(n, 0, null, bl);
    }

    FileInformation(int n, int n2, boolean bl) {
        this(n, n2, null, bl);
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public ISVNStatus getEntry(File file) {
        if (this.entry == null && file != null) {
            this.readEntry(file);
        }
        return this.entry;
    }

    private void readEntry(File file) {
        try {
            this.entry = Subversion.getInstance().getClient(true).getSingleStatus(file);
        }
        catch (SVNClientException sVNClientException) {
            // empty catch block
        }
    }

    public String getStatusText() {
        return this.getStatusText(-1);
    }

    public String getStatusText(int n) {
        int n2 = this.status & n;
        ResourceBundle resourceBundle = NbBundle.getBundle(FileInformation.class);
        if (n2 == 0) {
            return resourceBundle.getString("CTL_FileInfoStatus_Unknown");
        }
        if (FileInformation.match(n2, 2)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded");
        }
        if (FileInformation.match(n2, 4)) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally");
        }
        if (FileInformation.match(n2, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                return resourceBundle.getString("CTL_FileInfoStatus_AddedLocallyCopied");
            }
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally");
        }
        if (FileInformation.match(n2, 8)) {
            return resourceBundle.getString("CTL_FileInfoStatus_UpToDate");
        }
        if (FileInformation.match(n2, 64)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict");
        }
        if (FileInformation.match(n2, 128)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Merge");
        }
        if (FileInformation.match(n2, 2048)) {
            return resourceBundle.getString("CTL_FileInfoStatus_DeletedLocally");
        }
        if (FileInformation.match(n2, 256)) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedLocally");
        }
        if (FileInformation.match(n2, 16)) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally");
        }
        if (FileInformation.match(n2, 512)) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewInRepository");
        }
        if (FileInformation.match(n2, 32)) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedInRepository");
        }
        if (FileInformation.match(n2, 1024)) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedInRepository");
        }
        return "";
    }

    public String getShortStatusText() {
        ResourceBundle resourceBundle = NbBundle.getBundle(FileInformation.class);
        if (FileInformation.match(this.status, 2)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Excluded_Short");
        }
        if (FileInformation.match(this.status, 4)) {
            return resourceBundle.getString("CTL_FileInfoStatus_NewLocally_Short");
        }
        if (FileInformation.match(this.status, 4096)) {
            if (this.entry != null && this.entry.isCopied()) {
                return resourceBundle.getString("CTL_FileInfoStatus_AddedLocallyCopied_Short");
            }
            return resourceBundle.getString("CTL_FileInfoStatus_AddedLocally_Short");
        }
        if (this.status == 256) {
            return resourceBundle.getString("CTL_FileInfoStatus_RemovedLocally_Short");
        }
        if (this.status == 2048) {
            return resourceBundle.getString("CTL_FileInfoStatus_DeletedLocally_Short");
        }
        if (FileInformation.match(this.status, 16)) {
            return resourceBundle.getString("CTL_FileInfoStatus_ModifiedLocally_Short");
        }
        if (FileInformation.match(this.status, 64)) {
            return resourceBundle.getString("CTL_FileInfoStatus_Conflict_Short");
        }
        return "";
    }

    private static boolean match(int n, int n2) {
        return (n & n2) != 0;
    }

    public String toString() {
        return "Text: " + this.status + " " + this.getStatusText(this.status) + "\nProp: " + this.propStatus + " " + this.getStatusText(this.propStatus);
    }
}

