/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.subversion.DiskMapTurboProvider;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.util.FlatFolder;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatusCache
implements ISVNNotifyListener {
    public static final Object EVENT_FILE_STATUS_CHANGED = new Object();
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final ISVNStatus REPOSITORY_STATUS_UNKNOWN = null;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final Pattern auxConflictPattern = Pattern.compile("(.*?)\\.((r\\d+)|(mine)|(working)|(merge-right\\.r\\d+)|((merge-left.r\\d+)))$");
    private final Turbo turbo;
    private final String FILE_STATUS_MAP = "subversion.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private Subversion svn;
    private Set<FileSystem> filesystemsToRefresh;
    private RequestProcessor.Task refreshFilesystemsTask;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    FileStatusCache() {
        this.svn = Subversion.getInstance();
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
    }

    public File[] listFiles(File file) {
        Set<File> set = this.getScannedFiles(file).keySet();
        return set.toArray(new File[set.size()]);
    }

    public File[] listFiles(Context context, int n) {
        Object object;
        Object object2;
        HashSet<File> hashSet = new HashSet<File>();
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        block0: for (File file : map.keySet()) {
            object2 = map.get(file);
            if ((((FileInformation)object2).getStatus() & n) == 0) continue;
            object = context.getRootFiles();
            for (int i = 0; i < ((File[])object).length; ++i) {
                File file2 = object[i];
                if (file2 instanceof FlatFolder) {
                    if (!file.equals(file2) && !file.getParentFile().equals(file2)) continue;
                    hashSet.add(file);
                    continue block0;
                }
                if (!SvnUtils.isParentOrEqual(file2, file)) continue;
                hashSet.add(file);
                continue block0;
            }
        }
        if (context.getExclusions().size() > 0) {
            for (File file : context.getExclusions()) {
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (File)object2.next();
                    if (!SvnUtils.isParentOrEqual(file, (File)object)) continue;
                    object2.remove();
                }
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public File[] listFiles(File[] fileArray, int n) {
        HashSet<File> hashSet = new HashSet<File>();
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        block0: for (File file : map.keySet()) {
            FileInformation fileInformation = map.get(file);
            if ((fileInformation.getStatus() & n) == 0) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2 instanceof FlatFolder) {
                    if (!file.getParentFile().equals(file2)) continue;
                    hashSet.add(file);
                    continue block0;
                }
                if (!SvnUtils.isParentOrEqual(file2, file)) continue;
                hashSet.add(file);
                continue block0;
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public FileInformation getStatus(File file) {
        if (this.svn.isAdministrative(file)) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        if (fileInformation != null) {
            return fileInformation;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
        return new FileInformation(8, false);
    }

    FileInformation getCachedStatus(File file) {
        if ((file = file.getParentFile()) == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map map = (Map)this.turbo.readEntry((Object)file, "subversion.STATUS_MAP");
        return map != null ? (FileInformation)map.get(file) : null;
    }

    private FileInformation refresh(File file, ISVNStatus iSVNStatus, boolean bl) {
        Object object;
        ISVNStatus iSVNStatus2;
        FileInformation fileInformation;
        Map<File, FileInformation> map;
        File file2;
        block16: {
            file2 = file.getParentFile();
            if (file2 == null) {
                return FILE_INFORMATION_NOTMANAGED;
            }
            map = this.getScannedFiles(file2);
            if (map == NOT_MANAGED_MAP && iSVNStatus == REPOSITORY_STATUS_UNKNOWN) {
                return FILE_INFORMATION_NOTMANAGED;
            }
            fileInformation = map.get(file);
            iSVNStatus2 = null;
            try {
                object = Subversion.getInstance().getClient(false);
                iSVNStatus2 = object.getSingleStatus(file);
                if (iSVNStatus2 != null && SVNStatusKind.UNVERSIONED.equals((Object)iSVNStatus2.getTextStatus())) {
                    iSVNStatus2 = null;
                }
            }
            catch (SVNClientException sVNClientException) {
                if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block16;
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
        object = this.createFileInformation(file, iSVNStatus2, iSVNStatus);
        if (FileStatusCache.equivalent((FileInformation)object, fileInformation)) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, (FileInformation)object);
            }
            return object;
        }
        if (fileInformation == null && !((FileInformation)object).isDirectory() && ((FileInformation)object).getStatus() == 8) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, (FileInformation)object);
            }
            return object;
        }
        file = FileUtil.normalizeFile((File)file);
        file2 = FileUtil.normalizeFile((File)file2);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map);
        if (((FileInformation)object).getStatus() == 0) {
            hashMap.remove(file);
            this.turbo.writeEntry((Object)file, "subversion.STATUS_MAP", null);
        } else if (((FileInformation)object).getStatus() == 8 && file.isFile()) {
            hashMap.remove(file);
        } else {
            hashMap.put(file, (FileInformation)object);
        }
        assert (!hashMap.containsKey(file2));
        this.turbo.writeEntry((Object)file2, "subversion.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
        if (file.isDirectory() && this.needRecursiveRefresh((FileInformation)object, fileInformation)) {
            File[] fileArray = this.listFiles(file);
            for (int i = 0; i < fileArray.length; ++i) {
                this.refresh(fileArray[i], REPOSITORY_STATUS_UNKNOWN);
            }
        }
        this.fireFileStatusChanged(file, fileInformation, (FileInformation)object);
        return object;
    }

    public FileInformation refresh(File file, ISVNStatus iSVNStatus) {
        return this.refresh(file, iSVNStatus, false);
    }

    private static boolean equivalent(FileInformation fileInformation, FileInformation fileInformation2) {
        ISVNStatus iSVNStatus;
        if (fileInformation2 == null || fileInformation.getStatus() != fileInformation2.getStatus() || fileInformation.isDirectory() != fileInformation2.isDirectory()) {
            return false;
        }
        ISVNStatus iSVNStatus2 = fileInformation.getEntry(null);
        return iSVNStatus2 == (iSVNStatus = fileInformation2.getEntry(null)) || iSVNStatus2 == null || iSVNStatus == null || FileStatusCache.equal(iSVNStatus2, iSVNStatus);
    }

    private static boolean equal(ISVNStatus iSVNStatus, ISVNStatus iSVNStatus2) {
        long l = -1L;
        if (iSVNStatus != null) {
            SVNRevision.Number number = iSVNStatus.getRevision();
            l = number != null ? iSVNStatus.getRevision().getNumber() : l;
        }
        long l2 = -2L;
        if (iSVNStatus2 != null) {
            SVNRevision.Number number = iSVNStatus.getRevision();
            long l3 = l2 = number != null ? iSVNStatus2.getRevision().getNumber() : l2;
        }
        if (l != l2) {
            return false;
        }
        return iSVNStatus.getUrl() == iSVNStatus2.getUrl() || iSVNStatus.getUrl() != null && iSVNStatus.getUrl().equals((Object)iSVNStatus2.getUrl());
    }

    private boolean needRecursiveRefresh(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation.getStatus() == 2 || fileInformation2 != null && fileInformation2.getStatus() == 2) {
            return true;
        }
        return fileInformation.getStatus() == 1 || fileInformation2 != null && fileInformation2.getStatus() == 1;
    }

    public void refreshCached(File file, ISVNStatus iSVNStatus) {
        this.refresh(file, iSVNStatus);
    }

    public void refreshCached(Context context) {
        File[] fileArray = this.listFiles(context, -1);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            this.refreshCached(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    Map<File, FileInformation> getAllModifiedFiles() {
        return this.cacheProvider.getAllModifiedValues();
    }

    void directoryContentChanged(File file) {
        Map map = (Map)this.turbo.readEntry((Object)file, "subversion.STATUS_MAP");
        if (map != null) {
            for (File file2 : map.keySet()) {
                this.refresh(file2, REPOSITORY_STATUS_UNKNOWN);
            }
        }
    }

    void cleanUp() {
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        for (File file : map.keySet()) {
            FileInformation fileInformation = map.get(file);
            if ((fileInformation.getStatus() & 0x19D4) != 0) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
                continue;
            }
            if (fileInformation.getStatus() != 2 || this.exists(file)) continue;
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    private Map<File, FileInformation> getScannedFiles(File file) {
        if (this.svn.isAdministrative(file)) {
            return NOT_MANAGED_MAP;
        }
        File file2 = file.getParentFile();
        if (file2 != null && this.svn.isAdministrative(file2)) {
            return NOT_MANAGED_MAP;
        }
        Map<File, FileInformation> map = (Map<File, FileInformation>)this.turbo.readEntry((Object)file, "subversion.STATUS_MAP");
        if (map != null) {
            return map;
        }
        if (this.isNotManagedByDefault(file)) {
            return NOT_MANAGED_MAP;
        }
        file = FileUtil.normalizeFile((File)file);
        map = this.scanFolder(file);
        assert (!map.containsKey(file));
        this.turbo.writeEntry((Object)file, "subversion.STATUS_MAP", map);
        for (File file3 : map.keySet()) {
            FileInformation fileInformation = map.get(file3);
            if ((fileInformation.getStatus() & 0x19D4) == 0) continue;
            this.fireFileStatusChanged(file3, null, fileInformation);
        }
        return map;
    }

    private boolean isNotManagedByDefault(File file) {
        return !file.exists();
    }

    private Map<File, FileInformation> scanFolder(File file) {
        Object object;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(fileArray.length);
        ISVNStatus[] iSVNStatusArray = null;
        try {
            object = Subversion.getInstance().getClient(true);
            if (Subversion.getInstance().isManaged(file)) {
                iSVNStatusArray = object.getStatus(file, false, false);
            }
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
        }
        if (iSVNStatusArray == null) {
            for (int i = 0; i < fileArray.length; ++i) {
                FileInformation fileInformation;
                File file2 = fileArray[i];
                if (this.svn.isAdministrative(file2) || !(fileInformation = this.createFileInformation(file2, null, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fileInformation.getStatus() == 8) continue;
                hashMap.put(file2, fileInformation);
            }
        } else {
            Serializable serializable;
            Object object2;
            object = new HashSet<File>(Arrays.asList(fileArray));
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                FileInformation fileInformation;
                object2 = iSVNStatusArray[i];
                serializable = new File(object2.getPath());
                if (((File)serializable).equals(file)) continue;
                object.remove(serializable);
                if (this.svn.isAdministrative((File)serializable) || !(fileInformation = this.createFileInformation((File)serializable, (ISVNStatus)object2, REPOSITORY_STATUS_UNKNOWN)).isDirectory() && fileInformation.getStatus() == 8) continue;
                hashMap.put((File)serializable, fileInformation);
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = (File)iterator.next();
                serializable = this.createFileInformation((File)object2, null, REPOSITORY_STATUS_UNKNOWN);
                if (!((FileInformation)serializable).isDirectory() && ((FileInformation)serializable).getStatus() == 8) continue;
                hashMap.put((File)object2, (FileInformation)serializable);
            }
        }
        return hashMap;
    }

    private FileInformation createFileInformation(File file, ISVNStatus iSVNStatus, ISVNStatus iSVNStatus2) {
        if (iSVNStatus == null || iSVNStatus.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED)) {
            if (!this.svn.isManaged(file)) {
                return file.isDirectory() ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_NOTMANAGED;
            }
            return this.createMissingEntryFileInformation(file, iSVNStatus2);
        }
        return this.createVersionedFileInformation(file, iSVNStatus, iSVNStatus2);
    }

    private FileInformation createVersionedFileInformation(File file, ISVNStatus iSVNStatus, ISVNStatus iSVNStatus2) {
        SVNStatusKind sVNStatusKind = iSVNStatus.getTextStatus();
        SVNStatusKind sVNStatusKind2 = iSVNStatus.getPropStatus();
        int n = 0;
        if (iSVNStatus2 != REPOSITORY_STATUS_UNKNOWN) {
            if (iSVNStatus2.getRepositoryTextStatus() == SVNStatusKind.MODIFIED || iSVNStatus2.getRepositoryPropStatus() == SVNStatusKind.MODIFIED) {
                n = 32;
            } else if (iSVNStatus2.getRepositoryTextStatus() == SVNStatusKind.DELETED) {
                n = 1024;
            } else if (iSVNStatus2.getRepositoryTextStatus() != SVNStatusKind.ADDED && (iSVNStatus2.getRepositoryTextStatus() != null || iSVNStatus2.getRepositoryPropStatus() != null)) {
                System.err.println("SVN.FSC: unhandled repository status: " + file.getAbsolutePath());
                System.err.println("\ttext: " + iSVNStatus2.getRepositoryTextStatus());
                System.err.println("\tprop: " + iSVNStatus2.getRepositoryPropStatus());
            }
        }
        if (!SVNStatusKind.NONE.equals((Object)sVNStatusKind2) && !SVNStatusKind.NORMAL.equals((Object)sVNStatusKind2)) {
            if (SVNStatusKind.MODIFIED.equals((Object)sVNStatusKind2)) {
                if (SVNStatusKind.NORMAL.equals((Object)sVNStatusKind)) {
                    return new FileInformation(0x10 | n, iSVNStatus);
                }
            } else {
                if (SVNStatusKind.CONFLICTED.equals((Object)sVNStatusKind2)) {
                    return new FileInformation(0x40 | n, iSVNStatus);
                }
                throw new IllegalArgumentException("Unknown prop status: " + iSVNStatus.getPropStatus());
            }
        }
        if (SVNStatusKind.NONE.equals((Object)sVNStatusKind)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (SVNStatusKind.NORMAL.equals((Object)sVNStatusKind)) {
            return new FileInformation(8 | n, iSVNStatus);
        }
        if (SVNStatusKind.MODIFIED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x10 | n, iSVNStatus);
        }
        if (SVNStatusKind.ADDED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x1000 | n, iSVNStatus);
        }
        if (SVNStatusKind.DELETED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x100 | n, iSVNStatus);
        }
        if (SVNStatusKind.UNVERSIONED.equals((Object)sVNStatusKind)) {
            return new FileInformation(4 | n, iSVNStatus);
        }
        if (SVNStatusKind.MISSING.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x800 | n, iSVNStatus);
        }
        if (SVNStatusKind.REPLACED.equals((Object)sVNStatusKind)) {
            return new FileInformation(4 | n, iSVNStatus);
        }
        if (SVNStatusKind.MERGED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x80 | n, iSVNStatus);
        }
        if (SVNStatusKind.CONFLICTED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x40 | n, iSVNStatus);
        }
        if (SVNStatusKind.OBSTRUCTED.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x40 | n, iSVNStatus);
        }
        if (SVNStatusKind.IGNORED.equals((Object)sVNStatusKind)) {
            return new FileInformation(2 | n, iSVNStatus);
        }
        if (SVNStatusKind.INCOMPLETE.equals((Object)sVNStatusKind)) {
            return new FileInformation(0x40 | n, iSVNStatus);
        }
        if (SVNStatusKind.EXTERNAL.equals((Object)sVNStatusKind)) {
            return new FileInformation(8 | n, iSVNStatus);
        }
        throw new IllegalArgumentException("Unknown text status: " + iSVNStatus.getTextStatus());
    }

    static String statusText(ISVNStatus iSVNStatus) {
        return "file: " + iSVNStatus.getTextStatus().toString() + " copied: " + iSVNStatus.isCopied() + " prop: " + iSVNStatus.getPropStatus().toString();
    }

    private FileInformation createMissingEntryFileInformation(File file, ISVNStatus iSVNStatus) {
        String string;
        File file2;
        File file3;
        boolean bl = file.isDirectory();
        int n = this.getStatus(file.getParentFile()).getStatus();
        if (n == 2) {
            return bl ? FILE_INFORMATION_EXCLUDED_DIRECTORY : FILE_INFORMATION_EXCLUDED;
        }
        if (n == 1) {
            if (bl) {
                return SvnUtils.isPartOfSubversionMetadata(file) ? FILE_INFORMATION_NOTMANAGED_DIRECTORY : FILE_INFORMATION_UPTODATE_DIRECTORY;
            }
            return FILE_INFORMATION_NOTMANAGED;
        }
        String string2 = file.getName();
        Matcher matcher = auxConflictPattern.matcher(string2);
        if (matcher.matches() && (file3 = file.getParentFile()) != null && (file2 = new File(file3, string = matcher.group(1))).isFile()) {
            return FILE_INFORMATION_EXCLUDED;
        }
        if (file.exists()) {
            if (Subversion.getInstance().isIgnored(file)) {
                return new FileInformation(2, file.isDirectory());
            }
            return new FileInformation(4, file.isDirectory());
        }
        if (iSVNStatus != REPOSITORY_STATUS_UNKNOWN && iSVNStatus.getRepositoryTextStatus() == SVNStatusKind.ADDED) {
            boolean bl2 = iSVNStatus.getNodeKind() == SVNNodeKind.DIR;
            return new FileInformation(512, bl2);
        }
        return FILE_INFORMATION_UNKNOWN;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    public void addVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.addListener(versioningListener);
    }

    public void removeVersioningListener(VersioningListener versioningListener) {
        this.listenerSupport.removeListener(versioningListener);
    }

    private void fireFileStatusChanged(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        this.listenerSupport.fireVersioningEvent(EVENT_FILE_STATUS_CHANGED, new Object[]{file, fileInformation, fileInformation2});
    }

    public void setCommand(int n) {
    }

    public void logCommandLine(String string) {
    }

    public void logMessage(String string) {
    }

    public void logError(String string) {
    }

    public void logRevision(long l, String string) {
    }

    public void logCompleted(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotify(File file, SVNNodeKind sVNNodeKind) {
        if (file == null) {
            return;
        }
        file = FileUtil.normalizeFile((File)file);
        this.refresh(file, REPOSITORY_STATUS_UNKNOWN, true);
        do {
            FileObject fileObject;
            if ((fileObject = FileUtil.toFileObject((File)file)) == null) continue;
            try {
                Set<FileSystem> set;
                Set<FileSystem> set2 = set = this.getFilesystemsToRefresh();
                synchronized (set2) {
                    set.add(fileObject.getFileSystem());
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {}
            break;
        } while ((file = file.getParentFile()) != null);
    }

    public void refreshDirtyFileSystems() {
        if (this.refreshFilesystemsTask == null) {
            RequestProcessor requestProcessor = new RequestProcessor();
            this.refreshFilesystemsTask = requestProcessor.create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Set set = FileStatusCache.this.getFilesystemsToRefresh();
                    FileSystem[] fileSystemArray = new FileSystem[set.size()];
                    Set set2 = set;
                    synchronized (set2) {
                        fileSystemArray = set.toArray(new FileSystem[set.size()]);
                        set.clear();
                    }
                    for (int i = 0; i < fileSystemArray.length; ++i) {
                        fileSystemArray[i].refresh(true);
                    }
                }
            });
        }
        this.refreshFilesystemsTask.schedule(200);
    }

    private Set<FileSystem> getFilesystemsToRefresh() {
        if (this.filesystemsToRefresh == null) {
            this.filesystemsToRefresh = new HashSet<FileSystem>();
        }
        return this.filesystemsToRefresh;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set<Map.Entry<File, FileInformation>> entrySet() {
            return Collections.emptySet();
        }
    }
}

