/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.ErrorManager;
import org.tigris.subversion.svnclientadapter.SVNClientException;

class FilesystemHandler
extends VCSInterceptor {
    private final Subversion svn;
    private final FileStatusCache cache;
    private final Set<File> invalidMetadata = new HashSet<File>(5);

    public FilesystemHandler(Subversion subversion) {
        this.svn = subversion;
        this.cache = subversion.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return true;
        }
        return !file.isFile() && this.hasMetadata(file);
    }

    public void doDelete(File file) throws IOException {
        boolean bl = SvnUtils.isPartOfSubversionMetadata(file);
        if (!bl) {
            this.remove(file);
        }
    }

    public void afterDelete(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileDeletedImpl(file);
            }
        });
    }

    public boolean beforeMove(File file, File file2) {
        FileInformation fileInformation;
        File file3 = file2.getParentFile();
        if (file != null && file3 != null && ((fileInformation = this.cache.getStatus(file)).getStatus() & 0x1DF8) != 0) {
            return Subversion.getInstance().isManaged(file2);
        }
        return false;
    }

    public void doMove(final File file, final File file2) throws IOException {
        if (SwingUtilities.isEventDispatchThread()) {
            Logger.getLogger("org.netbeans.modules.subversion").log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        FilesystemHandler.this.svnMoveImplementation(file, file2);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            Subversion.getInstance().getRequestProcessor().post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof IOException) {
                    throw (IOException)throwableArray[0];
                }
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new IllegalStateException("Unexpected exception class: " + throwableArray[0]);
            }
        } else {
            this.svnMoveImplementation(file, file2);
        }
    }

    public void afterMove(final File file, final File file2) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.cache.refresh(file2, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    if (file.equals(file2)) {
                        ErrorManager.getDefault().log(16, "Wrong (identity) rename event for " + file.getAbsolutePath());
                    }
                    FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    public boolean beforeCreate(File file, boolean bl) {
        int n;
        if (this.svn.isAdministrative(file.getName())) {
            if (file.isDirectory()) {
                File file2 = new File(file, "invalid-metadata");
                try {
                    file2.createNewFile();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(65536, "Unable to create marker: " + file2.getAbsolutePath());
                }
                this.invalidMetadata.add(file);
            }
            return true;
        }
        if (!file.exists() && (n = this.cache.getStatus(file).getStatus()) == 256) {
            try {
                SvnClient svnClient = Subversion.getInstance().getClient(true);
                svnClient.revert(file, false);
                file.delete();
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
        return false;
    }

    public void doCreate(File file, boolean bl) throws IOException {
    }

    public void afterCreate(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if (file == null) {
                    return;
                }
                int n = FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                if ((n & 0xFFFFFFFE) == 0) {
                    return;
                }
                if (file.isDirectory()) {
                    FilesystemHandler.this.cache.directoryContentChanged(file);
                }
            }
        });
    }

    public void afterChange(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                if ((FilesystemHandler.this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) != 0) {
                    FilesystemHandler.this.cache.refreshCached(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInvalidMetadata() {
        Set<File> set = this.invalidMetadata;
        synchronized (set) {
            for (File file : this.invalidMetadata) {
                Utils.deleteRecursively((File)file);
            }
            this.invalidMetadata.clear();
        }
    }

    private void fileDeletedImpl(File file) {
        if (file == null) {
            return;
        }
        int n = this.cache.getStatus(file).getStatus();
        if (n != 2 && n != 4) {
            try {
                SvnClient svnClient = Subversion.getInstance().getClient(false);
                svnClient.remove(new File[]{file}, true);
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
        }
        this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    private boolean hasMetadata(File file) {
        return new File(file, ".svn/entries").canRead() || new File(file, "_svn/entries").canRead();
    }

    private boolean remove(File file) {
        try {
            SvnClient svnClient = Subversion.getInstance().getClient(false);
            svnClient.remove(new File[]{file}, true);
            return true;
        }
        catch (SVNClientException sVNClientException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void svnMoveImplementation(File file, File file2) throws IOException {
        try {
            boolean bl = true;
            SvnClient svnClient = Subversion.getInstance().getClient(false);
            File file3 = null;
            try {
                int n;
                this.removeInvalidMetadata();
                File file4 = file2.isDirectory() ? file2 : file2.getParentFile();
                if (file4 != null) {
                    n = this.cache.getStatus(file4).getStatus();
                    assert (Subversion.getInstance().isManaged(file4));
                    if ((0x1DF8 & n) == 0) {
                        this.addDirectories(file4);
                    }
                }
                n = 6;
                while (true) {
                    try {
                        svnClient.move(file, file2, bl);
                    }
                    catch (SVNClientException sVNClientException) {
                        if (sVNClientException.getMessage().endsWith("' locked") && n > 0) {
                            try {
                                Thread.sleep(107L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            --n;
                            continue;
                        }
                        if (file.renameTo(file2)) {
                            ErrorManager.getDefault().annotate((Throwable)sVNClientException, "Relaxing Subversion rename error....");
                            ErrorManager.getDefault().notify(1, (Throwable)sVNClientException);
                            break;
                        }
                        IOException iOException = new IOException("Subversion failed to rename " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath());
                        iOException.initCause(sVNClientException);
                        throw iOException;
                    }
                    break;
                }
            }
            finally {
                if (file3 != null) {
                    FileUtils.deleteRecursively(file3);
                }
            }
        }
        catch (SVNClientException sVNClientException) {
            IOException iOException = new IOException("Subversion failed to rename " + file.getAbsolutePath() + " to: " + file2.getAbsolutePath());
            iOException.initCause(sVNClientException);
            throw iOException;
        }
    }

    private void addDirectories(File file) throws SVNClientException {
        File file2 = file.getParentFile();
        if (file2 != null) {
            int n = this.cache.getStatus(file2).getStatus();
            if ((0x1DF8 & n) == 0) {
                this.addDirectories(file2);
            }
        } else {
            throw new SVNClientException("Reached FS root, but it's still not Subversion versioned!");
        }
        SvnClient svnClient = Subversion.getInstance().getClient(false);
        svnClient.addDirectory(file, false);
        this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }
}

