/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.Diagnostics;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.FileStatusProvider;
import org.netbeans.modules.subversion.FilesystemHandler;
import org.netbeans.modules.subversion.OutputLogger;
import org.netbeans.modules.subversion.SubversionVCS;
import org.netbeans.modules.subversion.SubversionVisibilityQuery;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.netbeans.modules.subversion.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.OriginalContent;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Subversion {
    static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final int STATUS_DIFFABLE = 5372;
    private static Subversion instance;
    private FileStatusCache fileStatusCache;
    private FilesystemHandler filesystemHandler;
    private FileStatusProvider fileStatusProvider;
    private Annotator annotator;
    private HashMap<String, RequestProcessor> processorsToUrl;
    private SvnClient noUrlClientWithoutListeners;
    private SvnClient noUrlClientWithListeners;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public static synchronized Subversion getInstance() {
        if (instance == null) {
            instance = new Subversion();
            instance.init();
        }
        return instance;
    }

    private Subversion() {
    }

    private void init() {
        Diagnostics.init();
        this.loadIniParserClassesWorkaround();
        SvnClientFactory.init();
        this.fileStatusCache = new FileStatusCache();
        this.annotator = new Annotator(this);
        this.fileStatusProvider = new FileStatusProvider();
        this.filesystemHandler = new FilesystemHandler(this);
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIniParserClassesWorkaround() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            SvnConfigFiles.getInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private void cleanup() {
        this.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Diagnostics.println("Cleaning up");
                    Subversion.this.fileStatusCache.cleanUp();
                }
                finally {
                    Diagnostics.println("END Cleaning up");
                }
            }
        }, 3000);
    }

    public void shutdown() {
        this.fileStatusProvider.shutdown();
    }

    public SvnFileNode[] getNodes(Context context, int n) {
        File[] fileArray = this.fileStatusCache.listFiles(context, n);
        SvnFileNode[] svnFileNodeArray = new SvnFileNode[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            svnFileNodeArray[i] = new SvnFileNode(fileArray[i]);
        }
        return svnFileNodeArray;
    }

    public String getMimeType(File file) {
        String string;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            string = "content/unknown";
        } else {
            string = fileObject.getMIMEType();
            if ("content/unknown".equals(string)) {
                string = "text/plain";
            }
        }
        if ((this.fileStatusCache.getStatus(file).getStatus() & 0x1DF8) == 0) {
            return SvnUtils.isFileContentBinary(file) ? "application/octet-stream" : string;
        }
        PropertiesClient propertiesClient = new PropertiesClient(file);
        try {
            byte[] byArray = propertiesClient.getProperties().get("svn:mime-type");
            if (byArray == null) {
                return string;
            }
            return new String(byArray);
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public boolean isAdministrative(File file) {
        String string = file.getName();
        return this.isAdministrative(string) && file.isDirectory();
    }

    public boolean isAdministrative(String string) {
        return string.equals(".svn") || string.equals("_svn");
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public boolean checkClientAvailable() {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return false;
        }
        return true;
    }

    public SvnClient getClient(SVNUrl sVNUrl, String string, String string2) throws SVNClientException {
        return this.getClient(sVNUrl, string, string2, 44);
    }

    public SvnClient getClient(SVNUrl sVNUrl, String string, String string2, int n) throws SVNClientException {
        SvnClient svnClient = SvnClientFactory.getInstance().createSvnClient(sVNUrl, null, string, string2, n);
        this.attachListeners(svnClient);
        return svnClient;
    }

    public SvnClient getClient(SVNUrl sVNUrl, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        String string = "";
        String string2 = "";
        RepositoryConnection repositoryConnection = SvnModuleConfig.getDefault().getRepositoryConnection(sVNUrl.toString());
        if (repositoryConnection != null) {
            string = repositoryConnection.getUsername();
            string2 = repositoryConnection.getPassword();
        }
        SvnClient svnClient = SvnClientFactory.getInstance().createSvnClient(sVNUrl, svnProgressSupport, string, string2, 44);
        this.attachListeners(svnClient);
        return svnClient;
    }

    public SvnClient getClient(File file) throws SVNClientException {
        return this.getClient(file, null);
    }

    public SvnClient getClient(File file, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        assert (sVNUrl != null) : "Unable to get repository: " + file.getAbsolutePath() + " is probably unmanaged.";
        return this.getClient(sVNUrl, svnProgressSupport);
    }

    public SvnClient getClient(Context context, SvnProgressSupport svnProgressSupport) throws SVNClientException {
        File[] fileArray = context.getRootFiles();
        SVNUrl sVNUrl = null;
        for (int i = 0; i < fileArray.length && (sVNUrl = SvnUtils.getRepositoryRootUrl(fileArray[0])) == null; ++i) {
        }
        assert (sVNUrl != null) : "Unable to get repository, context contains only unmanaged files!";
        return this.getClient(sVNUrl, svnProgressSupport);
    }

    public SvnClient getClient(SVNUrl sVNUrl) throws SVNClientException {
        return this.getClient(sVNUrl, null);
    }

    public SvnClient getClient(boolean bl) throws SVNClientException {
        this.cleanupFilesystem();
        if (bl) {
            if (this.noUrlClientWithListeners == null) {
                this.noUrlClientWithListeners = SvnClientFactory.getInstance().createSvnClient();
                this.attachListeners(this.noUrlClientWithListeners);
            }
            return this.noUrlClientWithListeners;
        }
        if (this.noUrlClientWithoutListeners == null) {
            this.noUrlClientWithoutListeners = SvnClientFactory.getInstance().createSvnClient();
        }
        return this.noUrlClientWithoutListeners;
    }

    public FilesystemHandler getFileSystemHandler() {
        return this.filesystemHandler;
    }

    public boolean isManaged(File file) {
        return VersioningManager.getInstance().getOwner(file) instanceof SubversionVCS && !SvnUtils.isPartOfSubversionMetadata(file);
    }

    public void versionedFilesChanged() {
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    File getTopmostManagedParent(File file) {
        try {
            SvnClientFactory.checkClientAvailable();
        }
        catch (SVNClientException sVNClientException) {
            return null;
        }
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            while (file != null) {
                if (this.isAdministrative(file)) {
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        File file2 = null;
        while (file != null) {
            if (new File(file, ".svn/entries").canRead() || new File(file, "_svn/entries").canRead()) {
                file2 = file;
            }
            file = file.getParentFile();
        }
        return file2;
    }

    public void cleanupFilesystem() {
        this.filesystemHandler.removeInvalidMetadata();
    }

    private void attachListeners(SvnClient svnClient) {
        svnClient.addNotifyListener(this.getLogger(svnClient.getSvnUrl()));
        svnClient.addNotifyListener(this.fileStatusCache);
    }

    public OutputLogger getLogger(SVNUrl sVNUrl) {
        return OutputLogger.getLogger(sVNUrl);
    }

    boolean isIgnored(File file) {
        int n;
        String string = file.getName();
        File file2 = file.getParentFile();
        if (file2 != null && ((n = this.fileStatusCache.getStatus(file2).getStatus()) & 0x1DF8) != 0) {
            try {
                SvnClient svnClient = this.getClient(false);
                List list = svnClient.getIgnoredPatterns(file2);
                List<String> list2 = SvnConfigFiles.getInstance().getGlobalIgnores();
                Iterator<String> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
                if (SvnUtils.getMatchinIgnoreParterns(list, string, true).size() > 0) {
                    return true;
                }
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
        }
        if (SharabilityQuery.getSharability((File)file) == 2) {
            try {
                FileInformation fileInformation = this.fileStatusCache.getCachedStatus(file);
                if (SubversionVisibilityQuery.isHiddenFolder(fileInformation, file)) {
                    return false;
                }
                if (SharabilityQuery.getSharability((File)file2) != 2 && (this.fileStatusCache.getStatus(file2).getStatus() & 0x1DF8) != 0) {
                    IgnoreAction.ignore(file);
                }
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
            return true;
        }
        return ".nbintdb".equals(string);
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor(null);
    }

    public RequestProcessor getRequestProcessor(SVNUrl sVNUrl) {
        String string;
        RequestProcessor requestProcessor;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((requestProcessor = this.processorsToUrl.get(string = sVNUrl != null ? sVNUrl.toString() : "ANY_URL")) == null) {
            requestProcessor = new RequestProcessor("Subversion - " + string, 1, true);
            this.processorsToUrl.put(string, requestProcessor);
        }
        return requestProcessor;
    }

    FileStatusProvider getVCSAnnotator() {
        return this.fileStatusProvider;
    }

    VCSInterceptor getVCSInterceptor() {
        return this.filesystemHandler;
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public OriginalContent getVCSOriginalContent(File file) {
        FileInformation fileInformation = this.fileStatusCache.getStatus(file);
        if ((fileInformation.getStatus() & 0x14FC) == 0) {
            return null;
        }
        return new SubversionOriginalContent(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubversionOriginalContent
    extends OriginalContent
    implements VersioningListener {
        public SubversionOriginalContent(File file) {
            super(file);
        }

        protected void getOriginalFiles(File file, Set<File> set) throws Exception {
            for (File file2 : set) {
                File file3 = VersionsCache.getInstance().getFileRevision(file2, "BASE");
                if (file3 == null) {
                    throw new IOException("Unable to get BASE revision of " + file2);
                }
                File file4 = new File(file, file2.getName());
                Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(file4), (InputStream)new FileInputStream(file3));
                file4.deleteOnExit();
            }
        }

        public void versioningEvent(VersioningEvent versioningEvent) {
            File file;
            if (FileStatusCache.EVENT_FILE_STATUS_CHANGED == versioningEvent.getId() && (file = (File)versioningEvent.getParams()[0]).equals(this.workingCopy)) {
                this.support.firePropertyChange("contentChanged", null, null);
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (!this.support.hasListeners(null)) {
                Subversion.this.fileStatusCache.addVersioningListener(this);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            super.removePropertyChangeListener(propertyChangeListener);
            if (!this.support.hasListeners(null)) {
                Subversion.this.fileStatusCache.removeVersioningListener(this);
            }
        }
    }
}

