/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.ini4j.Ini;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.ProxySettings;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnConfigFiles {
    private static SvnConfigFiles instance;
    private Ini svnServers = null;
    private Ini config = this.copyConfigFileToIDEConfigDir("config", new ConfigIniFilePatcher());
    private static final String UNIX_CONFIG_DIR = ".subversion/";
    private static final String GROUPS_SECTION = "groups";
    private static final String GLOBAL_SECTION = "global";
    private static final String WINDOWS_USER_APPDATA;
    private static final String WINDOWS_CONFIG_DIR;
    private static final String WINDOWS_GLOBAL_CONFIG_DIR;
    private static final List<String> DEFAULT_GLOBAL_IGNORES;

    private SvnConfigFiles() {
        this.svnServers = this.loadSystemIniFile("servers");
    }

    public static SvnConfigFiles getInstance() {
        if (instance == null) {
            instance = new SvnConfigFiles();
        }
        return instance;
    }

    public void setProxy(SVNUrl sVNUrl) {
        assert (sVNUrl != null) : "can't do anything for a null host";
        if (!sVNUrl.getProtocol().startsWith("http") && !sVNUrl.getProtocol().startsWith("https")) {
            return;
        }
        String string = SvnUtils.ripUserFromHost(sVNUrl.getHost());
        ProxySettings proxySettings = new ProxySettings();
        Ini ini = new Ini();
        Ini.Section section = ini.add(GLOBAL_SECTION);
        Ini.Section section2 = (Ini.Section)this.svnServers.get((Object)GLOBAL_SECTION);
        if (proxySettings.isDirect()) {
            if (section2 != null) {
                this.mergeNonProxyKeys(section2, section);
            }
        } else {
            Object object;
            Preferences preferences;
            boolean bl;
            String string2 = "";
            int n = -1;
            if (sVNUrl.getProtocol().startsWith("https")) {
                string2 = proxySettings.getHttpsHost();
                n = proxySettings.getHttpsPort();
            }
            if (string2.equals("")) {
                string2 = proxySettings.getHttpHost();
                n = proxySettings.getHttpPort();
            }
            String string3 = proxySettings.getNotProxyHosts();
            section.put((Object)"http-proxy-host", (Object)string2);
            section.put((Object)"http-proxy-port", (Object)Integer.toString(n));
            if (!string3.equals("")) {
                section.put((Object)"http-proxy-exceptions", (Object)string3);
            }
            if (bl = (preferences = NbPreferences.root().node("org/netbeans/core")).getBoolean("useProxyAuthentication", false)) {
                object = preferences.get("proxyAuthenticationUsername", "");
                String string4 = preferences.get("proxyAuthenticationPassword", "");
                section.put((Object)"http-proxy-username", object);
                section.put((Object)"http-proxy-password", (Object)string4);
            }
            object = this.getServerGroup(string);
            if (section2 != null) {
                this.mergeNonProxyKeys(section2, section);
            }
            if (object != null) {
                this.mergeNonProxyKeys((Ini.Section)object, section);
            }
        }
        this.storeIni(ini, "servers");
    }

    private void mergeNonProxyKeys(Ini.Section section, Ini.Section section2) {
        for (String string : section.keySet()) {
            if (this.isProxyConfigurationKey(string)) continue;
            section2.put((Object)string, section.get((Object)string));
        }
    }

    public void setExternalCommand(String string, String string2) {
        Ini.Section section = this.getSection(this.config, "tunnels", true);
        section.put((Object)string, (Object)string2);
        this.storeIni(this.config, "config");
    }

    public String getExternalCommand(String string) {
        Ini.Section section = this.getSection(this.config, "tunnels", true);
        String string2 = (String)section.get((Object)string);
        return string2 != null ? string2 : "";
    }

    private Ini.Section getSection(Ini ini, String string, boolean bl) {
        Ini.Section section = (Ini.Section)ini.get((Object)string);
        if (section == null) {
            return ini.add(string);
        }
        return section;
    }

    private void storeIni(Ini ini, String string) {
        try {
            File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + "/" + string));
            file.getParentFile().mkdirs();
            ini.store((OutputStream)FileUtils.createOutputStream(file));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public List<String> getGlobalIgnores() {
        String string;
        Ini.Section section = (Ini.Section)this.config.get((Object)"miscellany");
        if (section != null && (string = (String)section.get((Object)"global-ignores")) != null && string.trim().length() > 0) {
            return SvnConfigFiles.parseGlobalIgnores(string);
        }
        return DEFAULT_GLOBAL_IGNORES;
    }

    private static List<String> parseGlobalIgnores(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        ArrayList<String> arrayList = new ArrayList<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static String getUserConfigPath() {
        if (Utilities.isUnix()) {
            String string = System.getProperty("user.home");
            return string + "/" + UNIX_CONFIG_DIR;
        }
        if (Utilities.isWindows()) {
            return WINDOWS_CONFIG_DIR;
        }
        return "";
    }

    public static String getNBConfigPath() {
        String string = System.getProperty("netbeans.user");
        return string + "/config/svn/config/";
    }

    private Ini.Section getServerGroup(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        Ini.Section section = (Ini.Section)this.svnServers.get((Object)GROUPS_SECTION);
        if (section != null) {
            for (String string2 : section.keySet()) {
                String string3 = (String)section.get((Object)string2);
                if (string3 == null || (string3 = string3.trim()) == null || !this.match(string3, string)) continue;
                return (Ini.Section)this.svnServers.get((Object)string2);
            }
        }
        return null;
    }

    private boolean match(String string, String string2) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i].trim();
            if (string.equals("*") || string.equals(string2)) {
                return true;
            }
            int n = string.indexOf("*");
            if (n <= -1 || !this.matchSegments(string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean matchSegments(String string, String string2) {
        String[] stringArray = string.split(".");
        String[] stringArray2 = string2.split(".");
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray[n].equals("*") && !stringArray[n].equals(stringArray2[i])) {
                return false;
            }
            if (stringArray[n].equals("*")) continue;
            ++n;
        }
        return false;
    }

    private Ini copyConfigFileToIDEConfigDir(String string, IniFilePatcher iniFilePatcher) {
        Ini ini = this.loadSystemIniFile(string);
        iniFilePatcher.patch(ini);
        File file = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath() + "/" + string));
        try {
            file.getParentFile().mkdirs();
            ini.store((OutputStream)FileUtils.createOutputStream(file));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return ini;
    }

    private Ini loadSystemIniFile(String string) {
        String string2 = SvnConfigFiles.getUserConfigPath() + "/" + string;
        File file = FileUtil.normalizeFile((File)new File(string2));
        Ini ini = null;
        try {
            ini = new Ini((Reader)new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            ini = new Ini();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        Ini ini2 = null;
        try {
            ini2 = new Ini((Reader)new FileReader(SvnConfigFiles.getGlobalConfigPath() + "/" + string));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        if (ini2 != null) {
            this.merge(ini2, ini);
        }
        if (ini.size() < 1) {
            ErrorManager.getDefault().log(16, "Could not load the file " + string2 + ". Falling back on svn defaults.");
        }
        return ini;
    }

    private void merge(Ini ini, Ini ini2) {
        for (String string : ini.keySet()) {
            Ini.Section section = (Ini.Section)ini.get((Object)string);
            Ini.Section section2 = (Ini.Section)ini2.get((Object)string);
            if (section2 == null) {
                section2 = ini2.add(string);
            }
            for (String string2 : section.keySet()) {
                if (section2.containsKey((Object)string2)) continue;
                section2.put((Object)string2, section.get((Object)string2));
            }
        }
    }

    private boolean isProxyConfigurationKey(String string) {
        return string.equals("http-proxy-host") || string.equals("http-proxy-port") || string.equals("http-proxy-username") || string.equals("http-proxy-password");
    }

    private static String getGlobalConfigPath() {
        if (Utilities.isUnix()) {
            return "/etc/subversion";
        }
        if (Utilities.isWindows()) {
            return WINDOWS_GLOBAL_CONFIG_DIR;
        }
        return "";
    }

    private static String getAPPDATA() {
        String string = "";
        if (Utilities.isWindows()) {
            string = System.getenv("APPDATA");
        }
        return string != null ? string : "";
    }

    private static String getGlobalAPPDATA() {
        if (Utilities.isWindows()) {
            String string;
            String string2 = System.getenv("ALLUSERSPROFILE");
            if (string2 == null || string2.trim().equals("")) {
                string2 = "";
            }
            if ((string = WINDOWS_USER_APPDATA) == null || string.equals("")) {
                return "";
            }
            String string3 = "";
            int n = string.lastIndexOf("\\");
            if (n > -1) {
                string3 = string.substring(n + 1);
                if (string3.trim().equals("")) {
                    int n2 = string.lastIndexOf("\\", n);
                    if (n > -1) {
                        string3 = string.substring(n2 + 1, n);
                    }
                }
            } else {
                return "";
            }
            return string2 + "/" + string3;
        }
        return "";
    }

    static {
        WINDOWS_USER_APPDATA = SvnConfigFiles.getAPPDATA();
        WINDOWS_CONFIG_DIR = WINDOWS_USER_APPDATA + "\\Subversion";
        WINDOWS_GLOBAL_CONFIG_DIR = SvnConfigFiles.getGlobalAPPDATA() + "\\Subversion";
        DEFAULT_GLOBAL_IGNORES = SvnConfigFiles.parseGlobalIgnores("*.o *.lo *.la #*# .*.rej *.rej .*~ *~ .#* .DS_Store");
    }

    private class ConfigIniFilePatcher
    implements IniFilePatcher {
        private ConfigIniFilePatcher() {
        }

        public void patch(Ini ini) {
            Ini.Section section = (Ini.Section)ini.get((Object)"auth");
            if (section == null) {
                section = ini.add("auth");
            }
            section.put((Object)"store-auth-creds", (Object)"no");
        }
    }

    private static interface IniFilePatcher {
        public void patch(Ini var1);
    }
}

