/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.Annotator;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.options.AnnotationSettingsPanel;
import org.netbeans.modules.subversion.options.LabelsPanel;
import org.netbeans.modules.subversion.options.SvnOptionsController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSettings
implements ActionListener,
TableModelListener {
    private final AnnotationSettingsPanel panel = new AnnotationSettingsPanel();
    private DialogDescriptor dialogDescriptor;
    private boolean valid;

    public AnnotationSettings() {
        String string = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.annotationTextField.toolTipText", (Object[])Annotator.LABELS);
        this.panel.annotationTextField.setToolTipText(string);
        this.panel.labelsButton.addActionListener(this);
        this.panel.upButton.addActionListener(this);
        this.panel.downButton.addActionListener(this);
        this.panel.newButton.addActionListener(this);
        this.panel.removeButton.addActionListener(this);
        this.panel.resetButton.addActionListener(this);
        this.panel.warningLabel.setVisible(false);
        this.getModel().addTableModelListener(this);
    }

    JPanel getPanel() {
        return this.panel;
    }

    void show() {
        String string = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageLabels");
        String string2 = NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_ManageLabels");
        HelpCtx helpCtx = new HelpCtx(AnnotationSettings.class);
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, string);
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(helpCtx);
        this.dialogDescriptor.setValid(this.valid);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(string2);
        dialog.setAlwaysOnTop(false);
        dialog.setVisible(true);
    }

    void update() {
        this.reset(SvnModuleConfig.getDefault().getAnnotationFormat(), SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    void applyChanges() {
        SvnModuleConfig.getDefault().setAnnotationFormat(this.panel.annotationTextField.getText());
        TableModel tableModel = this.panel.expresionsTable.getModel();
        ArrayList<AnnotationExpression> arrayList = new ArrayList<AnnotationExpression>(tableModel.getRowCount());
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string = (String)tableModel.getValueAt(i, 0);
            if (string.trim().equals("")) continue;
            String string2 = (String)tableModel.getValueAt(i, 1);
            arrayList.add(new AnnotationExpression(string, string2));
        }
        SvnModuleConfig.getDefault().setAnnotationExpresions(arrayList);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.labelsButton) {
            this.onLabelsClick();
        } else if (actionEvent.getSource() == this.panel.upButton) {
            this.onUpClick();
        } else if (actionEvent.getSource() == this.panel.downButton) {
            this.onDownClick();
        } else if (actionEvent.getSource() == this.panel.newButton) {
            this.onNewClick();
        } else if (actionEvent.getSource() == this.panel.removeButton) {
            this.onRemoveClick();
        } else if (actionEvent.getSource() == this.panel.resetButton) {
            this.onResetClick();
        }
    }

    private void onUpClick() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        if (n > 0) {
            DefaultTableModel defaultTableModel = this.getModel();
            int n2 = n - 1;
            defaultTableModel.moveRow(n, n, n2);
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private void onDownClick() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        DefaultTableModel defaultTableModel = this.getModel();
        if (n > -1 && n < defaultTableModel.getRowCount() - 1) {
            int n2 = n + 1;
            defaultTableModel.moveRow(n, n, n2);
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private void onNewClick() {
        int n = this.getSelectionModel().getMinSelectionIndex();
        if (n < 0) {
            this.getModel().addRow(new String[]{"", ""});
        } else {
            this.getModel().insertRow(n, new String[]{"", ""});
        }
    }

    private void onRemoveClick() {
        int n;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        if (n2 > -1) {
            this.getModel().removeRow(n2);
        }
        if ((n = this.getModel().getRowCount()) > 0) {
            if (n2 > n - 1) {
                n2 = n - 1;
            }
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    private void onResetClick() {
        this.reset(SvnModuleConfig.getDefault().getDefaultAnnotationFormat(), SvnModuleConfig.getDefault().getDefaultAnnotationExpresions());
    }

    private void reset(String string, List<AnnotationExpression> list) {
        this.panel.annotationTextField.setText(string);
        this.getSelectionModel().setSelectionMode(0);
        DefaultTableModel defaultTableModel = this.getModel();
        defaultTableModel.setColumnCount(2);
        defaultTableModel.setRowCount(list.size());
        int n = -1;
        for (AnnotationExpression annotationExpression : list) {
            defaultTableModel.setValueAt(annotationExpression.getUrlExp(), ++n, 0);
            defaultTableModel.setValueAt(annotationExpression.getAnnotationExp(), n, 1);
        }
    }

    private DefaultTableModel getModel() {
        return (DefaultTableModel)this.panel.expresionsTable.getModel();
    }

    private ListSelectionModel getSelectionModel() {
        return this.panel.expresionsTable.getSelectionModel();
    }

    private void onLabelsClick() {
        Object object;
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<Object> arrayList = new ArrayList<Object>(Annotator.LABELS.length);
        for (int i = 0; i < Annotator.LABELS.length; ++i) {
            object = new LabelVariable(Annotator.LABELS[i], "{" + Annotator.LABELS[i] + "} - " + NbBundle.getMessage(AnnotationSettings.class, (String)("AnnotationSettings.label." + Annotator.LABELS[i])));
            arrayList.add(object);
        }
        labelsPanel.labelsList.setListData(arrayList.toArray(new LabelVariable[arrayList.size()]));
        String string = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.title");
        object = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.labelVariables.acsd");
        if (this.showDialog(labelsPanel, string, (String)object)) {
            Object[] objectArray = labelsPanel.labelsList.getSelectedValues();
            String string2 = "";
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = string2 + "{" + ((LabelVariable)objectArray[i]).getVariable() + "}";
            }
            String string3 = this.panel.annotationTextField.getText();
            int n = this.panel.annotationTextField.getCaretPosition();
            if (n < 0) {
                n = string3.length();
            }
            StringBuffer stringBuffer = new StringBuffer(string3.length() + string2.length());
            stringBuffer.append(string3.substring(0, n));
            stringBuffer.append(string2);
            if (n < string3.length()) {
                stringBuffer.append(string3.substring(n, string3.length()));
            }
            this.panel.annotationTextField.setText(stringBuffer.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(n + string2.length());
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.validateTable(tableModelEvent.getFirstRow(), tableModelEvent.getColumn());
        }
    }

    private void validateTable(int n, int n2) {
        if (n < 0 || n2 != 0) {
            return;
        }
        this.valid = true;
        String string = (String)this.getModel().getValueAt(n, n2);
        try {
            Pattern.compile(string);
        }
        catch (Exception exception) {
            this.valid = false;
        }
        if (this.valid) {
            this.panel.warningLabel.setVisible(false);
        } else {
            String string2 = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.warningLabel.text", (Object)string);
            this.panel.warningLabel.setText(string2);
            this.panel.warningLabel.setVisible(true);
        }
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(this.valid);
        }
    }

    private boolean showDialog(JPanel jPanel, String string, String string2) {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, string);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(string2);
        dialog.setVisible(true);
        return DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue());
    }

    private class LabelVariable {
        private String description;
        private String variable;

        public LabelVariable(String string, String string2) {
            this.description = string2;
            this.variable = string;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

