/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.options.AnnotationSettings;
import org.netbeans.modules.subversion.options.SvnOptionsPanel;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SvnOptionsController
extends OptionsPanelController
implements ActionListener {
    private final SvnOptionsPanel panel = new SvnOptionsPanel();
    private final Repository repository;
    private final AnnotationSettings annotationSettings;

    public SvnOptionsController() {
        int n = 20;
        String string = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_Repository_Location");
        this.repository = new Repository(n, string);
        this.annotationSettings = new AnnotationSettings();
        this.panel.browseButton.addActionListener(this);
        this.panel.manageConnSettingsButton.addActionListener(this);
        this.panel.manageLabelsButton.addActionListener(this);
    }

    public void update() {
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault().getExecutableBinaryPath());
        this.annotationSettings.update();
        this.repository.refreshUrlHistory();
    }

    public void applyChanges() {
        SvnModuleConfig.getDefault().setExecutableBinaryPath(this.panel.executablePathTextField.getText());
        this.annotationSettings.applyChanges();
        Subversion.getInstance().getAnnotator().refresh();
        Subversion.getInstance().refreshAllAnnotations();
        this.repository.storeRecentUrls();
    }

    public void cancel() {
        this.repository.refreshUrlHistory();
    }

    public boolean isValid() {
        return true;
    }

    public boolean isChanged() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("netbeans.optionsDialog.advanced.subversion");
    }

    public JComponent getComponent(Lookup lookup) {
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        } else if (actionEvent.getSource() == this.panel.manageConnSettingsButton) {
            this.onManageConnClick();
        } else if (actionEvent.getSource() == this.panel.manageLabelsButton) {
            this.onManageLabelsClick();
        }
    }

    private File getExecutableFile() {
        String string = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(string));
    }

    private void onBrowseClick() {
        File file = this.getExecutableFile();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
        }
        accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(SvnOptionsController.class, (String)"SVNExec");
            }
        });
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.panel.executablePathTextField.setText(file2.getAbsolutePath());
        }
    }

    private void onManageConnClick() {
        boolean bl = this.repository.show(NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageConnections"), new HelpCtx(Repository.class));
        if (!bl) {
            this.repository.refreshUrlHistory();
        }
    }

    private void onManageLabelsClick() {
        this.annotationSettings.show();
    }
}

