/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.blame;

import java.io.File;
import java.util.Arrays;
import javax.swing.JEditorPane;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.blame.AnnotateLine;
import org.netbeans.modules.subversion.ui.blame.AnnotationBar;
import org.netbeans.modules.subversion.ui.blame.AnnotationBarManager;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BlameAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        if (this.visible(nodeArray)) {
            return "CTL_MenuItem_HideAnnotations";
        }
        return "CTL_MenuItem_ShowAnnotations";
    }

    public boolean enable(Node[] nodeArray) {
        return super.enable(nodeArray) && this.activatedEditorCookie(nodeArray) != null;
    }

    protected int getFileEnabledStatus() {
        return 4088;
    }

    protected int getDirectoryEnabledStatus() {
        return 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        if (this.visible(nodeArray)) {
            JEditorPane jEditorPane = this.activatedEditorPane(nodeArray);
            AnnotationBarManager.hideAnnotationBar(jEditorPane);
        } else {
            SVNUrl sVNUrl;
            EditorCookie editorCookie = this.activatedEditorCookie(nodeArray);
            if (editorCookie == null) {
                return;
            }
            final File file = this.activatedFile(nodeArray);
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null) {
                editorCookie.open();
            }
            if ((jEditorPaneArray = editorCookie.getOpenedPanes()) == null) {
                return;
            }
            JEditorPane jEditorPane = jEditorPaneArray[0];
            final AnnotationBar annotationBar = AnnotationBarManager.showAnnotationBar(jEditorPane);
            annotationBar.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationSubstitute"));
            try {
                sVNUrl = SvnUtils.getRepositoryRootUrl(file);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
            SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                public void perform() {
                    BlameAction.this.computeAnnotations(file, this, annotationBar);
                }
            };
            svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(BlameAction.class, (String)"MSG_Annotation_Progress"));
        }
    }

    private void computeAnnotations(File file, SvnProgressSupport svnProgressSupport, AnnotationBar annotationBar) {
        ISVNLogMessage[] iSVNLogMessageArray;
        ISVNAnnotations iSVNAnnotations;
        SvnClient svnClient;
        try {
            svnClient = Subversion.getInstance().getClient(file, svnProgressSupport);
        }
        catch (SVNClientException sVNClientException) {
            annotationBar.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        try {
            iSVNAnnotations = svnClient.annotate(file, (SVNRevision)new SVNRevision.Number(1L), SVNRevision.BASE);
        }
        catch (SVNClientException sVNClientException) {
            annotationBar.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        if (svnProgressSupport.isCanceled()) {
            annotationBar.setAnnotationMessage(NbBundle.getMessage(BlameAction.class, (String)"CTL_AnnotationFailed"));
            return;
        }
        AnnotateLine[] annotateLineArray = BlameAction.toAnnotateLines(iSVNAnnotations);
        annotationBar.annotationLines(file, Arrays.asList(annotateLineArray));
        try {
            iSVNLogMessageArray = svnClient.getLogMessages(file, (SVNRevision)new SVNRevision.Number(1L), SVNRevision.BASE, false, false);
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
            return;
        }
        if (svnProgressSupport.isCanceled()) {
            return;
        }
        BlameAction.fillCommitMessages(annotateLineArray, iSVNLogMessageArray);
    }

    private static void fillCommitMessages(AnnotateLine[] annotateLineArray, ISVNLogMessage[] iSVNLogMessageArray) {
        long l = Long.MAX_VALUE;
        for (int i = 0; i < annotateLineArray.length; ++i) {
            AnnotateLine annotateLine = annotateLineArray[i];
            for (int j = 0; j < iSVNLogMessageArray.length; ++j) {
                ISVNLogMessage iSVNLogMessage = iSVNLogMessageArray[j];
                if (iSVNLogMessage.getRevision().getNumber() < l) {
                    l = iSVNLogMessage.getRevision().getNumber();
                }
                if (!annotateLine.getRevision().equals(iSVNLogMessage.getRevision().toString())) continue;
                annotateLine.setDate(iSVNLogMessage.getDate());
                annotateLine.setCommitMessage(iSVNLogMessage.getMessage());
            }
        }
        String string = Long.toString(l);
        for (int i = 0; i < annotateLineArray.length; ++i) {
            AnnotateLine annotateLine;
            annotateLine.setCanBeRolledBack(!(annotateLine = annotateLineArray[i]).getRevision().equals(string));
        }
    }

    private static AnnotateLine[] toAnnotateLines(ISVNAnnotations iSVNAnnotations) {
        AnnotateLine[] annotateLineArray = new AnnotateLine[iSVNAnnotations.numberOfLines()];
        int n = iSVNAnnotations.numberOfLines();
        for (int i = 0; i < n; ++i) {
            annotateLineArray[i] = new AnnotateLine();
            annotateLineArray[i].setAuthor(iSVNAnnotations.getAuthor(i));
            annotateLineArray[i].setContent(iSVNAnnotations.getLine(i));
            annotateLineArray[i].setLineNum(i + 1);
            annotateLineArray[i].setRevision(Long.toString(iSVNAnnotations.getRevision(i)));
            annotateLineArray[i].setDate(iSVNAnnotations.getChanged(i));
        }
        return annotateLineArray;
    }

    public boolean visible(Node[] nodeArray) {
        JEditorPane jEditorPane = this.activatedEditorPane(nodeArray);
        return AnnotationBarManager.annotationBarVisible(jEditorPane);
    }

    private JEditorPane activatedEditorPane(Node[] nodeArray) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = this.activatedEditorCookie(nodeArray);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private EditorCookie activatedEditorCookie(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        if (nodeArray.length == 1) {
            Node node = nodeArray[0];
            return (EditorCookie)node.getCookie(EditorCookie.class);
        }
        return null;
    }

    private File activatedFile(Node[] nodeArray) {
        Node node;
        DataObject dataObject;
        if (nodeArray.length == 1 && (dataObject = (DataObject)(node = nodeArray[0]).getCookie(DataObject.class)) != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return FileUtil.toFile((FileObject)fileObject);
        }
        return null;
    }
}

