/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.browser.WaitNode;
import org.netbeans.modules.subversion.ui.search.SvnSearch;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryPathNode
extends AbstractNode {
    private RepositoryPathEntry entry;
    private final BrowserClient client;
    private boolean repositoryFolder;
    static final String PROPERTY_NAME_REVISION = "revision";
    static final String PROPERTY_NAME_DATE = "date";
    static final String PROPERTY_NAME_AUTHOR = "author";
    static final String PROPERTY_NAME_HISTORY = "history";
    private static final String HISTORY_DISPLAY_NAME = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Name");
    private static final String HISTORY_SHORT_DESC = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Short_Desc");

    static RepositoryPathNode createRepositoryPathNode(BrowserClient browserClient, RepositoryFile repositoryFile) {
        return RepositoryPathNode.createRepositoryPathNode(browserClient, new RepositoryPathEntry(repositoryFile, SVNNodeKind.DIR, new SVNRevision(0), null, ""));
    }

    static RepositoryPathNode createRepositoryPathNode(BrowserClient browserClient, RepositoryPathEntry repositoryPathEntry) {
        RepositoryPathChildren repositoryPathChildren = new RepositoryPathChildren(browserClient, repositoryPathEntry);
        RepositoryPathNode repositoryPathNode = new RepositoryPathNode((Children)repositoryPathChildren, browserClient, repositoryPathEntry, true);
        return repositoryPathNode;
    }

    static RepositoryPathNode createBrowserPathNode(BrowserClient browserClient, RepositoryPathEntry repositoryPathEntry) {
        RepositoryPathNode repositoryPathNode = new RepositoryPathNode((Children)new Children.Array(), browserClient, repositoryPathEntry, false);
        return repositoryPathNode;
    }

    private RepositoryPathNode(Children children, BrowserClient browserClient, RepositoryPathEntry repositoryPathEntry, boolean bl) {
        super(repositoryPathEntry.getSvnNodeKind() == SVNNodeKind.DIR ? children : Children.LEAF);
        this.entry = repositoryPathEntry;
        this.client = browserClient;
        this.repositoryFolder = bl;
        if (repositoryPathEntry.getSvnNodeKind() == SVNNodeKind.DIR) {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFolder.gif");
        } else {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFile.gif");
        }
        this.initProperties();
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new RevisionProperty());
        set.put((Node.Property)new DateProperty());
        set.put((Node.Property)new AuthorProperty());
        set.put((Node.Property)new HistoryProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        if (this.entry.getRepositoryFile().isRepositoryRoot()) {
            return this.entry.getRepositoryFile().getRepositoryUrl().toString();
        }
        return this.entry.getRepositoryFile().getName();
    }

    public void setName(String string) {
        String string2 = this.getName();
        if (!string2.equals(string)) {
            this.renameNode(this, string, 0);
            this.fireNameChange(string2, string);
        }
    }

    private void renameNode(RepositoryPathNode repositoryPathNode, String string, int n) {
        repositoryPathNode.entry = new RepositoryPathEntry(repositoryPathNode.entry.getRepositoryFile().replaceLastSegment(string, n), repositoryPathNode.entry.getSvnNodeKind(), repositoryPathNode.entry.getLastChangedRevision(), repositoryPathNode.entry.getLastChangedDate(), repositoryPathNode.entry.getLastChangedAuthor());
        Children children = repositoryPathNode.getChildren();
        Node[] nodeArray = children.getNodes();
        ++n;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!(nodeArray[i] instanceof RepositoryPathNode)) continue;
            this.renameNode((RepositoryPathNode)nodeArray[i], string, n);
        }
    }

    public Action[] getActions(boolean bl) {
        return this.client.getActions();
    }

    public RepositoryPathEntry getEntry() {
        return this.entry;
    }

    public BrowserClient getClient() {
        return this.client;
    }

    public boolean canRename() {
        return !this.repositoryFolder;
    }

    private void setRepositoryFolder(boolean bl) {
        this.repositoryFolder = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthorProperty
    extends NodeProperty<String> {
        public AuthorProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_AUTHOR, String.class, RepositoryPathNode.PROPERTY_NAME_AUTHOR, RepositoryPathNode.PROPERTY_NAME_AUTHOR);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return RepositoryPathNode.this.entry.getLastChangedAuthor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateProperty
    extends NodeProperty<String> {
        public DateProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_DATE, String.class, RepositoryPathNode.PROPERTY_NAME_DATE, RepositoryPathNode.PROPERTY_NAME_DATE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            Date date = RepositoryPathNode.this.entry.getLastChangedDate();
            return date != null ? DateFormat.getDateTimeInstance().format(date) : "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryProperty
    extends PropertySupport.ReadOnly<String> {
        public HistoryProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_HISTORY, String.class, HISTORY_DISPLAY_NAME, HISTORY_SHORT_DESC);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return "";
        }

        public String toString() {
            try {
                String string = this.getValue();
                return string != null ? string.toString() : "";
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return exception.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            return new HistoryPropertyEditor();
        }
    }

    private class HistoryPropertyEditor
    extends PropertyEditorSupport {
        public HistoryPropertyEditor() {
            this.setValue("");
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            SVNRevision sVNRevision = RepositoryPathNode.this.entry.getLastChangedRevision();
            SVNUrl sVNUrl = RepositoryPathNode.this.entry.getRepositoryFile().getRepositoryUrl();
            SVNUrl sVNUrl2 = RepositoryPathNode.this.entry.getRepositoryFile().getFileUrl();
            SvnSearch svnSearch = new SvnSearch(new RepositoryFile(sVNUrl, sVNUrl2, sVNRevision));
            return svnSearch.getSearchPanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected NodeProperty(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                Object object = this.getValue();
                return object != null ? object.toString() : "";
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return exception.getLocalizedMessage();
            }
        }

        public boolean canWrite() {
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport();
        }
    }

    private static class RepositoryPathChildren
    extends Children.Keys {
        private RequestProcessor.Task task;
        private final RepositoryPathEntry pathEntry;
        private final BrowserClient client;

        public RepositoryPathChildren(BrowserClient browserClient, RepositoryPathEntry repositoryPathEntry) {
            this.client = browserClient;
            this.pathEntry = repositoryPathEntry;
        }

        protected void addNotify() {
            super.addNotify();
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2001"));
            this.setKeys(Collections.singleton(waitNode));
            this.listRepositoryPath();
        }

        protected void removeNotify() {
            this.task.cancel();
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof Node) {
                return new Node[]{(Node)object};
            }
            RepositoryPathEntry repositoryPathEntry = (RepositoryPathEntry)object;
            Node node = this.findChild(repositoryPathEntry.getRepositoryFile().getName());
            if (node != null) {
                return null;
            }
            RepositoryPathNode repositoryPathNode = RepositoryPathNode.createRepositoryPathNode(this.client, repositoryPathEntry);
            return new Node[]{repositoryPathNode};
        }

        public void listRepositoryPath() {
            RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(this.pathEntry.getRepositoryFile().getRepositoryUrl());
            SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                public void perform() {
                    try {
                        List list = RepositoryPathChildren.this.client.listRepositoryPath(RepositoryPathChildren.this.pathEntry, this);
                        if (list == null) {
                            RepositoryPathChildren.this.setKeys(Collections.EMPTY_LIST);
                            RepositoryPathNode repositoryPathNode = (RepositoryPathNode)RepositoryPathChildren.this.getNode();
                            repositoryPathNode.setRepositoryFolder(false);
                        } else {
                            if (!RepositoryPathChildren.this.isCreativeBrowser(RepositoryPathChildren.this.client)) {
                                RepositoryPathChildren.this.removePreselectedFolders(list);
                            }
                            RepositoryPathChildren.this.setKeys(list);
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        RepositoryPathChildren.this.setKeys(Collections.singleton(RepositoryPathChildren.errorNode((Exception)((Object)sVNClientException))));
                        return;
                    }
                }
            };
            svnProgressSupport.start(requestProcessor, this.pathEntry.getRepositoryFile().getRepositoryUrl(), NbBundle.getMessage(Browser.class, (String)"BK2001"));
        }

        private String getLastPathSegment(RepositoryPathEntry repositoryPathEntry) {
            String[] stringArray = repositoryPathEntry.getRepositoryFile().getPathSegments();
            return stringArray.length > 0 ? stringArray[stringArray.length - 1] : null;
        }

        private static Node errorNode(Exception exception) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setDisplayName(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2002"));
            abstractNode.setShortDescription(exception.getLocalizedMessage());
            return abstractNode;
        }

        private boolean isCreativeBrowser(BrowserClient browserClient) {
            Action[] actionArray = browserClient.getActions();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!(actionArray[i] instanceof CreateFolderAction)) continue;
                return true;
            }
            return false;
        }

        private void removePreselectedFolders(Collection collection) {
            Node[] nodeArray = this.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                String string;
                if (!(nodeArray[i] instanceof RepositoryPathNode) || (string = this.getLastPathSegment(((RepositoryPathNode)nodeArray[i]).getEntry())) == null) continue;
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2 = this.getLastPathSegment((RepositoryPathEntry)iterator.next());
                    if (string2 == null || !string2.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.remove(new Node[]{nodeArray[i]});
            }
        }
    }

    static class RepositoryPathEntry {
        private final SVNNodeKind svnNodeKind;
        private final RepositoryFile file;
        private final SVNRevision revision;
        private Date date;
        private final String author;

        RepositoryPathEntry(RepositoryFile repositoryFile, SVNNodeKind sVNNodeKind, SVNRevision sVNRevision, Date date, String string) {
            this.svnNodeKind = sVNNodeKind;
            this.file = repositoryFile;
            this.revision = sVNRevision;
            this.date = date;
            this.author = string;
        }

        public SVNNodeKind getSvnNodeKind() {
            return this.svnNodeKind;
        }

        RepositoryFile getRepositoryFile() {
            return this.file;
        }

        SVNRevision getLastChangedRevision() {
            return this.revision;
        }

        Date getLastChangedDate() {
            return this.date;
        }

        String getLastChangedAuthor() {
            return this.author;
        }
    }

    private class RevisionProperty
    extends NodeProperty {
        public RevisionProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_REVISION, String.class, RepositoryPathNode.PROPERTY_NAME_REVISION, RepositoryPathNode.PROPERTY_NAME_REVISION);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return RepositoryPathNode.this.entry.getLastChangedRevision();
        }
    }
}

