/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.ui.commit.CommitPanel;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";

    @Override
    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Commit";
    }

    @Override
    protected boolean enable(Node[] nodeArray) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = fileStatusCache.listFiles(this.getContext(nodeArray), 6612);
        return fileArray.length > 0;
    }

    public static void commit(String string, final Context context) {
        Object object;
        File file;
        Object[] objectArray;
        Object object2;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = context.getFiles();
        if (fileArray.length == 0) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            object2 = SvnUtils.getCopy(fileArray[i]);
            if (object2 == null || ((String)object2).equals("")) continue;
            arrayList.add(fileArray[i]);
        }
        File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
        object2 = new ArrayList();
        for (int i = 0; i < fileArray2.length; ++i) {
            int n;
            boolean bl;
            fileArray = fileArray2[i];
            boolean bl2 = bl = i == 1;
            if (bl) {
                objectArray = fileStatusCache.listFiles(context, 6612);
                for (n = 0; n < objectArray.length; ++n) {
                    for (int j = 0; j < fileArray.length; ++j) {
                        if (!SvnUtils.isParentOrEqual(fileArray[j], objectArray[n]) || object2.contains(objectArray[n])) continue;
                        object2.add(objectArray[n]);
                    }
                }
                continue;
            }
            objectArray = SvnUtils.flatten(fileArray, 6612);
            for (n = 0; n < objectArray.length; ++n) {
                if (object2.contains(objectArray[n])) continue;
                object2.add(objectArray[n]);
            }
        }
        if (object2.size() == 0) {
            return;
        }
        final CommitPanel commitPanel = new CommitPanel();
        final CommitTable commitTable = new CommitTable(commitPanel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        commitPanel.setCommitTable(commitTable);
        ArrayList<SvnFileNode> arrayList2 = new ArrayList<SvnFileNode>(object2.size());
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            file = (File)object3.next();
            object = new SvnFileNode(file);
            arrayList2.add((SvnFileNode)object);
        }
        objectArray = arrayList2.toArray(new SvnFileNode[object2.size()]);
        commitTable.setNodes((SvnFileNode[])objectArray);
        object3 = commitTable.getComponent();
        commitPanel.filesPanel.setLayout(new BorderLayout());
        commitPanel.filesPanel.add((Component)object3, "Center");
        file = new DialogDescriptor((Object)commitPanel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)string));
        file.setModal(true);
        object = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        ((AbstractButton)object).setEnabled(false);
        file.setOptions(new Object[]{object, NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel")});
        file.setHelpCtx(new HelpCtx(CommitAction.class));
        commitPanel.addVersioningListener(new VersioningListener((JButton)object){
            final /* synthetic */ JButton val$commitButton;
            {
                this.val$commitButton = jButton;
            }

            public void versioningEvent(VersioningEvent versioningEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, this.val$commitButton);
            }
        });
        commitTable.getTableModel().addTableModelListener(new TableModelListener((JButton)object){
            final /* synthetic */ JButton val$commitButton;
            {
                this.val$commitButton = jButton;
            }

            public void tableChanged(TableModelEvent tableModelEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, this.val$commitButton);
            }
        });
        ((AbstractButton)object).setEnabled(CommitAction.containsCommitable(commitTable));
        commitPanel.putClientProperty("contentTitle", string);
        commitPanel.putClientProperty("DialogDescriptor", file);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)file);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(SvnModuleConfig.getDefault().getPreferences(), "svn.commit.dialog"));
        dialog.pack();
        dialog.setVisible(true);
        if (file.getValue() == object) {
            final Map<SvnFileNode, CommitOptions> map = commitTable.getCommitFiles();
            final String string2 = commitPanel.messageTextArea.getText();
            Utils.insert((Preferences)SvnModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)string2, (int)20);
            SVNUrl sVNUrl = null;
            try {
                sVNUrl = CommitAction.getSvnUrl(context);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            }
            RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
            SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                public void perform() {
                    CommitAction.performCommit(string2, map, context, this);
                }
            };
            svnProgressSupport.start(requestProcessor, sVNUrl, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
        }
    }

    private static boolean containsCommitable(CommitTable commitTable) {
        Map<SvnFileNode, CommitOptions> map = commitTable.getCommitFiles();
        for (CommitOptions commitOptions : map.values()) {
            if (commitOptions == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel commitPanel, CommitTable commitTable, JButton jButton) {
        String string;
        Object object;
        SvnFileNode svnFileNode2;
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitAction.class);
        Map<SvnFileNode, CommitOptions> map = commitTable.getCommitFiles();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = jButton.isEnabled();
        for (SvnFileNode svnFileNode2 : map.keySet()) {
            object = map.get(svnFileNode2);
            if (object == CommitOptions.EXCLUDE) continue;
            hashSet.add(SvnUtils.getCopy(svnFileNode2.getFile()));
            int n = svnFileNode2.getInformation().getStatus();
            if ((n & 0x6A0) == 0 && n != 64) continue;
            bl2 = false;
            string = n == 64 ? resourceBundle.getString("MSG_CommitForm_ErrorConflicts") : resourceBundle.getString("MSG_CommitForm_ErrorRemoteChanges");
            commitPanel.setErrorLabel("<html><font color=\"#002080\">" + string + "</font></html>");
            bl = true;
        }
        if (hashSet.size() > 1) {
            commitTable.setColumns(new String[]{"name", "branch", "status", "action", "path"});
        } else {
            commitTable.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String string2 = (String)commitPanel.getClientProperty("contentTitle");
        svnFileNode2 = (DialogDescriptor)commitPanel.getClientProperty("DialogDescriptor");
        if (hashSet.size() <= 1) {
            String string3;
            String string4 = string3 = hashSet.size() == 0 ? null : (String)hashSet.iterator().next();
            if (string3 == null) {
                svnFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title"), string2));
                object = "";
            } else {
                svnFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branch"), string2, string3));
                string = MessageFormat.format(resourceBundle.getString("MSG_CommitForm_InfoBranch"), string3);
                object = "<html><font color=\"#002080\">" + string + "</font></html>";
            }
        } else {
            svnFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branches"), string2));
            String string5 = resourceBundle.getString("MSG_CommitForm_ErrorMultipleBranches");
            object = "<html><font color=\"#CC0000\">" + string5 + "</font></html>";
        }
        if (!bl) {
            commitPanel.setErrorLabel((String)object);
            bl2 = true;
        }
        jButton.setEnabled(bl2 && CommitAction.containsCommitable(commitTable));
    }

    @Override
    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        CommitAction.commit(this.getContextDisplayName(nodeArray), context);
    }

    public static void performCommit(String string, Map<SvnFileNode, CommitOptions> map, Context context, SvnProgressSupport svnProgressSupport) {
        CommitAction.performCommit(string, map, context, svnProgressSupport, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void performCommit(String string, Map<SvnFileNode, CommitOptions> map, Context context, SvnProgressSupport svnProgressSupport, boolean bl) {
        try {
            Object object;
            Object object2;
            Serializable serializable;
            Object object3;
            Object object4;
            Object object5;
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(context, svnProgressSupport);
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            svnProgressSupport.setDisplayName(NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            HashSet<File> hashSet = new HashSet<File>();
            Iterator<SvnFileNode> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                object5 = iterator.next();
                object4 = map.get(object5);
                if (CommitOptions.ADD_BINARY == object4) {
                    object3 = CommitAction.listUnmanagedParents((SvnFileNode)object5);
                    serializable = object3.iterator();
                    while (serializable.hasNext()) {
                        if (svnProgressSupport.isCanceled()) {
                            return;
                        }
                        object2 = (File)serializable.next();
                        arrayList.add(new SvnFileNode((File)object2));
                        linkedHashSet.add(object2);
                    }
                    if (svnProgressSupport.isCanceled()) {
                        return;
                    }
                    hashSet.add(((SvnFileNode)object5).getFile());
                    arrayList.add(object5);
                    linkedHashSet.add(((SvnFileNode)object5).getFile());
                    continue;
                }
                if (CommitOptions.ADD_TEXT == object4 || CommitOptions.ADD_DIRECTORY == object4) {
                    object3 = CommitAction.listUnmanagedParents((SvnFileNode)object5);
                    serializable = object3.iterator();
                    while (serializable.hasNext()) {
                        if (svnProgressSupport.isCanceled()) {
                            return;
                        }
                        object2 = (File)serializable.next();
                        arrayList.add(new SvnFileNode((File)object2));
                        linkedHashSet.add(object2);
                    }
                    if (svnProgressSupport.isCanceled()) {
                        return;
                    }
                    arrayList.add(object5);
                    linkedHashSet.add(((SvnFileNode)object5).getFile());
                    continue;
                }
                if (CommitOptions.COMMIT_REMOVE == object4) {
                    arrayList2.add(object5);
                    linkedHashSet.add(((SvnFileNode)object5).getFile());
                    continue;
                }
                if (CommitOptions.COMMIT != object4) continue;
                linkedHashSet.add(((SvnFileNode)object5).getFile());
            }
            object5 = new ArrayList();
            object4 = new ArrayList();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                object3 = iterator.next();
                serializable = ((SvnFileNode)object3).getFile();
                if (((File)serializable).isDirectory()) {
                    object4.add(serializable);
                    continue;
                }
                if (!((File)serializable).isFile()) continue;
                object5.add(serializable);
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            object3 = object4.iterator();
            serializable = new ArrayList<File>();
            while (object3.hasNext()) {
                object2 = (File)object3.next();
                if (serializable.contains(object2)) continue;
                serializable.add((File)object2);
            }
            if (serializable.size() > 0) {
                svnClient.addFile(serializable.toArray(new File[serializable.size()]), false);
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            if (object5.size() > 0) {
                svnClient.addFile(object5.toArray(new File[object5.size()]), false);
            }
            object2 = Subversion.getInstance().getStatusCache();
            ArrayList<File[]> arrayList3 = new ArrayList<File[]>();
            for (File object6 : linkedHashSet) {
                if (hashSet.contains(object6)) {
                    object = svnClient.propertyGet(object6, "svn:mime-type");
                    if (object != null) {
                        String fileArray = object.getValue();
                        if (fileArray == null || fileArray.startsWith("text/")) {
                            svnClient.propertySet(object6, "svn:mime-type", "application/octet-stream", false);
                        }
                    } else {
                        svnClient.propertySet(object6, "svn:mime-type", "application/octet-stream", false);
                    }
                }
                object = null;
                for (List list : arrayList3) {
                    FileInformation fileInformation;
                    File file = (File)list.get(0);
                    File file2 = SVNBaseDir.getRootDir((File[])new File[]{object6, file});
                    if (file2 == null || ((fileInformation = ((FileStatusCache)object2).getStatus(file2)).getStatus() & 0xFFFFFFFE) == 0) continue;
                    object = list;
                    break;
                }
                if (object == null) {
                    object = new ArrayList();
                    arrayList3.add((File[])object);
                }
                object.add(object6);
            }
            for (List list : arrayList3) {
                object = list.toArray(new File[list.size()]);
                svnClient.commit((File[])object, string, false);
                if (bl) {
                    void var21_31;
                    int n;
                    File[] fileArray = context.getRootFiles();
                    boolean bl2 = false;
                    while (n < fileArray.length) {
                        svnClient.update(fileArray[n], SVNRevision.HEAD, false);
                        ++n;
                    }
                    n = 0;
                    while (var21_31 < fileArray.length) {
                        ((FileStatusCache)object2).refresh(fileArray[var21_31], FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                        ++var21_31;
                    }
                }
                for (int i = 0; i < ((File[])object).length; ++i) {
                    ((FileStatusCache)object2).refresh(object[i], FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
                if (!svnProgressSupport.isCanceled()) continue;
                return;
            }
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }

    private static List<File> listUnmanagedParents(SvnFileNode svnFileNode) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = svnFileNode.getFile();
        File file2 = file.getParentFile();
        while (!new File(file2, ".svn/entries").canRead() && !new File(file2, "_svn/entries").canRead()) {
            arrayList.add(0, file2);
            if ((file2 = file2.getParentFile()) != null) continue;
        }
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file3 : arrayList) {
            arrayList2.add(file3);
        }
        return arrayList2;
    }
}

