/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.util.Context;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class DeleteLocalAction
extends ContextAction {
    public static final int LOCALLY_DELETABLE_MASK = 4100;

    protected String getBaseName(Node[] nodeArray) {
        return "Delete";
    }

    protected int getFileEnabledStatus() {
        return 4100;
    }

    protected void performContextAction(Node[] nodeArray) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Prompt"));
        confirmation.setTitle(NbBundle.getMessage(DeleteLocalAction.class, (String)"CTL_DeleteLocal_Title"));
        confirmation.setMessageType(2);
        confirmation.setOptionType(0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object != NotifyDescriptor.YES_OPTION) {
            return;
        }
        final Context context = this.getContext(nodeArray);
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                DeleteLocalAction.performDelete(context, this);
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performDelete(Context context, SvnProgressSupport svnProgressSupport) {
        SvnClient svnClient;
        try {
            svnClient = Subversion.getInstance().getClient(context, svnProgressSupport);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        if (svnProgressSupport.isCanceled()) {
            return;
        }
        File[] fileArray = context.getFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            File file = fileArray[i];
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            FileLock fileLock = null;
            try {
                try {
                    svnClient.revert(file, false);
                }
                catch (SVNClientException sVNClientException) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                }
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, NbBundle.getMessage(DeleteLocalAction.class, (String)"BK0001", (Object)file.getAbsolutePath()));
                errorManager.notify((Throwable)iOException);
                continue;
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }
}

