/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.openide.nodes.Node;

public final class ExcludeFromCommitAction
extends ContextAction {
    public static final int UNDEFINED = -1;
    public static final int EXCLUDING = 1;
    public static final int INCLUDING = 2;

    protected boolean enable(Node[] nodeArray) {
        return this.getActionStatus(nodeArray) != -1;
    }

    protected int getFileEnabledStatus() {
        return 6612;
    }

    protected int getDirectoryEnabledStatus() {
        return 6612;
    }

    protected String getBaseName(Node[] nodeArray) {
        int n = this.getActionStatus(nodeArray);
        switch (n) {
            case -1: 
            case 1: {
                return "popup_commit_exclude";
            }
            case 2: {
                return "popup_commit_include";
            }
        }
        throw new RuntimeException("Invalid action status: " + n);
    }

    public int getActionStatus(Node[] nodeArray) {
        SvnModuleConfig svnModuleConfig = SvnModuleConfig.getDefault();
        File[] fileArray = this.getContext(nodeArray).getFiles();
        int n = -1;
        for (int i = 0; i < fileArray.length; ++i) {
            if (svnModuleConfig.isExcludedFromCommit(fileArray[i].getAbsolutePath())) {
                if (n == 1) {
                    return -1;
                }
                n = 2;
                continue;
            }
            if (n == 2) {
                return -1;
            }
            n = 1;
        }
        return n;
    }

    public void performContextAction(final Node[] nodeArray) {
        ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(this, nodeArray){

            public void perform() {
                SvnModuleConfig svnModuleConfig = SvnModuleConfig.getDefault();
                int n = ExcludeFromCommitAction.this.getActionStatus(nodeArray);
                File[] fileArray = ExcludeFromCommitAction.this.getContext(nodeArray).getFiles();
                ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
                for (File file : fileArray) {
                    arrayList.add(file.getAbsolutePath());
                }
                if (this.isCanceled()) {
                    return;
                }
                if (n == 1) {
                    svnModuleConfig.addExclusionPaths(arrayList);
                } else if (n == 2) {
                    svnModuleConfig.removeExclusionPaths(arrayList);
                }
            }
        };
        progressSupport.start(this.createRequestProcessor(nodeArray));
    }
}

