/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JTextField;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.copy.CopyDialog;
import org.netbeans.modules.subversion.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.ui.copy.SwitchToPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchTo
extends CopyDialog
implements PropertyChangeListener {
    private RepositoryPaths repositoryPaths;
    private final File root;
    private final RepositoryFile repositoryRoot;

    public SwitchTo(RepositoryFile repositoryFile, File file, boolean bl) {
        super(new SwitchToPanel(), NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_Title", (Object)file.getName()), NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_Action"));
        int n;
        String string;
        this.root = file;
        this.repositoryRoot = repositoryFile;
        SwitchToPanel switchToPanel = this.getSwitchToPanel();
        switchToPanel.warningLabel.setVisible(bl);
        this.setupUrlComboBox(switchToPanel.urlComboBox, SwitchTo.class.getName());
        this.repositoryPaths = new RepositoryPaths(repositoryFile, (JTextField)switchToPanel.urlComboBox.getEditor().getEditorComponent(), switchToPanel.browseRepositoryButton, switchToPanel.revisionTextField, switchToPanel.searchRevisionButton);
        this.repositoryPaths.addPropertyChangeListener(this);
        this.getSwitchToPanel().getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_RepositoryFile"));
        if (file.isFile()) {
            this.getSwitchToPanel().urlLabel.setText(NbBundle.getMessage(SwitchTo.class, (String)"CTL_SwitchTo_RepositoryFile"));
            string = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageSwitchFile");
            n = 7;
        } else {
            string = NbBundle.getMessage(CreateCopy.class, (String)"LBL_BrowserMessageSwitchFolder");
            n = 2;
        }
        this.repositoryPaths.setupBrowserBehavior(string, n, null);
    }

    RepositoryFile getRepositoryFile() {
        try {
            RepositoryFile[] repositoryFileArray = this.repositoryPaths.getRepositoryFiles();
            if (repositoryFileArray.length > 0) {
                return repositoryFileArray[0];
            }
            SVNRevision sVNRevision = this.repositoryPaths.getRevision();
            if (sVNRevision == null) {
                return null;
            }
            SVNUrl sVNUrl = SvnUtils.getRepositoryUrl(this.root);
            RepositoryFile repositoryFile = new RepositoryFile(this.repositoryRoot.getRepositoryUrl(), sVNUrl, sVNRevision);
            return repositoryFile;
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
        }
        return null;
    }

    private SwitchToPanel getSwitchToPanel() {
        return (SwitchToPanel)this.getPanel();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.getOKButton().setEnabled(bl);
        }
    }
}

