/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.MultiDiffView;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.tigris.subversion.svnclientadapter.SVNClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffMainPanel
extends JPanel
implements ActionListener,
VersioningListener,
DiffSetupSource {
    private Setup[] setups;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private final Context context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentDifferenceIndex;
    private int currentIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private static final RequestProcessor rp = new RequestProcessor("SVN_DIFF", 1);
    private RequestProcessor.Task refreshTask;
    private JComponent diffView;
    private SvnProgressSupport executeStatusSupport;
    private JToggleButton allToggle;
    private JButton commitButton;
    private JToolBar controlsToolbar;
    private JPanel jPanel1;
    private JToggleButton localToggle;
    private JComboBox navigationCombo;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JToggleButton remoteToggle;
    private JButton updateButton;

    public DiffMainPanel(Context context, int n, String string) {
        this.context = context;
        this.contextName = string;
        this.currentType = n;
        this.initComponents();
        this.setupComponents();
        this.refreshSetups();
        this.refreshComponents();
        this.refreshTask = rp.create((Runnable)new RefreshViewTask());
    }

    public DiffMainPanel(File file, String string, String string2) {
        this.context = null;
        this.contextName = file.getName();
        this.initComponents();
        this.setupComponents();
        this.localToggle.setVisible(false);
        this.remoteToggle.setVisible(false);
        this.allToggle.setVisible(false);
        this.navigationCombo.setVisible(false);
        this.refreshButton.setVisible(false);
        this.updateButton.setVisible(false);
        this.commitButton.setVisible(false);
        this.setups = new Setup[]{new Setup(file, string, string2)};
        this.setDiffIndex(0, 0);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
    }

    void componentClosed() {
        this.setups = null;
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
        }
    }

    void requestActive() {
        if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    public UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    private void setupComponents() {
        this.controlsToolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.controlsToolbar.setLayout(new ToolbarLayout());
        this.navigationCombo.addActionListener(this);
        this.navigationCombo.setRenderer(new ColoredComboRenderer());
        this.refreshButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.commitButton.addActionListener(this);
        this.localToggle.addActionListener(this);
        this.remoteToggle.addActionListener(this);
        this.allToggle.addActionListener(this);
        this.refreshButton.setToolTipText(NbBundle.getMessage(DiffMainPanel.class, (String)"MSG_RefreshDiff_Tooltip"));
        this.updateButton.setToolTipText(NbBundle.getMessage(DiffMainPanel.class, (String)"MSG_UpdateDiff_Tooltip", (Object)this.contextName));
        this.commitButton.setToolTipText(NbBundle.getMessage(DiffMainPanel.class, (String)"MSG_CommitDiff_Tooltip", (Object)this.contextName));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.localToggle);
        buttonGroup.add(this.remoteToggle);
        buttonGroup.add(this.allToggle);
        if (this.currentType == 0) {
            this.localToggle.setSelected(true);
        } else if (this.currentType == 1) {
            this.remoteToggle.setSelected(true);
        } else if (this.currentType == 2) {
            this.allToggle.setSelected(true);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DiffMainPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DiffMainPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private void refreshComponents() {
        DiffView diffView;
        DiffView diffView2 = diffView = this.setups != null ? this.setups[this.currentIndex].getView() : null;
        if (diffView != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || this.currentDifferenceIndex < diffView.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || this.currentDifferenceIndex > 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            Subversion.getInstance().getStatusCache().addVersioningListener(this);
        }
        JComponent jComponent = (JComponent)this.getParent();
        jComponent.getActionMap().put("jumpNext", this.nextAction);
        jComponent.getActionMap().put("jumpPrev", this.prevAction);
    }

    @Override
    public void removeNotify() {
        Subversion.getInstance().getStatusCache().removeVersioningListener(this);
        super.removeNotify();
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (versioningEvent.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(versioningEvent)) {
                return;
            }
            this.refreshTask.schedule(200);
        }
    }

    private boolean affectsView(VersioningEvent versioningEvent) {
        File file = (File)versioningEvent.getParams()[0];
        FileInformation fileInformation = (FileInformation)versioningEvent.getParams()[1];
        FileInformation fileInformation2 = (FileInformation)versioningEvent.getParams()[2];
        if (fileInformation == null ? (fileInformation2.getStatus() & this.displayStatuses) == 0 : (fileInformation.getStatus() & this.displayStatuses) + (fileInformation2.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context.contains(file);
    }

    private void setDiffIndex(int n, int n2) {
        TopComponent topComponent;
        this.currentIndex = n;
        DiffView diffView = this.setups[this.currentIndex].getView();
        final TopComponent topComponent2 = (TopComponent)this.getClientProperty(TopComponent.class);
        if (topComponent2 != null) {
            Node node = Node.EMPTY;
            File file = this.setups[this.currentIndex].getBaseFile();
            if (file != null && (topComponent = FileUtil.toFileObject((File)file)) != null) {
                node = new AbstractNode(Children.LEAF, Lookups.singleton((Object)topComponent));
            }
            topComponent = new TopComponent[]{node};
            EventQueue.invokeLater(new Runnable((Node[])topComponent){
                final /* synthetic */ Node[] val$nodes;
                {
                    this.val$nodes = nodeArray;
                }

                public void run() {
                    topComponent2.setActivatedNodes(this.val$nodes);
                }
            });
        }
        boolean bl = false;
        boolean bl2 = false;
        this.removeDiffComponent();
        if (diffView != null) {
            if (n2 == -1) {
                n2 = diffView.getDifferenceCount() - 1;
            }
            if (n2 >= 0 && n2 < diffView.getDifferenceCount()) {
                bl2 = true;
            }
            this.diffView = (JComponent)diffView.getComponent();
            this.diffView.getActionMap().put("jumpNext", this.nextAction);
            this.diffView.getActionMap().put("jumpPrev", this.prevAction);
            topComponent = WindowManager.getDefault().getRegistry().getActivated();
            if (SwingUtilities.isDescendingFrom(this, (Component)topComponent)) {
                bl = true;
            }
        } else {
            this.diffView = new SourcesUnavailableComponent(NbBundle.getMessage(DiffMainPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        this.add(this.diffView);
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.currentDifferenceIndex = n2;
        if (this.navigationCombo.isVisible()) {
            this.navigationCombo.setSelectedIndex(this.currentIndex);
        }
        this.refreshComponents();
        this.revalidate();
        this.repaint();
        if (bl) {
            this.diffView.requestFocusInWindow();
        }
        if (bl2) {
            final int n3 = n2;
            final DiffView diffView2 = diffView;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    diffView2.setCurrentDifference(n3);
                }
            });
        }
    }

    private void removeDiffComponent() {
        if (this.diffView != null) {
            this.remove(this.diffView);
            this.diffView = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.navigationCombo) {
            this.onNavigationCombo();
        } else if (object == this.refreshButton) {
            this.onRefreshButton();
        } else if (object == this.updateButton) {
            this.onUpdateButton();
        } else if (object == this.commitButton) {
            this.onCommitButton();
        } else if (object == this.localToggle || object == this.remoteToggle || object == this.allToggle) {
            this.onDiffTypeChanged();
        }
    }

    private void onRefreshButton() {
        if (this.context == null || this.context.getRoots().size() == 0) {
            return;
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
            this.executeStatusSupport = null;
        }
        LifecycleManager.getDefault().saveAll();
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor();
        this.executeStatusSupport = new SvnProgressSupport(){

            public void perform() {
                StatusAction.executeStatus(DiffMainPanel.this.context, this);
            }
        };
        this.refreshSetups();
    }

    private void onUpdateButton() {
        UpdateAction.performUpdate(this.context);
    }

    private void onCommitButton() {
        CommitAction.commit(this.contextName, this.context);
    }

    private void onNextButton() {
        DiffView diffView;
        if (this.navigationCombo.isVisible()) {
            this.currentIndex = this.navigationCombo.getSelectedIndex();
        }
        if ((diffView = this.setups[this.currentIndex].getView()) != null) {
            int n = diffView.getCurrentDifference();
            if (n < diffView.getDifferenceCount() - 1) {
                this.currentDifferenceIndex = Math.max(this.currentDifferenceIndex, n);
            }
            if (++this.currentDifferenceIndex >= diffView.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0);
                }
            } else {
                diffView.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffView diffView = this.setups[this.currentIndex].getView();
        if (diffView != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1);
                }
            } else {
                diffView.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1);
        }
        this.refreshComponents();
    }

    private void onNavigationCombo() {
        int n = this.navigationCombo.getSelectedIndex();
        if (n != this.currentIndex) {
            this.setDiffIndex(n, 0);
        }
    }

    @Override
    public Collection getSetups() {
        if (this.setups == null) {
            return Collections.EMPTY_SET;
        }
        return Arrays.asList(this.setups);
    }

    @Override
    public String getSetupDisplayName() {
        return this.contextName;
    }

    private void refreshSetups() {
        Serializable serializable;
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                this.displayStatuses = 6612;
                break;
            }
            case 1: {
                this.displayStatuses = 1696;
                break;
            }
            case 2: {
                this.displayStatuses = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        File[] fileArray = SvnUtils.getModifiedFiles(this.context, this.displayStatuses);
        Setup[] setupArray = new Setup[fileArray.length];
        for (int i = 0; i < setupArray.length; ++i) {
            serializable = fileArray[i];
            setupArray[i] = new Setup((File)serializable, this.currentType);
        }
        Arrays.sort(setupArray, new SetupsComparator());
        this.setups = setupArray;
        this.navigationCombo.setModel(new DefaultComboBoxModel<Setup>(this.setups));
        if (this.setups.length == 0) {
            String string;
            switch (this.currentType) {
                case 0: {
                    string = NbBundle.getMessage(DiffMainPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                    break;
                }
                case 1: {
                    string = NbBundle.getMessage(DiffMainPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                    break;
                }
                case 2: {
                    string = NbBundle.getMessage(DiffMainPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
                }
            }
            this.setups = null;
            this.navigationCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{string}));
            this.navigationCombo.setEnabled(false);
            this.navigationCombo.setPreferredSize(null);
            serializable = this.navigationCombo.getPreferredSize();
            this.navigationCombo.setPreferredSize(new Dimension(((Dimension)serializable).width + 1, ((Dimension)serializable).height));
            this.removeDiffComponent();
            this.diffView = new SourcesUnavailableComponent(string);
            this.add(this.diffView);
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.revalidate();
            this.repaint();
        } else {
            this.navigationCombo.setEnabled(true);
            this.navigationCombo.setPreferredSize(null);
            Dimension dimension = this.navigationCombo.getPreferredSize();
            this.navigationCombo.setPreferredSize(new Dimension(dimension.width + 1, dimension.height));
            this.setDiffIndex(0, 0);
            this.dpt = new DiffPrepareTask(this.setups);
            this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
        }
    }

    private void onDiffTypeChanged() {
        if (this.localToggle.isSelected()) {
            if (this.currentType == 0) {
                return;
            }
            this.currentType = 0;
        } else if (this.remoteToggle.isSelected()) {
            if (this.currentType == 1) {
                return;
            }
            this.currentType = 1;
        } else if (this.allToggle.isSelected()) {
            if (this.currentType == 2) {
                return;
            }
            this.currentType = 2;
        }
        this.refreshSetups();
    }

    private void initComponents() {
        this.controlsToolbar = new JToolBar();
        this.allToggle = new JToggleButton();
        this.localToggle = new JToggleButton();
        this.remoteToggle = new JToggleButton();
        this.navigationCombo = new JComboBox();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel1 = new JPanel();
        this.refreshButton = new JButton();
        this.updateButton = new JButton();
        this.commitButton = new JButton();
        this.setLayout(new BorderLayout());
        this.controlsToolbar.setFloatable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.allToggle, (String)NbBundle.getBundle(DiffMainPanel.class).getString("CTL_DiffPanel_All"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/diff/Bundle");
        this.allToggle.setToolTipText(resourceBundle.getString("CTL_DiffPanel_All_Tooltip"));
        this.controlsToolbar.add(this.allToggle);
        Mnemonics.setLocalizedText((AbstractButton)this.localToggle, (String)NbBundle.getBundle(DiffMainPanel.class).getString("CTL_DiffPanel_Local"));
        this.localToggle.setToolTipText(resourceBundle.getString("CTL_DiffPanel_Local_Tooltip"));
        this.controlsToolbar.add(this.localToggle);
        Mnemonics.setLocalizedText((AbstractButton)this.remoteToggle, (String)resourceBundle.getString("CTL_DiffPanel_Remote"));
        this.remoteToggle.setToolTipText(resourceBundle.getString("CTL_DiffPanel_Remote_Tooltip"));
        this.controlsToolbar.add(this.remoteToggle);
        this.controlsToolbar.add(this.navigationCombo);
        this.navigationCombo.getAccessibleContext().setAccessibleName("Navigation list");
        this.navigationCombo.getAccessibleContext().setAccessibleDescription("Navigation list");
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(resourceBundle.getString("CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setEnabled(false);
        this.controlsToolbar.add(this.nextButton);
        this.nextButton.getAccessibleContext().setAccessibleName("Go to next");
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(resourceBundle.getString("CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setEnabled(false);
        this.controlsToolbar.add(this.prevButton);
        this.prevButton.getAccessibleContext().setAccessibleName("Go to previous");
        this.jPanel1.setMaximumSize(new Dimension(15, 1));
        this.jPanel1.setPreferredSize(new Dimension(15, 1));
        this.controlsToolbar.add(this.jPanel1);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(resourceBundle.getString("MSG_RefreshDiff_Tooltip"));
        this.controlsToolbar.add(this.refreshButton);
        this.refreshButton.getAccessibleContext().setAccessibleName("Refresh");
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/update.png")));
        this.updateButton.setToolTipText(resourceBundle.getString("CTL_DiffPanel_Update_Tooltip"));
        this.controlsToolbar.add(this.updateButton);
        this.updateButton.getAccessibleContext().setAccessibleName("Update All");
        this.updateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DiffMainPanel.class).getString("CTL_Diff_DiffAll"));
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/commit.png")));
        this.commitButton.setToolTipText(resourceBundle.getString("CTL_DiffPanel_Commit_Tooltip"));
        this.controlsToolbar.add(this.commitButton);
        this.commitButton.getAccessibleContext().setAccessibleName("Commit All");
        this.commitButton.getAccessibleContext().setAccessibleDescription("Commit All Chnages");
        this.add((Component)this.controlsToolbar, "North");
    }

    private List<DiffView> propertyDiffViews(Setup setup) {
        Diff diff = Diff.getDefault();
        List<DiffView> list = DiffMainPanel.getEmptyList();
        if (this.currentType == 0 || this.currentType == 2) {
            DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
            try {
                File file = setup.getBaseFile();
                PropertiesClient propertiesClient = new PropertiesClient(file);
                Map<String, byte[]> map = propertiesClient.getBaseProperties();
                Map<String, byte[]> map2 = propertiesClient.getProperties();
                TreeSet<String> treeSet = new TreeSet<String>(map2.keySet());
                treeSet.addAll(map.keySet());
                list = new ArrayList<DiffView>(treeSet.size());
                for (String string : treeSet) {
                    StreamSource streamSource;
                    StreamSource streamSource2;
                    Object object;
                    Object object2;
                    boolean bl = map.containsKey(string);
                    boolean bl2 = map2.containsKey(string);
                    if (bl && bl2) {
                        object2 = new Property(map.get(string));
                        object = new Property(map2.get(string));
                        streamSource2 = diffProvider.computeDiff(((Property)object2).toReader(), ((Property)object).toReader());
                        if (diff == null || ((StreamSource)streamSource2).length == 0) continue;
                        streamSource = StreamSource.createSource((String)string, (String)NbBundle.getMessage(DiffMainPanel.class, (String)"LBL_Diff_PropertyBase", (Object)string), (String)((Property)object2).getMIME(), (Reader)((Property)object2).toReader());
                        StreamSource streamSource3 = StreamSource.createSource((String)string, (String)NbBundle.getMessage(DiffMainPanel.class, (String)"LBL_Diff_PropertyLocallyModified", (Object)string), (String)((Property)object).getMIME(), (Reader)((Property)object).toReader());
                        list.add(diff.createDiff(streamSource, streamSource3));
                        continue;
                    }
                    if (bl) {
                        object2 = new Property(map.get(string));
                        object = new StringReader("");
                        streamSource2 = StreamSource.createSource((String)string, (String)NbBundle.getMessage(DiffMainPanel.class, (String)"LBL_Diff_PropertyBase", (Object)string), (String)((Property)object2).getMIME(), (Reader)((Property)object2).toReader());
                        streamSource = StreamSource.createSource((String)string, (String)NbBundle.getMessage(DiffMainPanel.class, (String)"LBL_Diff_PropertyLocallyDeleted", (Object)string), (String)"text/plain", (Reader)object);
                        list.add(diff.createDiff(streamSource2, streamSource));
                        continue;
                    }
                    object2 = new StringReader("");
                    object = new Property(map2.get(string));
                    streamSource2 = StreamSource.createSource((String)string, (String)NbBundle.getMessage(DiffMainPanel.class, (String)"LBL_Diff_Property", (Object)string), (String)"text/plain", (Reader)object2);
                    streamSource = StreamSource.createSource((String)string, (String)NbBundle.getMessage(DiffMainPanel.class, (String)"LBL_Diff_PropertyLocallyNew", (Object)string), (String)((Property)object).getMIME(), (Reader)((Property)object).toReader());
                    list.add(diff.createDiff(streamSource2, streamSource));
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        } else {
            ErrorManager.getDefault().log("subversion.DiffMainPanel does not support remote property retrievals");
        }
        return list;
    }

    private static final List<DiffView> getEmptyList() {
        return Collections.emptyList();
    }

    private static class ColoredComboRenderer
    extends BasicComboBoxRenderer {
        private ColoredComboRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                object = ((Setup)object).getBaseFile().getName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private class DiffPrepareTask
    implements Runnable {
        private final Setup[] prepareSetups;

        public DiffPrepareTask(Setup[] setupArray) {
            this.prepareSetups = setupArray;
        }

        public void run() {
            Diff diff = Diff.getDefault();
            for (int i = 0; i < this.prepareSetups.length; ++i) {
                if (this.prepareSetups != DiffMainPanel.this.setups) {
                    return;
                }
                final int n = i;
                try {
                    this.prepareSetups[i].initSources();
                    StreamSource streamSource = this.prepareSetups[n].getFirstSource();
                    StreamSource streamSource2 = this.prepareSetups[n].getSecondSource();
                    DiffView diffView = diff.createDiff(streamSource, streamSource2);
                    List list = DiffMainPanel.this.propertyDiffViews(this.prepareSetups[n]);
                    DiffView[] diffViewArray = new DiffView[list.size() + 1];
                    diffViewArray[0] = diffView;
                    for (int j = 0; j < list.size(); ++j) {
                        diffViewArray[j + 1] = (DiffView)list.get(j);
                    }
                    final DiffView diffView2 = diffView = new MultiDiffView(diffViewArray, DiffMainPanel.this);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DiffPrepareTask.this.prepareSetups[n].setView(diffView2);
                            if (DiffPrepareTask.this.prepareSetups != DiffMainPanel.this.setups) {
                                return;
                            }
                            if (DiffMainPanel.this.currentIndex == n) {
                                DiffMainPanel.this.setDiffIndex(n, 0);
                            }
                        }
                    });
                    continue;
                }
                catch (IOException iOException) {
                    if (iOException.getCause() instanceof SVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)((SVNClientException)iOException.getCause())), true, true);
                        continue;
                    }
                    if (iOException.getCause() != null && iOException.getCause().getCause() instanceof SVNClientException) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)((SVNClientException)iOException.getCause().getCause())), true, true);
                        continue;
                    }
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
    }

    static class Property {
        final byte[] value;

        Property(Object object) {
            this.value = (byte[])object;
        }

        String getMIME() {
            return "text/plain";
        }

        Reader toReader() {
            if (SvnUtils.isBinary(this.value)) {
                return new StringReader(NbBundle.getMessage(DiffMainPanel.class, (String)"LBL_Diff_NoBinaryDiff"));
            }
            try {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.value), "utf8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorManager.getDefault().notify((Throwable)unsupportedEncodingException);
                return new StringReader("[ERROR: " + unsupportedEncodingException.getLocalizedMessage() + "]");
            }
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffMainPanel.this.refreshSetups();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetupsComparator
    implements Comparator<Setup> {
        private SvnUtils.ByImportanceComparator delegate = new SvnUtils.ByImportanceComparator();
        private FileStatusCache cache = Subversion.getInstance().getStatusCache();

        @Override
        public int compare(Setup setup, Setup setup2) {
            int n = this.delegate.compare(this.cache.getStatus(setup.getBaseFile()), this.cache.getStatus(setup2.getBaseFile()));
            if (n == 0) {
                return setup.getBaseFile().getName().compareToIgnoreCase(setup2.getBaseFile().getName());
            }
            return n;
        }
    }

    private static class SourcesUnavailableComponent
    extends JComponent {
        public SourcesUnavailableComponent(String string) {
            JLabel jLabel = new JLabel(string);
            this.setLayout(new BorderLayout());
            jLabel.setHorizontalAlignment(0);
            this.add((Component)jLabel, "Center");
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 10;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set<JComponent> adjusted = new HashSet<JComponent>();

        private ToolbarLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Rectangle[] rectangleArray = this.layout(container);
            for (int i = 0; i < rectangleArray.length; ++i) {
                JComponent jComponent = (JComponent)container.getComponent(i);
                if (!jComponent.isVisible()) continue;
                jComponent.setBounds(rectangleArray[i]);
            }
        }

        private Rectangle[] layout(Container container) {
            Dimension dimension = DiffMainPanel.this.getSize();
            Dimension dimension2 = container.getSize();
            int n = 0;
            int n2 = 0;
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            int n3 = container.getComponentCount();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle = new Rectangle();
                JComponent jComponent = (JComponent)container.getComponent(i);
                if (jComponent.isVisible()) {
                    rectangle.setLocation(n4, n);
                    if (jComponent instanceof AbstractButton) {
                        this.adjustToobarButton((AbstractButton)jComponent);
                    } else {
                        this.adjustToolbarComponentSize(jComponent);
                    }
                    Dimension dimension3 = jComponent.getPreferredSize();
                    int n5 = dimension3.width;
                    if (jComponent instanceof JSeparator && dimension.height - dimension.width <= 0) {
                        n5 = Math.max(n5, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                    }
                    int n6 = this.getToolbarHeight(dimension) - 1;
                    n2 = Math.max(n2, n6);
                    rectangle.setSize(n5, n6);
                    if ((n4 += n5) > dimension2.width) {
                        n += n2 + 2;
                        n4 = 0;
                        n2 = 0;
                    }
                }
                arrayList.add(rectangle);
            }
            return arrayList.toArray(new Rectangle[arrayList.size()]);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = DiffMainPanel.this.getSize();
            int n = this.getToolbarHeight(dimension);
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                if (component instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)component);
                } else {
                    this.adjustToolbarComponentSize((JComponent)component);
                }
                Dimension dimension2 = component.getPreferredSize();
                int n4 = dimension2.width;
                if (component instanceof JSeparator && dimension.height - dimension.width <= 0) {
                    n4 = Math.max(n4, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                n3 += n4;
            }
            return new Dimension(n3, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            Rectangle[] rectangleArray = this.layout(container);
            Rectangle rectangle = new Rectangle();
            for (int i = 0; i < rectangleArray.length; ++i) {
                rectangle.add(rectangleArray[i]);
            }
            return new Dimension(rectangle.width, rectangle.height);
        }

        private int getToolbarHeight(Dimension dimension) {
            if (this.parentSize == null || !this.parentSize.equals(dimension)) {
                this.parentSize = dimension;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 10);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
                int n = 0;
                String[] stringArray = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < stringArray.length; ++i) {
                    Font font = uIDefaults.getFont(stringArray[i]);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                    n = Math.max(n, fontMetrics.getHeight());
                }
                this.toolbarHeight = n + this.TOOLBAR_HEIGHT_ADJUSTMENT;
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(final AbstractButton abstractButton) {
            if (this.adjusted.contains(abstractButton)) {
                return;
            }
            if (!(abstractButton instanceof JToggleButton)) {
                abstractButton.setContentAreaFilled(false);
                abstractButton.setMargin(new Insets(0, 3, 0, 3));
                abstractButton.setBorderPainted(false);
                abstractButton.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent mouseEvent) {
                        abstractButton.setContentAreaFilled(true);
                        abstractButton.setBorderPainted(true);
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        abstractButton.setContentAreaFilled(false);
                        abstractButton.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(abstractButton);
        }

        private void adjustToolbarComponentSize(JComponent jComponent) {
            if (this.adjusted.contains(jComponent)) {
                return;
            }
            if (jComponent.getBorder() instanceof CompoundBorder) {
                Dimension dimension = jComponent.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    dimension.width += 9;
                }
                jComponent.setPreferredSize(dimension);
            }
            this.adjusted.add(jComponent);
        }
    }
}

