/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffVisualizer;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ExportDiffAction
extends ContextAction {
    private static final int enabledForStatus = 6548;

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_ExportDiff";
    }

    public String getName() {
        String string;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent instanceof DiffSetupSource && (string = ((DiffSetupSource)topComponent).getSetupDisplayName()) != null) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(this.getBaseName(this.getActivatedNodes()) + "_Context"), (Object)string);
        }
        return super.getName();
    }

    public boolean enable(Node[] nodeArray) {
        Context context = SvnUtils.getCurrentContext(nodeArray);
        File[] fileArray = ExportDiffAction.getModifiedFiles(context, 6548);
        if (fileArray.length < 1) {
            return false;
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent instanceof DiffSetupSource) {
            return true;
        }
        return super.enable(nodeArray) && Lookup.getDefault().lookup(DiffProvider.class) != null;
    }

    protected void performContextAction(Node[] nodeArray) {
        Object object;
        Object[] objectArray;
        Context context;
        boolean bl;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent instanceof DiffSetupSource) {
            bl = ((DiffSetupSource)topComponent).getSetups().isEmpty();
        } else {
            context = this.getContext(nodeArray);
            objectArray = SvnUtils.getModifiedFiles(context, 6612);
            boolean bl2 = bl = objectArray.length == 0;
        }
        if (bl) {
            context = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3001"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)context);
            return;
        }
        context = new AccessibleJFileChooser(NbBundle.getMessage(ExportDiffAction.class, (String)"ACSD_Export"));
        ((JFileChooser)((Object)context)).setDialogTitle(NbBundle.getMessage(ExportDiffAction.class, (String)"CTL_Export_Title"));
        ((JFileChooser)((Object)context)).setMultiSelectionEnabled(false);
        objectArray = ((JFileChooser)((Object)context)).getChoosableFileFilters();
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            ((JFileChooser)((Object)context)).removeChoosableFileFilter((FileFilter)object);
        }
        ((JFileChooser)((Object)context)).setCurrentDirectory(new File(SvnModuleConfig.getDefault().getPreferences().get("ExportDiff.saveFolder", System.getProperty("user.home"))));
        ((JFileChooser)((Object)context)).addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith("diff") || file.getName().endsWith("patch") || file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(ExportDiffAction.class, (String)"BK3002");
            }
        });
        ((JFileChooser)((Object)context)).setDialogType(1);
        ((JFileChooser)((Object)context)).setApproveButtonMnemonic(NbBundle.getMessage(ExportDiffAction.class, (String)"MNE_Export_ExportAction").charAt(0));
        ((JFileChooser)((Object)context)).setApproveButtonText(NbBundle.getMessage(ExportDiffAction.class, (String)"CTL_Export_ExportAction"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)context, NbBundle.getMessage(ExportDiffAction.class, (String)"CTL_Export_Title"));
        dialogDescriptor.setOptions(new Object[0]);
        object = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        ((JFileChooser)((Object)context)).addActionListener(new ActionListener((JFileChooser)((Object)context), nodeArray, (Dialog)object){
            final /* synthetic */ JFileChooser val$chooser;
            final /* synthetic */ Node[] val$nodes;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$chooser = jFileChooser;
                this.val$nodes = nodeArray;
                this.val$dialog = dialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("ApproveSelection")) {
                    File file;
                    File file2 = this.val$chooser.getSelectedFile();
                    String string2 = file2.getName();
                    boolean bl = false;
                    bl |= string2.endsWith(".diff");
                    bl |= string2.endsWith(".dif");
                    if (!(bl |= string2.endsWith(".patch"))) {
                        file = file2.getParentFile();
                        file2 = new File(file, string2 + ".patch");
                    }
                    if (file2.exists()) {
                        file = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3005", (Object)file2.getAbsolutePath()));
                        file.setOptionType(0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)file);
                        if (!file.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                            return;
                        }
                    }
                    SvnModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", file2.getParent());
                    file = file2;
                    RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor();
                    SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                        protected void perform() {
                            ExportDiffAction.this.async(this, val$nodes, file);
                        }
                    };
                    svnProgressSupport.start(requestProcessor, null, ExportDiffAction.this.getRunningName(this.val$nodes));
                }
                this.val$dialog.dispose();
            }
        });
        ((Dialog)object).setVisible(true);
    }

    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async(SvnProgressSupport svnProgressSupport, Node[] nodeArray, File file) {
        boolean bl = false;
        OutputStream outputStream = null;
        int n = 0;
        try {
            Object object;
            Object object2;
            Object object3;
            File file2;
            Object object4;
            ArrayList<Setup> arrayList;
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (topComponent instanceof DiffSetupSource) {
                arrayList = ((DiffSetupSource)topComponent).getSetups();
                object4 = new ArrayList(arrayList.size());
                for (Setup setup : arrayList) {
                    object4.add(setup.getBaseFile());
                }
                file2 = ExportDiffAction.getCommonParent(object4.toArray(new File[object4.size()]));
            } else {
                object4 = this.getContext(nodeArray);
                object3 = SvnUtils.getModifiedFiles((Context)object4, 6612);
                file2 = ExportDiffAction.getCommonParent(((Context)object4).getRootFiles());
                arrayList = new ArrayList<Setup>(((Object)object3).length);
                for (int i = 0; i < ((Object)object3).length; ++i) {
                    object2 = object3[i];
                    object = new Setup((File)object2, 0);
                    arrayList.add((Setup)object);
                }
            }
            if (file2 == null) {
                object4 = new NotifyDescriptor((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_BadSelection_Prompt"), NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_BadSelection_Title"), -1, 0, null, null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)object4);
                return;
            }
            object4 = System.getProperty("line.separator");
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            outputStream.write(("# This patch file was generated by NetBeans IDE" + (String)object4).getBytes("utf8"));
            outputStream.write(("# Following Index: paths are relative to: " + file2.getAbsolutePath() + (String)object4).getBytes("utf8"));
            outputStream.write(("# This patch can be applied using context Tools: Patch action on respective folder." + (String)object4).getBytes("utf8"));
            outputStream.write(("# It uses platform neutral UTF-8 encoding and \\n newlines." + (String)object4).getBytes("utf8"));
            outputStream.write(("# Above lines and this line are ignored by the patching process." + (String)object4).getBytes("utf8"));
            object3 = arrayList.iterator();
            int n2 = 0;
            while (object3.hasNext()) {
                object2 = (Setup)object3.next();
                object = ((Setup)object2).getBaseFile();
                try {
                    svnProgressSupport.setRepositoryRoot(SvnUtils.getRepositoryRootUrl((File)object));
                }
                catch (SVNClientException sVNClientException) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                    if (outputStream != null) {
                        try {
                            outputStream.flush();
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (bl) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportDiffAction.class, (String)"BK3004", (Object)new Integer(n)));
                        if (n == 0) {
                            file.delete();
                        }
                    } else {
                        file.delete();
                    }
                    return;
                }
                svnProgressSupport.setDisplayName(((File)object).getName());
                String string = "Index: ";
                String string2 = file2.getAbsolutePath();
                String string3 = ((File)object).getAbsolutePath();
                if (string3.startsWith(string2)) {
                    string = string + string3.substring(string2.length() + 1).replace(File.separatorChar, '/') + (String)object4;
                    outputStream.write(string.getBytes("utf8"));
                }
                this.exportDiff((Setup)object2, outputStream);
                ++n2;
            }
            n = n2;
            bl = true;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(ExportDiffAction.class, (String)"BK3003"));
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            ErrorManager.getDefault().notify(256, (Throwable)iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bl) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportDiffAction.class, (String)"BK3004", (Object)new Integer(n)));
                if (n == 0) {
                    file.delete();
                }
            } else {
                file.delete();
            }
        }
    }

    private static File getCommonParent(File[] fileArray) {
        File file = fileArray[0];
        if (file.isFile()) {
            file = file.getParentFile();
        }
        for (int i = 1; i < fileArray.length; ++i) {
            if ((file = Utils.getCommonParent((File)file, (File)fileArray[i])) != null) continue;
            return null;
        }
        return file;
    }

    private void exportDiff(Setup setup, OutputStream outputStream) throws IOException {
        int n;
        Reader reader;
        setup.initSources();
        DiffProvider diffProvider = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        Reader reader2 = setup.getFirstSource().createReader();
        if (reader2 == null) {
            reader2 = new StringReader("");
        }
        if ((reader = setup.getSecondSource().createReader()) == null) {
            reader = new StringReader("");
        }
        Difference[] differenceArray = diffProvider.computeDiff(reader2, reader);
        File file = setup.getBaseFile();
        String string = file.getAbsolutePath();
        reader2 = setup.getFirstSource().createReader();
        if (reader2 == null) {
            reader2 = new StringReader("");
        }
        if ((reader = setup.getSecondSource().createReader()) == null) {
            reader = new StringReader("");
        }
        TextDiffVisualizer.TextDiffInfo textDiffInfo = new TextDiffVisualizer.TextDiffInfo(string + " " + setup.getFirstSource().getTitle(), string + " " + setup.getSecondSource().getTitle(), null, null, reader2, reader, differenceArray);
        textDiffInfo.setContextMode(true, 3);
        InputStream inputStream = TextDiffVisualizer.differenceToContextDiffText((TextDiffVisualizer.TextDiffInfo)textDiffInfo);
        while ((n = inputStream.read()) != -1) {
            outputStream.write(n);
        }
    }

    public static File[] getModifiedFiles(Context context, int n) {
        File[] fileArray;
        File[] fileArray2 = Subversion.getInstance().getStatusCache().listFiles(context, n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < fileArray2.length; ++i) {
            fileArray = fileArray2[i];
            arrayList.add(fileArray);
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.isFile() || (fileStatusCache.getStatus(file).getStatus() & n) == 0 || arrayList.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

