/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.diff.DiffView;
import org.netbeans.modules.diff.NestableDiffView;
import org.netbeans.modules.subversion.ui.diff.VerticalFlowLayout;
import org.openide.awt.UndoRedo;
import org.openide.util.NbBundle;

public class MultiDiffView
implements DiffView,
PropertyChangeListener {
    private final DiffView[] views;
    private final NestableDiffView[] nestableViews;
    private int currentDifference;
    private PropertyChangeSupport support;
    private final Component parent;
    private final JScrollBar roller = new JScrollBar(0);
    private int innerViewsWidth;
    private MultiDiffViewPanel panel;
    final int SUMMARY_WIDTH = 12;
    final int SCROLLBAR_TOP = 12;
    final int SCROLLBAR_DOWN = 12;

    public MultiDiffView(DiffView[] diffViewArray, Component component) {
        this.views = diffViewArray;
        this.nestableViews = new NestableDiffView[diffViewArray.length];
        for (int i = 0; i < diffViewArray.length; ++i) {
            diffViewArray[i].addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.parent = component;
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.panel = new MultiDiffViewPanel();
        }
        return this.panel;
    }

    public int getDifferenceCount() {
        int n = 0;
        for (int i = 0; i < this.views.length; ++i) {
            n += this.views[i].getDifferenceCount();
        }
        return n;
    }

    public boolean canSetCurrentDifference() {
        boolean bl = true;
        for (int i = 0; i < this.views.length; ++i) {
            bl &= this.views[i].canSetCurrentDifference();
        }
        return bl;
    }

    public void setCurrentDifference(int n) throws UnsupportedOperationException {
        int n2 = 0;
        for (int i = 0; i < this.views.length; ++i) {
            if ((n -= this.views[i].getDifferenceCount()) < 0) {
                int n3 = n + this.views[i].getDifferenceCount();
                this.views[i].setCurrentDifference(n3);
                if (this.nestableViews[i] != null) {
                    this.panel.setViewPosition(new Point(0, n2 += this.nestableViews[i].getChangeY(n3)));
                }
                for (int j = 0; j < this.views.length; ++j) {
                    if (i == j) continue;
                    this.views[j].setCurrentDifference(-1);
                }
                this.currentDifference = n;
                return;
            }
            n2 += this.views[i].getComponent().getHeight();
        }
    }

    public int getCurrentDifference() throws UnsupportedOperationException {
        return this.currentDifference;
    }

    public JToolBar getToolBar() {
        return this.views[0].getToolBar();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        this.getPropertyChangeSupport().firePropertyChange(propertyChangeEvent2);
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        return this.support;
    }

    private class MoveAction
    extends AbstractAction {
        final int increment;

        MoveAction(int n) {
            this.increment = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MultiDiffView.this.roller.getValue() + this.increment;
            if (MultiDiffView.this.roller.getMinimum() < n && n < MultiDiffView.this.roller.getMaximum()) {
                MultiDiffView.this.roller.setValue(n);
            }
        }
    }

    private class MultiDiffViewPanel
    extends JPanel
    implements ChangeListener {
        private JScrollPane pane;

        MultiDiffViewPanel() {
            this.setFocusable(false);
            ScrollablePanel scrollablePanel = new ScrollablePanel();
            this.pane = new JScrollPane();
            this.pane.setBorder(BorderFactory.createEmptyBorder());
            this.pane.setHorizontalScrollBarPolicy(31);
            this.pane.setViewportView(scrollablePanel);
            for (int i = 0; i < MultiDiffView.this.views.length; ++i) {
                JComponent jComponent = (JComponent)MultiDiffView.this.views[i].getComponent();
                if (i == 0) {
                    this.putClientProperty(UndoRedo.class, jComponent.getClientProperty(UndoRedo.class));
                }
                scrollablePanel.add(jComponent);
                if (!(MultiDiffView.this.views[i] instanceof NestableDiffView)) continue;
                jComponent.putClientProperty(NestableDiffView.class, MultiDiffView.this.views[i]);
                NestableDiffView nestableDiffView = (NestableDiffView)MultiDiffView.this.views[i];
                KeyStroke keyStroke = KeyStroke.getKeyStroke(37, 0);
                MoveAction moveAction = new MoveAction(-10);
                Object object = this.pane.getInputMap(1).get(keyStroke);
                this.pane.getActionMap().put(object, moveAction);
                keyStroke = KeyStroke.getKeyStroke(39, 0);
                moveAction = new MoveAction(10);
                object = this.pane.getInputMap(1).get(keyStroke);
                this.pane.getActionMap().put(object, moveAction);
                nestableDiffView.joinScrollPane(this.pane);
                ((MultiDiffView)MultiDiffView.this).nestableViews[i] = nestableDiffView;
            }
            scrollablePanel.add(new Padding(MultiDiffView.this.parent));
            this.setLayout(new BorderLayout());
            this.add((Component)this.pane, "Center");
            this.add((Component)new SummarySideBar(), "After");
            JScrollBar jScrollBar = new JScrollBar(1);
            int n = jScrollBar.getPreferredSize().width + 12;
            MultiDiffView.this.roller.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, n));
            this.add((Component)MultiDiffView.this.roller, "South");
        }

        public void layout() {
            this.layoutImpl();
        }

        public void doLayout() {
            this.layoutImpl();
        }

        void layoutImpl() {
            int n;
            super.layout();
            for (n = 0; n < MultiDiffView.this.nestableViews.length; ++n) {
                MultiDiffView.this.innerViewsWidth = Math.max(MultiDiffView.this.innerViewsWidth, MultiDiffView.this.nestableViews[n].getInnerWidth());
            }
            for (n = 0; n < MultiDiffView.this.nestableViews.length; ++n) {
                MultiDiffView.this.nestableViews[n].setInnerWidth(MultiDiffView.this.innerViewsWidth);
            }
            BoundedRangeModel boundedRangeModel = MultiDiffView.this.roller.getModel();
            if (MultiDiffView.this.innerViewsWidth > this.viewWidth()) {
                MultiDiffView.this.roller.setVisible(true);
                this.afterResize();
                boundedRangeModel.addChangeListener(this);
            } else {
                MultiDiffView.this.roller.setVisible(false);
                boundedRangeModel.removeChangeListener(this);
            }
        }

        void afterResize() {
            BoundedRangeModel boundedRangeModel = MultiDiffView.this.roller.getModel();
            boundedRangeModel.setMaximum(MultiDiffView.this.innerViewsWidth);
            boundedRangeModel.setExtent(this.viewWidth());
            boundedRangeModel.setValue(0);
        }

        int viewWidth() {
            JScrollBar jScrollBar = new JScrollBar(1);
            int n = jScrollBar.getPreferredSize().width + 12;
            return MultiDiffView.this.parent.getWidth() - n;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            BoundedRangeModel boundedRangeModel = MultiDiffView.this.roller.getModel();
            if (changeEvent.getSource() == boundedRangeModel) {
                if (boundedRangeModel.getValueIsAdjusting()) {
                    // empty if block
                }
                for (int i = 0; i < MultiDiffView.this.nestableViews.length; ++i) {
                    MultiDiffView.this.nestableViews[i].setHorizontalPosition(boundedRangeModel.getValue());
                }
            }
        }

        public boolean requestFocusInWindow() {
            return this.pane.requestFocusInWindow();
        }

        void setViewPosition(Point point) {
            this.pane.getViewport().setViewPosition(point);
        }
    }

    static final class Padding
    extends JLabel {
        final Component view;

        Padding(Component component) {
            super(NbBundle.getMessage(MultiDiffView.class, (String)"LBL_Diff_Padding"), 0);
            this.view = component;
        }

        public Dimension getPreferredSize() {
            return this.view.getSize();
        }

        public Dimension getMinimumSize() {
            return this.view.getSize();
        }

        public Dimension getMaximumSize() {
            return this.view.getSize();
        }
    }

    private class ScrollablePanel
    extends JPanel
    implements Scrollable {
        ScrollablePanel() {
            this.setLayout(new VerticalFlowLayout(MultiDiffView.this.parent));
            this.setFocusable(false);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            JComponent jComponent = (JComponent)this.getComponent(0);
            NestableDiffView nestableDiffView = (NestableDiffView)jComponent.getClientProperty(NestableDiffView.class);
            return nestableDiffView.getInnerScrollableUnitIncrement(rectangle, n, n2);
        }

        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            JComponent jComponent = (JComponent)this.getComponent(0);
            NestableDiffView nestableDiffView = (NestableDiffView)jComponent.getClientProperty(NestableDiffView.class);
            return nestableDiffView.getInnerScrollableBlockIncrement(rectangle, n, n2);
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    class SummarySideBar
    extends JComponent {
        SummarySideBar() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(12, Integer.MAX_VALUE);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = graphics.getColor();
            graphics.setColor(Color.BLUE);
            int n = 0;
            float f = this.getHeight() - 12 - 12;
            float f2 = f / (float)MultiDiffView.this.panel.getHeight();
            for (int i = 0; i < MultiDiffView.this.views.length; ++i) {
                if (MultiDiffView.this.nestableViews[i] == null) continue;
                for (int j = 0; j < MultiDiffView.this.views[i].getDifferenceCount(); ++j) {
                    int n2 = MultiDiffView.this.nestableViews[i].getChangeY(j);
                    int n3 = 12 + (int)((float)(n2 + n) * f2);
                    graphics.drawRect(0, n3, 12, 1);
                }
                n += MultiDiffView.this.views[i].getComponent().getHeight();
            }
            graphics.setColor(color);
        }
    }
}

