/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnProperties;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SvnPropertiesAction
extends ContextAction {
    protected boolean enable(Node[] nodeArray) {
        return this.getContext(nodeArray).getRootFiles().length == 1;
    }

    public String getName() {
        return NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesAction");
    }

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Properties";
    }

    protected void performContextAction(Node[] nodeArray) {
        Object object;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        String string = this.getContextDisplayName(nodeArray);
        File[] fileArray = context.getRootFiles();
        try {
            object = SvnUtils.getRepositoryRootUrl(fileArray[0]);
            SvnClient svnClient = Subversion.getInstance().getClient((SVNUrl)object);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        object = new PropertiesPanel();
        PropertiesTable propertiesTable = new PropertiesTable(PropertiesTable.PROPERTIES_COLUMNS, new String[]{"value"});
        ((PropertiesPanel)object).setPropertiesTable(propertiesTable);
        JComponent jComponent = propertiesTable.getComponent();
        ((PropertiesPanel)object).propsPanel.setLayout(new BorderLayout());
        ((PropertiesPanel)object).propsPanel.add((Component)jComponent, "Center");
        SvnProperties svnProperties = new SvnProperties((PropertiesPanel)object, propertiesTable, fileArray[0]);
        DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesDialog_Title", (Object)string));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setOptions(new Object[]{NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_Properties_Action_Cancel")});
        dialogDescriptor.setHelpCtx(new HelpCtx(SvnPropertiesAction.class));
        ((JComponent)object).putClientProperty("contentTitle", string);
        ((JComponent)object).putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
    }
}

