/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.relocate;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.relocate.RelocatePanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RelocateAction
extends AbstractAction {
    VCSContext ctx;
    SvnProgressSupport support;

    public RelocateAction(String string, VCSContext vCSContext) {
        super(string);
        this.ctx = vCSContext;
    }

    public boolean isEnabled() {
        Set set = this.ctx.getRootFiles();
        if (set == null || set.size() != 1) {
            return false;
        }
        File file = (File)set.iterator().next();
        return file != null && file.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        SVNUrl sVNUrl;
        ResourceBundle resourceBundle = NbBundle.getBundle(RelocateAction.class);
        final RelocatePanel relocatePanel = new RelocatePanel();
        relocatePanel.getCurrentURL().setText(this.getCurrentURL());
        relocatePanel.getWorkingCopy().setText(this.getWorkingCopy());
        final JButton jButton = new JButton(resourceBundle.getString("CTL_Relocate_Action_Name"));
        jButton.setEnabled(false);
        jButton.setToolTipText(resourceBundle.getString("TT_Relocate_Action"));
        relocatePanel.getNewURL().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }
        });
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_Relocate_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RelocateAction.class, (String)"ACSD_Relocate_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)relocatePanel, resourceBundle.getString("CTL_Relocate_Title"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(null);
        dialogDescriptor.setHelpCtx(new HelpCtx(RelocateAction.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Relocate"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        relocatePanel.getNewURL().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }
        });
        final String string = relocatePanel.getNewURL().getText();
        File file = (File)this.ctx.getRootFiles().iterator().next();
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        final String string2 = file.getAbsolutePath();
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        try {
            this.support = new SvnProgressSupport(){
                SvnClient client = null;

                protected void perform() {
                    try {
                        this.client = Subversion.getInstance().getClient(sVNUrl);
                        this.client.relocate(sVNUrl.toString(), string, string2, true);
                    }
                    catch (SVNClientException sVNClientException) {
                        RelocateAction.this.support.annotate(sVNClientException);
                    }
                }
            };
            this.support.start(requestProcessor, sVNUrl, resourceBundle.getString("LBL_Relocate_Progress"));
        }
        finally {
            this.support = null;
        }
    }

    private String getCurrentURL() {
        File file = (File)this.ctx.getRootFiles().iterator().next();
        try {
            SVNUrl sVNUrl = SvnUtils.getRepositoryRootUrl(file);
            return sVNUrl.toString();
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return "";
        }
    }

    private String getWorkingCopy() {
        File file = (File)this.ctx.getRootFiles().iterator().next();
        String string = file.getAbsolutePath();
        return string;
    }

    public void validate(RelocatePanel relocatePanel, JButton jButton) {
        try {
            new SVNUrl(relocatePanel.getNewURL().getText());
            jButton.setEnabled(true);
        }
        catch (MalformedURLException malformedURLException) {
            jButton.setEnabled(false);
        }
    }
}

