/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.repository;

import java.net.MalformedURLException;
import org.netbeans.modules.subversion.config.Scrambler;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryConnection {
    private static final String RC_DELIMITER = "~=~";
    private String url;
    private String username;
    private String password;
    private String externalCommand;
    private SVNUrl svnUrl;
    private SVNRevision svnRevision;

    public RepositoryConnection(RepositoryConnection repositoryConnection) {
        this(repositoryConnection.url, repositoryConnection.username, repositoryConnection.password, repositoryConnection.externalCommand);
    }

    public RepositoryConnection(String string) {
        this(string, null, null, null);
    }

    public RepositoryConnection(String string, String string2, String string3, String string4) {
        this.setUrl(string);
        this.setUsername(string2);
        this.setPassword(string3);
        this.setExternalCommand(string4);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username == null ? "" : this.username;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public String getExternalCommand() {
        return this.externalCommand == null ? "" : this.externalCommand;
    }

    public SVNUrl getSvnUrl() throws MalformedURLException {
        if (this.svnUrl == null) {
            this.parseUrlString(this.url);
        }
        return this.svnUrl;
    }

    public SVNRevision getSvnRevision() throws MalformedURLException {
        if (this.svnRevision == null) {
            this.parseUrlString(this.url);
        }
        return this.svnRevision;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RepositoryConnection repositoryConnection = (RepositoryConnection)object;
        return this.url == repositoryConnection.url || this.url == null || this.url.equals(repositoryConnection.url);
    }

    public int hashCode() {
        int n = 3;
        n = 61 * n + (this.url != null ? this.url.hashCode() : 0);
        return n;
    }

    void setUrl(String string) {
        this.url = string;
        this.svnUrl = null;
        this.svnRevision = null;
    }

    void setUsername(String string) {
        this.username = string;
    }

    void setPassword(String string) {
        this.password = string;
    }

    void setExternalCommand(String string) {
        this.externalCommand = string;
    }

    public String toString() {
        return this.url;
    }

    private void parseUrlString(String string) throws MalformedURLException {
        int n = string.lastIndexOf(64);
        int n2 = string.indexOf("://");
        int n3 = string.indexOf("/", n2 + 3);
        if (n < 0 || n3 < 0 || n < n3) {
            this.svnRevision = SVNRevision.HEAD;
        } else {
            if (n + 1 < string.length()) {
                String string2 = "";
                try {
                    string2 = string.substring(n + 1);
                    this.svnRevision = SvnUtils.getSVNRevision(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException(NbBundle.getMessage(Repository.class, (String)"MSG_Repository_WrongRevision", (Object)string2));
                }
            } else {
                this.svnRevision = SVNRevision.HEAD;
            }
            string = string.substring(0, n);
        }
        this.svnUrl = this.removeEmptyPathSegments(new SVNUrl(string));
    }

    private SVNUrl removeEmptyPathSegments(SVNUrl sVNUrl) throws MalformedURLException {
        String[] stringArray = sVNUrl.getPathSegments();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sVNUrl.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(SvnUtils.ripUserFromHost(sVNUrl.getHost()));
        if (sVNUrl.getPort() > 0) {
            stringBuffer.append(":");
            stringBuffer.append(sVNUrl.getPort());
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("")) continue;
            bl = true;
            stringBuffer.append("/");
            stringBuffer.append(stringArray[i]);
        }
        if (bl) {
            return new SVNUrl(stringBuffer.toString());
        }
        return sVNUrl;
    }

    public static String getString(RepositoryConnection repositoryConnection) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = repositoryConnection.getSvnUrl();
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sVNUrl.toString());
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(repositoryConnection.getUsername());
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(Scrambler.getInstance().scramble(repositoryConnection.getPassword()));
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(repositoryConnection.getExternalCommand());
        stringBuffer.append(RC_DELIMITER);
        stringBuffer.append(RC_DELIMITER);
        return stringBuffer.toString();
    }

    public static RepositoryConnection parse(String string) {
        String[] stringArray = string.split(RC_DELIMITER);
        int n = stringArray.length;
        String string2 = stringArray[0];
        String string3 = n > 1 && !stringArray[1].equals("") ? stringArray[1] : null;
        String string4 = n > 2 && !stringArray[2].equals("") ? Scrambler.getInstance().descramble(stringArray[2]) : null;
        String string5 = n > 3 && !stringArray[3].equals("") ? stringArray[3] : null;
        return new RepositoryConnection(string2, string3, string4, string5);
    }
}

