/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.status;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.subversion.ui.actions.AbstractAllAction;
import org.netbeans.modules.subversion.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ShowAllChangesAction
extends AbstractAllAction {
    public String getName() {
        return NbBundle.getMessage(ShowAllChangesAction.class, (String)"CTL_MenuItem_ShowAllChanges_Label");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ShowAllChangesAction.this.async();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async() {
        try {
            String string;
            this.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SvnVersioningTopComponent svnVersioningTopComponent = SvnVersioningTopComponent.getInstance();
                    svnVersioningTopComponent.setContext(null);
                    svnVersioningTopComponent.open();
                }
            });
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            final Context context = SvnUtils.getProjectsContext(projectArray);
            if (projectArray.length == 1) {
                Project project = projectArray[0];
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                string = projectInformation.getDisplayName();
            } else {
                string = NbBundle.getMessage(ShowAllChangesAction.class, (String)"CTL_ShowAllChanges_WindowTitle", (Object)Integer.toString(projectArray.length));
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SvnVersioningTopComponent svnVersioningTopComponent = SvnVersioningTopComponent.getInstance();
                    svnVersioningTopComponent.setContentTitle(string);
                    svnVersioningTopComponent.setContext(context);
                    svnVersioningTopComponent.open();
                    svnVersioningTopComponent.requestActive();
                    if (ShowAllChangesAction.this.shouldPostRefresh()) {
                        svnVersioningTopComponent.performRefreshAction();
                    }
                }
            });
        }
        finally {
            this.setEnabled(true);
        }
    }

    protected boolean shouldPostRefresh() {
        return true;
    }
}

