/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.checkoutstep.CheckoutStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class CheckoutWizard
implements ChangeListener {
    private WizardDescriptor.Panel[] panels;
    private RepositoryStep repositoryStep;
    private CheckoutStep checkoutStep;
    private String errorMessage;
    private WizardDescriptor wizardDescriptor;
    private PanelsIterator wizardIterator;

    public boolean show() {
        boolean bl;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(CheckoutWizard.class, (String)"CTL_Checkout"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CheckoutWizard.class, (String)"CTL_Checkout"));
        dialog.setVisible(true);
        dialog.toFront();
        Object object = this.wizardDescriptor.getValue();
        boolean bl2 = bl = object == WizardDescriptor.FINISH_OPTION;
        if (bl) {
            this.onFinished();
        } else if (object == WizardDescriptor.CLOSED_OPTION || object == WizardDescriptor.CANCEL_OPTION) {
            this.repositoryStep.stop();
        }
        return bl;
    }

    private void onFinished() {
        String string = this.checkoutStep.getWorkdir().getPath();
        SvnModuleConfig.getDefault().getPreferences().put("checkoutStep.checkoutDirectory", string);
    }

    private void setErrorMessage(String string) {
        this.errorMessage = string;
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.wizardIterator == null) {
            return;
        }
        AbstractStep abstractStep = (AbstractStep)this.wizardIterator.current();
        if (abstractStep == null) {
            return;
        }
        this.setErrorMessage(abstractStep.getErrorMessage());
    }

    public RepositoryFile[] getRepositoryFiles() {
        return this.checkoutStep.getRepositoryFiles();
    }

    public File getWorkdir() {
        return this.checkoutStep.getWorkdir();
    }

    public SVNUrl getRepositoryRoot() {
        return this.repositoryStep.getRepositoryFile().getRepositoryUrl();
    }

    public boolean isAtWorkingDirLevel() {
        return this.checkoutStep.isAtWorkingDirLevel();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[3];
            CheckoutWizard.this.repositoryStep = new RepositoryStep(8);
            CheckoutWizard.this.repositoryStep.addChangeListener(CheckoutWizard.this);
            CheckoutWizard.this.checkoutStep = new CheckoutStep();
            CheckoutWizard.this.checkoutStep.addChangeListener(CheckoutWizard.this);
            panelArray = new WizardDescriptor.Panel[]{CheckoutWizard.this.repositoryStep, CheckoutWizard.this.checkoutStep};
            String[] stringArray = new String[panelArray.length];
            for (int i = 0; i < panelArray.length; ++i) {
                Component component = panelArray[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panelArray;
        }

        public void nextPanel() {
            if (this.current() == CheckoutWizard.this.repositoryStep) {
                CheckoutWizard.this.checkoutStep.setup(CheckoutWizard.this.repositoryStep.getRepositoryFile());
            }
            super.nextPanel();
        }
    }
}

