/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.importstep;

import java.awt.event.FocusEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.checkout.CheckoutAction;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.importstep.ImportPanel;
import org.netbeans.modules.subversion.util.FileUtils;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ImportStep
extends AbstractStep
implements DocumentListener,
WizardDescriptor.AsynchronousValidatingPanel,
WizardDescriptor.FinishablePanel {
    private ImportPanel importPanel;
    private RepositoryPaths repositoryPaths;
    private BrowserAction[] actions;
    private File importDirectory;
    private WizardStepProgressSupport support;

    public ImportStep(BrowserAction[] browserActionArray, File file) {
        this.actions = browserActionArray;
        this.importDirectory = file;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ImportStep.class);
    }

    protected JComponent createComponent() {
        if (this.importPanel == null) {
            this.importPanel = new ImportPanel();
            this.importPanel.messageTextArea.getDocument().addDocumentListener(this);
            this.importPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
        }
        return this.importPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() {
        try {
            if (this.support != null) {
                this.support.performInCurrentThread(NbBundle.getMessage(ImportStep.class, (String)"CTL_Import_Progress"));
            }
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
        this.support = new ImportProgressSupport(this.importPanel.progressPanel, this.importPanel.progressLabel);
        this.support.startProgress();
    }

    public boolean validateUserInput() {
        boolean bl;
        this.invalid(null);
        String string = this.importPanel.repositoryPathTextField.getText().trim();
        if (string.length() == 0) {
            this.invalid(NbBundle.getMessage(ImportStep.class, (String)"BK2014"));
            return false;
        }
        string = this.importPanel.messageTextArea.getText().trim();
        boolean bl2 = bl = string.length() > 0;
        if (bl) {
            this.valid();
        } else {
            this.invalid(NbBundle.getMessage(ImportStep.class, (String)"CTL_Import_MessageRequired"));
        }
        return bl;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validateUserInput();
    }

    public String getImportMessage() {
        return this.importPanel.messageTextArea.getText();
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.importPanel.repositoryPathTextField.getText().trim().equals("")) {
            if (this.repositoryPaths == null) {
                this.repositoryPaths = new RepositoryPaths(repositoryFile, this.importPanel.repositoryPathTextField, this.importPanel.browseRepositoryButton, null, null);
                String string = NbBundle.getMessage(ImportStep.class, (String)"LBL_BrowserMessage");
                int n = 2;
                this.repositoryPaths.setupBrowserBehavior(string, n, this.actions);
            } else {
                this.repositoryPaths.setRepositoryFile(repositoryFile);
            }
        }
        this.importPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        this.validateUserInput();
    }

    public RepositoryFile getRepositoryFile() {
        try {
            return this.repositoryPaths.getRepositoryFiles()[0];
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManager.getDefault().notify(1, (Throwable)malformedURLException);
            return null;
        }
    }

    public SVNUrl getRepositoryFolderUrl() {
        return this.getRepositoryFile().getFileUrl();
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public boolean isFinishPanel() {
        return true;
    }

    private static void forceStatusRefresh(File file) {
        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        if (!file.isFile()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                ImportStep.forceStatusRefresh(fileArray[i]);
            }
        }
    }

    private class ImportProgressSupport
    extends WizardStepProgressSupport {
        public ImportProgressSupport(JPanel jPanel, JLabel jLabel) {
            super(jPanel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void perform() {
            String string;
            block39: {
                block38: {
                    Object object;
                    SVNUrl sVNUrl;
                    RepositoryFile repositoryFile;
                    SvnClient svnClient;
                    block37: {
                        block36: {
                            block35: {
                                string = null;
                                try {
                                    if (ImportStep.this.validateUserInput()) break block35;
                                    Subversion.getInstance().versionedFilesChanged();
                                }
                                catch (Throwable throwable) {
                                    Subversion.getInstance().versionedFilesChanged();
                                    if (this.isCanceled()) {
                                        ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                                    } else if (string != null) {
                                        ImportStep.this.valid(string);
                                    } else {
                                        ImportStep.this.valid();
                                    }
                                    throw throwable;
                                }
                                if (this.isCanceled()) {
                                    ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                                } else if (string != null) {
                                    ImportStep.this.valid(string);
                                } else {
                                    ImportStep.this.valid();
                                }
                                return;
                            }
                            ImportStep.this.invalid(null);
                            try {
                                svnClient = Subversion.getInstance().getClient(ImportStep.this.repositoryPaths.getRepositoryUrl(), (SvnProgressSupport)this);
                            }
                            catch (SVNClientException sVNClientException) {
                                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                                string = SvnClientExceptionHandler.parseExceptionMessage(sVNClientException);
                                Subversion.getInstance().versionedFilesChanged();
                                if (this.isCanceled()) {
                                    ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                                } else if (string != null) {
                                    ImportStep.this.valid(string);
                                } else {
                                    ImportStep.this.valid();
                                }
                                return;
                            }
                            repositoryFile = ImportStep.this.getRepositoryFile();
                            sVNUrl = repositoryFile.getRepositoryUrl();
                            try {
                                FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + ".svn"));
                                FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + "_svn"));
                                object = new File(System.getProperty("java.io.tmpdir") + "/svn_dummy/" + ImportStep.this.importDirectory.getName());
                                ((File)object).mkdirs();
                                ((File)object).deleteOnExit();
                                svnClient.doImport((File)object, repositoryFile.getFileUrl(), ImportStep.this.getImportMessage(), false);
                            }
                            catch (SVNClientException sVNClientException) {
                                if (SvnClientExceptionHandler.isFileAlreadyExists(sVNClientException.getMessage())) break block36;
                                throw sVNClientException;
                            }
                        }
                        if (!this.isCanceled()) break block37;
                        Subversion.getInstance().versionedFilesChanged();
                        if (this.isCanceled()) {
                            ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                        } else if (string != null) {
                            ImportStep.this.valid(string);
                        } else {
                            ImportStep.this.valid();
                        }
                        return;
                    }
                    object = new RepositoryFile[]{repositoryFile};
                    CheckoutAction.checkout(svnClient, sVNUrl, (RepositoryFile[])object, ImportStep.this.importDirectory, true, this);
                    Subversion.getInstance().versionedFilesChanged();
                    SvnUtils.refreshRecursively(ImportStep.this.importDirectory);
                    ImportStep.forceStatusRefresh(ImportStep.this.importDirectory);
                    if (!this.isCanceled()) break block38;
                    FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + ".svn"));
                    FileUtils.deleteRecursively(new File(ImportStep.this.importDirectory.getAbsoluteFile() + "/" + "_svn"));
                    Subversion.getInstance().versionedFilesChanged();
                    if (this.isCanceled()) {
                        ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
                    } else if (string != null) {
                        ImportStep.this.valid(string);
                    } else {
                        ImportStep.this.valid();
                    }
                    return;
                }
                break block39;
                catch (SVNClientException sVNClientException) {
                    this.annotate(sVNClientException);
                    string = SvnClientExceptionHandler.parseExceptionMessage(sVNClientException);
                }
            }
            Subversion.getInstance().versionedFilesChanged();
            if (this.isCanceled()) {
                ImportStep.this.valid(NbBundle.getMessage(ImportStep.class, (String)"MSG_Import_ActionCanceled"));
            } else if (string != null) {
                ImportStep.this.valid(string);
            } else {
                ImportStep.this.valid();
            }
        }

        public void setEditable(boolean bl) {
            ((ImportStep)ImportStep.this).importPanel.browseRepositoryButton.setEnabled(bl);
            ((ImportStep)ImportStep.this).importPanel.messageTextArea.setEditable(bl);
            ((ImportStep)ImportStep.this).importPanel.repositoryPathTextField.setEditable(bl);
        }

        private void deleteDirectory(File file) {
            File[] fileArray = file.listFiles();
            if (fileArray != null || fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        this.deleteDirectory(fileArray[i]);
                        continue;
                    }
                    fileArray[i].delete();
                }
            }
            file.delete();
        }
    }
}

