/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.FlatFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements Serializable {
    public static final Context Empty = new Context(Context.getEmptyList(), Context.getEmptyList(), Context.getEmptyList());
    private static final long serialVersionUID = 1L;
    private final List<File> filteredFiles;
    private final List<File> rootFiles;
    private final List<File> exclusions;

    public Context(List<File> list, List<File> list2, List<File> list3) {
        this.filteredFiles = list;
        this.rootFiles = list2;
        this.exclusions = list3;
        while (this.normalize()) {
        }
    }

    public Context(File file) {
        this(new File[]{file});
    }

    public Context(File[] fileArray) {
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        arrayList.addAll(Arrays.asList(fileArray));
        this.removeDuplicates(arrayList);
        this.filteredFiles = arrayList;
        this.rootFiles = arrayList;
        this.exclusions = Collections.emptyList();
    }

    private boolean normalize() {
        for (File file : this.rootFiles) {
            Iterator<File> iterator = this.exclusions.iterator();
            while (iterator.hasNext()) {
                File file2 = iterator.next();
                if (!SvnUtils.isParentOrEqual(file2, file)) continue;
                iterator.remove();
                this.exclusionRemoved(file2, file);
                return true;
            }
        }
        this.removeDuplicates(this.rootFiles);
        this.removeDuplicates(this.exclusions);
        return false;
    }

    private void removeDuplicates(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        block0: for (File file : list) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (SvnUtils.isParentOrEqual(file2, file) && (file.isFile() || !(file2 instanceof FlatFolder))) continue block0;
                if (!SvnUtils.isParentOrEqual(file, file2) || !file2.isFile() && file instanceof FlatFolder) continue;
                iterator.remove();
            }
            arrayList.add(file);
        }
        list.clear();
        list.addAll(arrayList);
    }

    private void exclusionRemoved(File file, File file2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (SvnUtils.isParentOrEqual(file2, file3)) continue;
            this.exclusions.add(file3);
        }
    }

    public List<File> getRoots() {
        return this.rootFiles;
    }

    public List<File> getExclusions() {
        return this.exclusions;
    }

    public File[] getFiles() {
        return this.filteredFiles.toArray(new File[this.filteredFiles.size()]);
    }

    public File[] getRootFiles() {
        return this.rootFiles.toArray(new File[this.rootFiles.size()]);
    }

    public boolean contains(File file) {
        block0: for (File file2 : this.rootFiles) {
            if (!SvnUtils.isParentOrEqual(file2, file)) continue;
            for (File file3 : this.exclusions) {
                if (!SvnUtils.isParentOrEqual(file3, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public static final List<File> getEmptyList() {
        return Collections.emptyList();
    }
}

