/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class ProxySettings {
    private static final String PROXY_HTTP_HOST = "proxyHttpHost";
    private static final String PROXY_HTTP_PORT = "proxyHttpPort";
    private static final String PROXY_HTTPS_HOST = "proxyHttpsHost";
    private static final String PROXY_HTTPS_PORT = "proxyHttpsPort";
    private static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final String PROXY_TYPE = "proxyType";
    private static final String DIRECT_CONNECTION = "0";
    private String username;
    private String password;
    private String notProxyHosts;
    private boolean useAuth;
    private String httpHost;
    private String httpPort;
    private String httpsHost;
    private String httpsPort;
    private String proxyType;

    public ProxySettings() {
        this.init();
    }

    private void init() {
        Preferences preferences = NbPreferences.root().node("org/netbeans/core");
        this.useAuth = preferences.getBoolean(USE_PROXY_AUTHENTICATION, false);
        this.username = preferences.get(PROXY_AUTHENTICATION_USERNAME, "");
        this.password = preferences.get(PROXY_AUTHENTICATION_PASSWORD, "");
        this.notProxyHosts = preferences.get(NOT_PROXY_HOSTS, "").replace("|", " ,");
        this.httpHost = preferences.get(PROXY_HTTP_HOST, "");
        this.httpPort = preferences.get(PROXY_HTTP_PORT, "");
        this.httpsHost = preferences.get(PROXY_HTTPS_HOST, "");
        this.httpsPort = preferences.get(PROXY_HTTPS_PORT, "");
        this.proxyType = preferences.get(PROXY_TYPE, "");
    }

    public boolean isDirect() {
        return this.proxyType.equals(DIRECT_CONNECTION);
    }

    public boolean hasAuth() {
        return this.useAuth;
    }

    public String getHttpHost() {
        return this.httpHost;
    }

    public int getHttpPort() {
        if (this.httpPort.equals("")) {
            return 8080;
        }
        return Integer.parseInt(this.httpPort);
    }

    public String getHttpsHost() {
        return this.httpsHost;
    }

    public int getHttpsPort() {
        if (this.httpsPort.equals("")) {
            return 443;
        }
        return Integer.parseInt(this.httpsPort);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNotProxyHosts() {
        return this.notProxyHosts;
    }
}

