/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.util;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.versioning.util.FlatFolder;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnUtils {
    private static final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.|_)svn(\\" + File.separatorChar + ".*|$)");
    private static Node[] contextNodesCached;
    private static Context contextCached;

    public static Context getCurrentContext(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = TopComponent.getRegistry().getActivatedNodes();
        }
        if (Arrays.equals(contextNodesCached, nodeArray)) {
            return contextCached;
        }
        ArrayList<File> arrayList = new ArrayList<File>(nodeArray.length);
        ArrayList<File> arrayList2 = new ArrayList<File>(nodeArray.length);
        ArrayList<File> arrayList3 = new ArrayList<File>(5);
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            SvnFileNode svnFileNode = (SvnFileNode)node.getLookup().lookup(SvnFileNode.class);
            if (svnFileNode != null) {
                arrayList.add(svnFileNode.getFile());
                arrayList2.add(svnFileNode.getFile());
                continue;
            }
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                SvnUtils.addProjectFiles(arrayList, arrayList2, arrayList3, project);
                continue;
            }
            SvnUtils.addFileObjects(node, arrayList, arrayList2);
        }
        contextCached = new Context(arrayList, arrayList2, arrayList3);
        contextNodesCached = nodeArray;
        return contextCached;
    }

    public static Context getCurrentContext(Node[] nodeArray, int n, int n2) {
        Context context = SvnUtils.getCurrentContext(nodeArray);
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if (!(file.isDirectory() ? (fileInformation.getStatus() & n2) == 0 : (fileInformation.getStatus() & n) == 0)) continue;
            return Context.Empty;
        }
        return context;
    }

    public static boolean isVersionedProject(Node node) {
        Lookup lookup = node.getLookup();
        Project project = (Project)lookup.lookup(Project.class);
        return SvnUtils.isVersionedProject(project);
    }

    public static boolean isVersionedProject(Project project) {
        if (project != null) {
            FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                File file = FileUtil.toFile((FileObject)sourceGroup.getRootFolder());
                if ((fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static void addFileObjects(Node node, List<File> list, List<File> list2) {
        Collection collection = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (collection.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : collection) {
                arrayList.add(new FlatFolder(FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder()).getAbsolutePath()));
            }
        } else {
            Collection collection2 = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (collection2.size() > 0) {
                arrayList.addAll(SvnUtils.toFileCollection(collection2));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection<File> collection3 = SvnUtils.toFileCollection(dataObject.files());
                    arrayList.addAll(collection3);
                }
            }
        }
        list.addAll(arrayList);
        list2.addAll(arrayList);
    }

    public static void addProjectFiles(Collection<File> collection, Collection<File> collection2, Collection<File> collection3, Project project) {
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            if ((fileStatusCache.getStatus(file).getStatus() & 0xFFFFFFFE) == 0) continue;
            collection2.add(file);
            boolean bl = false;
            FileObject[] fileObjectArray = fileObject.getChildren();
            HashSet<File> hashSet = new HashSet<File>(fileObjectArray.length);
            for (int j = 0; j < fileObjectArray.length; ++j) {
                FileObject fileObject2 = fileObjectArray[j];
                if (Subversion.getInstance().isAdministrative(fileObject2.getNameExt())) continue;
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                if (sourceGroup.contains(fileObject2)) {
                    hashSet.add(file2);
                    continue;
                }
                int n = fileStatusCache.getStatus(file2).getStatus();
                if (n == 2) continue;
                collection3.add(file2);
                bl = true;
            }
            if (bl) {
                collection.addAll(hashSet);
                continue;
            }
            collection.add(file);
        }
    }

    public static Context getProjectsContext(Project[] projectArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        for (int i = 0; i < projectArray.length; ++i) {
            SvnUtils.addProjectFiles(arrayList, arrayList2, arrayList3, projectArray[i]);
        }
        return new Context(arrayList, arrayList2, arrayList3);
    }

    private static Collection<File> toFileCollection(Collection<? extends FileObject> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        for (FileObject fileObject : collection) {
            hashSet.add(FileUtil.toFile((FileObject)fileObject));
        }
        hashSet.remove(null);
        return hashSet;
    }

    public static File[] toFileArray(Collection<FileObject> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size() * 4 / 3 + 1);
        Iterator<FileObject> iterator = collection.iterator();
        while (iterator.hasNext()) {
            hashSet.add(FileUtil.toFile((FileObject)iterator.next()));
        }
        hashSet.remove(null);
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public static boolean isParentOrEqual(File file, File file2) {
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static String previousRevision(String string) {
        return string == null ? null : Long.toString(Long.parseLong(string) - 1L);
    }

    public static String getRelativePath(File file) throws SVNClientException {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        SVNUrl sVNUrl = null;
        boolean bl = false;
        while (Subversion.getInstance().isManaged(file)) {
            SvnClient svnClient;
            ISVNInfo iSVNInfo;
            block7: {
                bl = true;
                iSVNInfo = null;
                try {
                    svnClient = Subversion.getInstance().getClient(false);
                    iSVNInfo = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block7;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNInfo != null && iSVNInfo.getUrl() != null) {
                svnClient = SvnUtils.decode(iSVNInfo.getUrl());
                sVNUrl = iSVNInfo.getRepository();
                if (svnClient != null && sVNUrl != null) {
                    String string2 = svnClient.toString();
                    String string3 = sVNUrl.toString();
                    string = string2.substring(string3.length());
                    Iterator iterator = arrayList.iterator();
                    StringBuffer stringBuffer = new StringBuffer();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        stringBuffer.append("/");
                        stringBuffer.append(string4);
                    }
                    string = string + stringBuffer.toString();
                    break;
                }
            }
            arrayList.add(0, file.getName());
            file = file.getParentFile();
        }
        if (sVNUrl == null & bl) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        return string;
    }

    public static String getRelativePath(SVNUrl sVNUrl, File file) throws SVNClientException {
        SvnClient svnClient;
        String string = null;
        try {
            svnClient = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (Subversion.getInstance().isManaged(file)) {
            SVNUrl sVNUrl2;
            ISVNStatus iSVNStatus;
            block8: {
                bl = true;
                iSVNStatus = null;
                try {
                    iSVNStatus = svnClient.getSingleStatus(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block8;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNStatus != null && iSVNStatus.getUrl() != null && (sVNUrl2 = iSVNStatus.getUrl()) != null && sVNUrl != null) {
                sVNUrl2 = SvnUtils.decode(sVNUrl2);
                String string2 = sVNUrl2.toString();
                String string3 = sVNUrl.toString();
                string = string2.substring(string3.length());
                Iterator iterator = arrayList.iterator();
                StringBuffer stringBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    stringBuffer.append("/");
                    stringBuffer.append(string4);
                }
                string = string + stringBuffer.toString();
                break;
            }
            arrayList.add(0, file.getName());
            file = file.getParentFile();
        }
        if (sVNUrl == null & bl) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        return string;
    }

    public static SVNUrl getRepositoryRootUrl(File file) throws SVNClientException {
        SvnClient svnClient;
        try {
            svnClient = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        SVNUrl sVNUrl = null;
        boolean bl = false;
        while (Subversion.getInstance().isManaged(file)) {
            ISVNInfo iSVNInfo;
            block6: {
                bl = true;
                iSVNInfo = null;
                try {
                    iSVNInfo = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block6;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNInfo != null && iSVNInfo.getUrl() != null && (sVNUrl = iSVNInfo.getRepository()) != null) break;
            file = file.getParentFile();
        }
        if (sVNUrl == null & bl) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        return sVNUrl;
    }

    public static SVNUrl getRepositoryUrl(File file) throws SVNClientException {
        StringBuffer stringBuffer = new StringBuffer();
        SVNUrl sVNUrl = null;
        SvnClient svnClient = null;
        try {
            svnClient = Subversion.getInstance().getClient(false);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        boolean bl = false;
        while (Subversion.getInstance().isManaged(file)) {
            ISVNStatus iSVNStatus;
            block11: {
                block10: {
                    bl = true;
                    try {
                        iSVNStatus = SvnUtils.getSingleStatus(svnClient, file);
                        if (iSVNStatus != null && (sVNUrl = SvnUtils.decode(iSVNStatus.getUrl())) != null) {
                            break;
                        }
                    }
                    catch (SVNClientException sVNClientException) {
                        if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block10;
                        SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                    }
                }
                iSVNStatus = null;
                try {
                    iSVNStatus = svnClient.getInfoFromWorkingCopy(file);
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isUnversionedResource(sVNClientException.getMessage())) break block11;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
            }
            if (iSVNStatus != null && (sVNUrl = SvnUtils.decode(iSVNStatus.getUrl())) != null) break;
            stringBuffer.insert(0, file.getName()).insert(0, "/");
            file = file.getParentFile();
        }
        if (sVNUrl == null & bl) {
            throw new SVNClientException(NbBundle.getMessage(SvnUtils.class, (String)"MSG_too_old_WC"));
        }
        if (stringBuffer.length() > 0) {
            sVNUrl = sVNUrl.appendPath(stringBuffer.toString());
        }
        return sVNUrl;
    }

    private static ISVNStatus getSingleStatus(SvnClient svnClient, File file) throws SVNClientException {
        return svnClient.getSingleStatus(file);
    }

    private static SVNUrl decode(SVNUrl sVNUrl) {
        if (sVNUrl == null) {
            return null;
        }
        String string = sVNUrl.toString();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n == 63) {
                bl = true;
            } else if (n == 43 && bl) {
                n = 32;
            } else if (n == 37 && i + 2 < string.length() && SvnUtils.isHexDigit(string.charAt(i + 1)) && SvnUtils.isHexDigit(string.charAt(i + 2))) {
                n = (char)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                i += 2;
            }
            stringBuffer.append((char)n);
        }
        try {
            return new SVNUrl(stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static String getRepositoryPath(File file) throws SVNClientException {
        SVNUrl sVNUrl = SvnUtils.getRepositoryUrl(file);
        SVNUrl sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
        return SVNUrlUtils.getRelativePath((SVNUrl)sVNUrl2, (SVNUrl)sVNUrl, (boolean)true);
    }

    public static boolean isFileContentBinary(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return false;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject.getCookie(EditorCookie.class) == null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean isBinary(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 32 || by == 9 || by == 10 || by == 13) continue;
            return true;
        }
        return false;
    }

    public static File[] flatten(File[] fileArray, int n) {
        LinkedList<File> linkedList = new LinkedList<File>();
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if ((n & fileInformation.getStatus()) != 0) {
                linkedList.add(file);
            }
            File[] fileArray2 = fileStatusCache.listFiles(file);
            for (int j = 0; j < fileArray2.length; ++j) {
                File file2 = fileArray2[j];
                fileInformation = fileStatusCache.getStatus(file2);
                if ((n & fileInformation.getStatus()) == 0) continue;
                linkedList.add(file2);
            }
        }
        return linkedList.toArray(new File[linkedList.size()]);
    }

    public static File[] getModifiedFiles(Context context, int n) {
        File[] fileArray;
        File[] fileArray2 = Subversion.getInstance().getStatusCache().listFiles(context, n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < fileArray2.length; ++i) {
            fileArray = fileArray2[i];
            String string = fileArray.getAbsolutePath();
            if (SvnModuleConfig.getDefault().isExcludedFromCommit(string)) continue;
            arrayList.add(fileArray);
        }
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        fileArray = context.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.isFile() || (fileStatusCache.getStatus(file).getStatus() & n) == 0 || arrayList.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static boolean isPartOfSubversionMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static int getComparableStatus(int n) {
        if (0 != (n & 0x40)) {
            return 0;
        }
        if (0 != (n & 0x80)) {
            return 1;
        }
        if (0 != (n & 0x800)) {
            return 10;
        }
        if (0 != (n & 0x100)) {
            return 11;
        }
        if (0 != (n & 4)) {
            return 12;
        }
        if (0 != (n & 0x1000)) {
            return 13;
        }
        if (0 != (n & 0x10)) {
            return 14;
        }
        if (0 != (n & 0x400)) {
            return 30;
        }
        if (0 != (n & 0x200)) {
            return 31;
        }
        if (0 != (n & 0x20)) {
            return 32;
        }
        if (0 != (n & 8)) {
            return 50;
        }
        if (0 != (n & 2)) {
            return 100;
        }
        if (0 != (n & 1)) {
            return 101;
        }
        if (n == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    public static String getCopy(File file) {
        return SvnUtils.getCopy(file, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    private static String getCopy(File file, List<AnnotationExpression> list) {
        SVNUrl sVNUrl;
        try {
            sVNUrl = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            return null;
        }
        return SvnUtils.getCopy(sVNUrl, list);
    }

    public static String getCopy(SVNUrl sVNUrl) {
        return SvnUtils.getCopy(sVNUrl, SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    public static String getCopy(SVNUrl sVNUrl, List<AnnotationExpression> list) {
        if (sVNUrl != null) {
            for (AnnotationExpression annotationExpression : list) {
                int n;
                Matcher matcher = annotationExpression.getUrlPatern().matcher(sVNUrl.toString());
                if (!matcher.matches()) continue;
                String string = annotationExpression.getAnnotationExp();
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl = false;
                for (n = 0; n < string.length(); ++n) {
                    char c = string.charAt(n);
                    if (c == '\\') {
                        bl = true;
                        continue;
                    }
                    if (bl) {
                        if (Character.isDigit(c)) {
                            stringBuffer2.append(c);
                            continue;
                        }
                        if (stringBuffer2.length() > 0) {
                            int n2 = Integer.valueOf(stringBuffer2.toString());
                            stringBuffer.append(matcher.group(n2));
                            stringBuffer2 = new StringBuffer();
                        } else {
                            stringBuffer.append('\\');
                            stringBuffer.append(c);
                        }
                        bl = false;
                        continue;
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer2.length() > 0) {
                    n = Integer.valueOf(stringBuffer2.toString());
                    stringBuffer.append(matcher.group(n));
                }
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public static void refreshRecursively(File file) {
        if (file == null) {
            return;
        }
        SvnUtils.refreshRecursively(file.getParentFile());
        Subversion.getInstance().getStatusCache().refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
    }

    public static String ripUserFromHost(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static SVNRevision getSVNRevision(String string) {
        try {
            return SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            return new SVNRevision.Number(Long.parseLong(string));
        }
    }

    public static List<String> getMatchinIgnoreParterns(List<String> list, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                String string2 = iterator.next();
                String string3 = SvnUtils.regExpToFilePatterns(string2);
                Pattern pattern = Pattern.compile(string3);
                if (!pattern.matcher(string).matches()) continue;
                arrayList.add(string2);
                if (!bl) continue;
                return arrayList;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ErrorManager.getDefault().notify(1, (Throwable)patternSyntaxException);
            }
        }
        return arrayList;
    }

    private static String regExpToFilePatterns(String string) {
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*");
        string = string.replaceAll("\\?", ".");
        string = string.replaceAll("\\$", "\\\\\\$");
        string = string.replaceAll("\\^", "\\\\^");
        string = string.replaceAll("\\<", "\\\\<");
        string = string.replaceAll("\\>", "\\\\>");
        string = string.replaceAll("\\[", "\\\\[");
        string = string.replaceAll("\\]", "\\\\]");
        string = string.replaceAll("\\{", "\\\\{");
        string = string.replaceAll("\\}", "\\\\}");
        string = string.replaceAll("\\(", "\\\\(");
        string = string.replaceAll("\\)", "\\\\)");
        string = string.replaceAll("\\+", "\\\\+");
        string = string.replaceAll("\\|", "\\\\|");
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation fileInformation, FileInformation fileInformation2) {
            return SvnUtils.getComparableStatus(fileInformation.getStatus()) - SvnUtils.getComparableStatus(fileInformation2.getStatus());
        }
    }
}

