/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ColoringStorage {
    private static final Logger LOG = Logger.getLogger(ColoringStorage.class.getName());
    static final String ALL_LANGUAGES_FILE_NAME = "defaultColoring.xml";
    static final String COLORING_FILE_NAME = "coloring.xml";
    static final String HIGHLIGHTING_FILE_NAME = "editorColoring.xml";
    static final String DEFAULTS_FOLDER = "Defaults";
    private static final String E_ROOT = "fontscolors";
    private static final String E_FONTCOLOR = "fontcolor";
    private static final String E_FONT = "font";
    private static final String A_NAME = "name";
    private static final String A_FOREGROUND = "foreColor";
    private static final String A_BACKGROUND = "bgColor";
    private static final String A_STRIKETHROUGH = "strikeThrough";
    private static final String A_WAVEUNDERLINE = "waveUnderlined";
    private static final String A_UNDERLINE = "underline";
    private static final String A_DEFAULT = "default";
    private static final String A_SIZE = "size";
    private static final String A_STYLE = "style";
    private static final String V_BOLD_ITALIC = "bold+italic";
    private static final String V_BOLD = "bold";
    private static final String V_ITALIC = "italic";
    private static final String V_PLAIN = "plain";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Fonts and Colors settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorFontsColors-1_1.dtd";

    private ColoringStorage() {
    }

    public static Map<String, AttributeSet> loadColorings(MimePath mimePath, String string, boolean bl, boolean bl2) {
        String string2 = ColoringStorage.determineFileName(mimePath, bl);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = null;
        if (!bl2) {
            fileObject = fileSystem.findResource(Utils.getFileName(mimePath, string, string2));
        }
        if (fileObject == null) {
            fileObject = fileSystem.findResource(Utils.getFileName(mimePath, string, "Defaults/" + string2));
        }
        if (fileObject == null) {
            return null;
        }
        List list = (List)XMLStorage.load(fileObject, new ColoringsReader());
        FileObject fileObject2 = fileSystem.findResource(Utils.getFileName(mimePath, "NetBeans", "Defaults/" + string2));
        HashMap<String, AttributeSet> hashMap = new HashMap<String, AttributeSet>();
        for (SimpleAttributeSet simpleAttributeSet : list) {
            String string3 = (String)simpleAttributeSet.getAttribute(StyleConstants.NameAttribute);
            String string4 = Utils.getLocalizedName(fileObject2, string3, string3);
            simpleAttributeSet.addAttribute(EditorStyleConstants.DisplayName, string4);
            hashMap.put(string3, AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{simpleAttributeSet}));
        }
        return hashMap;
    }

    public static void deleteColorings(MimePath mimePath, String string, boolean bl, boolean bl2) {
        String string2 = ColoringStorage.determineFileName(mimePath, bl);
        if (bl2) {
            string2 = "Defaults/" + string2;
        }
        Utils.deleteFileObject(mimePath, string, string2);
    }

    public static void saveColorings(MimePath mimePath, String string, boolean bl, boolean bl2, Collection<AttributeSet> collection) {
        String string2 = ColoringStorage.determineFileName(mimePath, bl);
        if (bl2) {
            string2 = "Defaults/" + string2;
        }
        FileObject fileObject = Utils.createFileObject(mimePath, string, string2);
        ColoringStorage.saveColorings(fileObject, collection);
    }

    private static void saveColorings(FileObject fileObject, Collection<AttributeSet> collection) {
        Document document = XMLUtil.createDocument((String)E_ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Node node = document.getElementsByTagName(E_ROOT).item(0);
        for (AttributeSet attributeSet : collection) {
            Element element = document.createElement(E_FONTCOLOR);
            node.appendChild(element);
            element.setAttribute(A_NAME, (String)attributeSet.getAttribute(StyleConstants.NameAttribute));
            if (attributeSet.isDefined(StyleConstants.Foreground)) {
                element.setAttribute(A_FOREGROUND, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.Foreground)));
            }
            if (attributeSet.isDefined(StyleConstants.Background)) {
                element.setAttribute(A_BACKGROUND, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.Background)));
            }
            if (attributeSet.isDefined(StyleConstants.StrikeThrough)) {
                element.setAttribute(A_STRIKETHROUGH, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.StrikeThrough)));
            }
            if (attributeSet.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                element.setAttribute(A_WAVEUNDERLINE, Utils.colorToString((Color)attributeSet.getAttribute(EditorStyleConstants.WaveUnderlineColor)));
            }
            if (attributeSet.isDefined(StyleConstants.Underline)) {
                element.setAttribute(A_UNDERLINE, Utils.colorToString((Color)attributeSet.getAttribute(StyleConstants.Underline)));
            }
            if (attributeSet.isDefined(EditorStyleConstants.Default)) {
                element.setAttribute(A_DEFAULT, (String)attributeSet.getAttribute(EditorStyleConstants.Default));
            }
            if (!attributeSet.isDefined(StyleConstants.FontFamily) && !attributeSet.isDefined(StyleConstants.FontSize) && !attributeSet.isDefined(StyleConstants.Bold) && !attributeSet.isDefined(StyleConstants.Italic)) continue;
            Element element2 = document.createElement(E_FONT);
            element.appendChild(element2);
            if (attributeSet.isDefined(StyleConstants.FontFamily)) {
                element2.setAttribute(A_NAME, (String)attributeSet.getAttribute(StyleConstants.FontFamily));
            }
            if (attributeSet.isDefined(StyleConstants.FontSize)) {
                element2.setAttribute(A_SIZE, ((Integer)attributeSet.getAttribute(StyleConstants.FontSize)).toString());
            }
            if (!attributeSet.isDefined(StyleConstants.Bold) && !attributeSet.isDefined(StyleConstants.Italic)) continue;
            Boolean bl = Boolean.FALSE;
            Boolean bl2 = Boolean.FALSE;
            if (attributeSet.isDefined(StyleConstants.Bold)) {
                bl = (Boolean)attributeSet.getAttribute(StyleConstants.Bold);
            }
            if (attributeSet.isDefined(StyleConstants.Italic)) {
                bl2 = (Boolean)attributeSet.getAttribute(StyleConstants.Italic);
            }
            element2.setAttribute(A_STYLE, bl.booleanValue() ? (bl2.booleanValue() ? V_BOLD_ITALIC : V_BOLD) : (bl2 != false ? V_ITALIC : V_PLAIN));
        }
        XMLStorage.save(fileObject, document);
    }

    private static String determineFileName(MimePath mimePath, boolean bl) {
        String string = bl ? (mimePath.size() == 0 ? ALL_LANGUAGES_FILE_NAME : COLORING_FILE_NAME) : HIGHLIGHTING_FILE_NAME;
        return string;
    }

    private static class ColoringsReader
    extends XMLStorage.Handler {
        private List<AttributeSet> colorings = new ArrayList<AttributeSet>();

        private ColoringsReader() {
        }

        public Object getResult() {
            return this.colorings;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block14: {
                try {
                    if (string3.equals(ColoringStorage.E_ROOT)) break block14;
                    if (string3.equals(ColoringStorage.E_FONTCOLOR)) {
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, attributes.getValue(ColoringStorage.A_NAME));
                        String string4 = attributes.getValue(ColoringStorage.A_BACKGROUND);
                        if (string4 != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Background, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_FOREGROUND)) != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Foreground, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_UNDERLINE)) != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Underline, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_STRIKETHROUGH)) != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_WAVEUNDERLINE)) != null) {
                            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, Utils.stringToColor(string4));
                        }
                        if ((string4 = attributes.getValue(ColoringStorage.A_DEFAULT)) != null) {
                            simpleAttributeSet.addAttribute(EditorStyleConstants.Default, string4);
                        }
                        this.colorings.add(simpleAttributeSet);
                        break block14;
                    }
                    if (!string3.equals(ColoringStorage.E_FONT)) break block14;
                    SimpleAttributeSet simpleAttributeSet = (SimpleAttributeSet)this.colorings.get(this.colorings.size() - 1);
                    String string5 = attributes.getValue(ColoringStorage.A_NAME);
                    if (string5 != null) {
                        simpleAttributeSet.addAttribute(StyleConstants.FontFamily, string5);
                    }
                    if ((string5 = attributes.getValue(ColoringStorage.A_SIZE)) != null) {
                        try {
                            simpleAttributeSet.addAttribute(StyleConstants.FontSize, Integer.decode(string5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            LOG.log(Level.WARNING, string5 + " is not a valid Integer; parsing " + this.getProcessedFile().getPath(), numberFormatException);
                        }
                    }
                    if ((string5 = attributes.getValue(ColoringStorage.A_STYLE)) != null) {
                        simpleAttributeSet.addAttribute(StyleConstants.Bold, string5.indexOf(ColoringStorage.V_BOLD) >= 0);
                        simpleAttributeSet.addAttribute(StyleConstants.Italic, string5.indexOf(ColoringStorage.V_ITALIC) >= 0);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, "Can't parse colorings file " + this.getProcessedFile().getPath(), exception);
                }
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

