/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.settings.storage.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeFCS
extends FontColorSettings {
    private static final String DEFAULT = "default";
    private static final int DEFAULT_FONT_SIZE = UIManager.get("customFontSize") != null ? ((Integer)UIManager.get("customFontSize")).intValue() : UIManager.getFont("TextField.font").getSize();
    private static final AttributeSet HARDCODED_DEFAULT_COLORING = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.NameAttribute, "default", StyleConstants.Foreground, Color.black, StyleConstants.Background, Color.white, StyleConstants.FontFamily, "Monospaced", StyleConstants.FontSize, DEFAULT_FONT_SIZE < 12 ? 12 : DEFAULT_FONT_SIZE});
    private static final AttributeSet NULL = new SimpleAttributeSet();
    private final FontColorSettingsImpl[] allFcsi;
    final String profile;
    private final Map<String, AttributeSet> tokensCache = new HashMap<String, AttributeSet>();

    public CompositeFCS(MimePath[] mimePathArray, String string) {
        assert (mimePathArray != null) : "The parameter allPaths should not be null";
        assert (mimePathArray.length > 0) : "The parameter allPaths should always contain at least MimePath.EMPTY";
        assert (string != null) : "The parameter profile should not be null";
        this.allFcsi = new FontColorSettingsImpl[mimePathArray.length];
        for (int i = 0; i < mimePathArray.length; ++i) {
            this.allFcsi[i] = FontColorSettingsImpl.get(mimePathArray[i]);
        }
        this.profile = string;
    }

    public AttributeSet getFontColors(String string) {
        assert (string != null) : "The parameter highlightName must not be null.";
        if (string.equals(DEFAULT)) {
            return this.getTokenFontColors(DEFAULT);
        }
        AttributeSet attributeSet = null;
        Map<String, AttributeSet> map = EditorSettings.getDefault().getHighlightings(this.profile);
        if (map != null && (attributeSet = map.get(string)) == null) {
            attributeSet = NULL;
        }
        return attributeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeSet getTokenFontColors(String string) {
        assert (string != null) : "The parameter tokenName must not be null.";
        Map<String, AttributeSet> map = this.tokensCache;
        synchronized (map) {
            AttributeSet attributeSet = this.tokensCache.get(string);
            if (attributeSet == null) {
                attributeSet = this.findColoringForToken(string);
                this.tokensCache.put(string, attributeSet);
            }
            return attributeSet == NULL ? null : attributeSet;
        }
    }

    private AttributeSet findColoringForToken(String string) {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        String string2 = string;
        for (FontColorSettingsImpl fontColorSettingsImpl : this.allFcsi) {
            string2 = this.processLayer(fontColorSettingsImpl, string2, arrayList);
        }
        if (string.equals(DEFAULT)) {
            arrayList.add(HARDCODED_DEFAULT_COLORING);
        }
        if (arrayList.size() > 0) {
            return AttributesUtilities.createImmutable((AttributeSet[])arrayList.toArray(new AttributeSet[arrayList.size()]));
        }
        return NULL;
    }

    private String processLayer(FontColorSettingsImpl fontColorSettingsImpl, String string, ArrayList<AttributeSet> arrayList) {
        AttributeSet attributeSet = fontColorSettingsImpl.getColorings(this.profile).get(string);
        if (attributeSet == null) {
            attributeSet = fontColorSettingsImpl.getDefaultColorings(this.profile).get(string);
        }
        if (attributeSet != null) {
            arrayList.add(attributeSet);
            String string2 = (String)attributeSet.getAttribute(StyleConstants.NameAttribute);
            String string3 = (String)attributeSet.getAttribute(EditorStyleConstants.Default);
            if (string3 != null && !string3.equals(DEFAULT)) {
                if (!string3.equals(string2)) {
                    string3 = this.processLayer(fontColorSettingsImpl, string3, arrayList);
                }
            } else {
                string3 = string2;
            }
            string = string3;
        }
        return string;
    }

    private void dumpAttribs(AttributeSet attributeSet, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attribs for base mime path '");
        stringBuilder.append(this.allFcsi[0].getMimePath().getPath());
        stringBuilder.append("' and ");
        if (bl) {
            stringBuilder.append("token '");
        } else {
            stringBuilder.append("highlight '");
        }
        stringBuilder.append(string);
        stringBuilder.append("' = {");
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            stringBuilder.append("'" + obj + "' = '" + object + "'");
            if (!enumeration.hasMoreElements()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("} CompoundFCS.this = ");
        stringBuilder.append(((Object)((Object)this)).toString());
        System.out.println(stringBuilder.toString());
    }
}

