/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorSettingsImpl
extends EditorSettings {
    private static final Logger LOG = Logger.getLogger(EditorSettingsImpl.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String PROP_HIGHLIGHT_COLORINGS = "editorFontColors";
    public static final String PROP_TOKEN_COLORINGS = "fontColors";
    public static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_FONT_COLOR_PROFILE = "currentFontColorProfile";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    private static final String EDITORS_FOLDER = "Editors";
    private static final String KEYMAPS_FOLDER = "Keymaps";
    private static EditorSettingsImpl instance = null;
    private Set<String> systemFontColorProfiles;
    private String currentFontColorProfile;
    private Map<String, Map<String, AttributeSet>> highlightings = new HashMap<String, Map<String, AttributeSet>>();
    private Map<String, Map<String, AttributeSet>> highlightingDefaults = new HashMap<String, Map<String, AttributeSet>>();
    private Set<String> systemKeymapProfiles;
    private String currentKeyMapProfile;
    private Map<String, String> fontColorProfiles;
    private Map<String, String> keyMapProfiles;
    private Set<String> mimeTypesWithColoring;

    public static synchronized EditorSettingsImpl getInstance() {
        if (instance == null) {
            instance = new EditorSettingsImpl();
        }
        return instance;
    }

    @Override
    public Set<String> getAllMimeTypes() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(EDITORS_FOLDER);
        HashSet<String> hashSet = new HashSet<String>();
        if (fileObject != null) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.isFolder()) continue;
                String string = fileObject2.getNameExt();
                for (FileObject fileObject3 : fileObject2.getChildren()) {
                    if (!fileObject3.isFolder()) continue;
                    String string2 = string + "/" + fileObject3.getNameExt();
                    hashSet.add(string2);
                }
            }
        }
        return hashSet;
    }

    @Override
    public Set<String> getMimeTypes() {
        if (this.mimeTypesWithColoring == null) {
            this.init();
        }
        return this.mimeTypesWithColoring;
    }

    @Override
    public String getLanguageName(String string) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + string);
        return fileObject == null ? string : Utils.getLocalizedName(fileObject, string, string);
    }

    void notifyTokenFontColorChange(MimePath mimePath, String string) {
        this.pcs.firePropertyChange(PROP_TOKEN_COLORINGS, mimePath, string);
    }

    @Override
    public Set<String> getFontColorProfiles() {
        if (this.fontColorProfiles == null) {
            this.init();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.fontColorProfiles.keySet()) {
            if (string.startsWith("test")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean isCustomFontColorProfile(String string) {
        if (this.systemFontColorProfiles == null) {
            this.init();
        }
        return !this.systemFontColorProfiles.contains(string);
    }

    @Override
    public String getCurrentFontColorProfile() {
        if (this.currentFontColorProfile == null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(EDITORS_FOLDER);
            if (fileObject != null) {
                this.currentFontColorProfile = (String)fileObject.getAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE);
            }
            if (this.currentFontColorProfile == null) {
                this.currentFontColorProfile = DEFAULT_PROFILE;
            }
        }
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.currentFontColorProfile = DEFAULT_PROFILE;
        }
        return this.currentFontColorProfile;
    }

    @Override
    public void setCurrentFontColorProfile(String string) {
        String string2 = this.getCurrentFontColorProfile();
        if (string2.equals(string)) {
            return;
        }
        this.currentFontColorProfile = string;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(EDITORS_FOLDER);
        if (fileObject != null) {
            try {
                fileObject.setAttribute(FATTR_CURRENT_FONT_COLOR_PROFILE, (Object)string);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't persist change in current font&colors profile.", iOException);
            }
        }
        this.pcs.firePropertyChange(FATTR_CURRENT_FONT_COLOR_PROFILE, string2, this.currentFontColorProfile);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColors(String string) {
        return this.getFontColorSettings(new String[0]).getAllFontColors(string);
    }

    @Override
    public Collection<AttributeSet> getDefaultFontColorDefaults(String string) {
        return this.getFontColorSettings(new String[0]).getAllFontColorDefaults(string);
    }

    @Override
    public void setDefaultFontColors(String string, Collection<AttributeSet> collection) {
        this.getFontColorSettings(new String[0]).setAllFontColors(string, collection);
    }

    @Override
    public Map<String, AttributeSet> getHighlightings(String string) {
        if (!this.highlightings.containsKey(string = this.getInternalFontColorProfile(string))) {
            if (string.startsWith("test")) {
                this.highlightings.put(string, this.getHighlightings(DEFAULT_PROFILE));
            } else {
                Map<String, AttributeSet> map = ColoringStorage.loadColorings(MimePath.EMPTY, string, false, false);
                this.highlightings.put(string, map);
            }
        }
        if (this.highlightings.get(string) == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.highlightings.get(string));
    }

    @Override
    public Map<String, AttributeSet> getHighlightingDefaults(String string) {
        if (!this.highlightingDefaults.containsKey(string = this.getInternalFontColorProfile(string))) {
            Map<String, AttributeSet> map = ColoringStorage.loadColorings(MimePath.EMPTY, string, false, true);
            this.highlightingDefaults.put(string, map);
        }
        if (this.highlightingDefaults.get(string) == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.highlightingDefaults.get(string));
    }

    @Override
    public void setHighlightings(String string, Map<String, AttributeSet> map) {
        String string2 = this.getInternalFontColorProfile(string);
        if (map == null) {
            ColoringStorage.deleteColorings(MimePath.EMPTY, string2, false, false);
            this.highlightings.remove(string2);
            this.init();
        } else {
            if (((Object)map).equals(this.highlightings.get(string2))) {
                return;
            }
            map = Utils.immutize(map);
            this.highlightings.put(string2, map);
            if (!string2.startsWith("test")) {
                ColoringStorage.saveColorings(MimePath.EMPTY, string2, false, false, map.values());
                if (this.fontColorProfiles.get(string) == null) {
                    this.fontColorProfiles.put(string, string);
                }
            }
        }
        this.pcs.firePropertyChange(PROP_HIGHLIGHT_COLORINGS, MimePath.EMPTY, string2);
    }

    @Override
    public Set<String> getKeyMapProfiles() {
        if (this.keyMapProfiles == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.keyMapProfiles.keySet());
    }

    @Override
    public boolean isCustomKeymapProfile(String string) {
        if (this.systemKeymapProfiles == null) {
            this.init();
        }
        return !this.systemKeymapProfiles.contains(string);
    }

    @Override
    public String getCurrentKeyMapProfile() {
        if (this.currentKeyMapProfile == null) {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(KEYMAPS_FOLDER);
            String string = this.currentKeyMapProfile = fileObject == null ? null : (String)fileObject.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE);
            if (this.currentKeyMapProfile == null) {
                this.currentKeyMapProfile = DEFAULT_PROFILE;
            }
        }
        return this.currentKeyMapProfile;
    }

    @Override
    public void setCurrentKeyMapProfile(String string) {
        String string2 = this.getCurrentKeyMapProfile();
        if (string2.equals(string)) {
            return;
        }
        this.currentKeyMapProfile = string;
        try {
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(KEYMAPS_FOLDER);
            if (fileObject == null) {
                fileObject = fileSystem.getRoot().createFolder(KEYMAPS_FOLDER);
            }
            fileObject.setAttribute(FATTR_CURRENT_KEYMAP_PROFILE, (Object)string);
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, "Can't persist change in current keybindings profile.", iOException);
        }
        this.pcs.firePropertyChange("currentKeyMapProfile", string2, this.currentKeyMapProfile);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private EditorSettingsImpl() {
    }

    private void init() {
        this.fontColorProfiles = new HashMap<String, String>();
        this.keyMapProfiles = new HashMap<String, String>();
        this.keyMapProfiles.put(DEFAULT_PROFILE, DEFAULT_PROFILE);
        this.mimeTypesWithColoring = new HashSet<String>();
        this.systemFontColorProfiles = new HashSet<String>();
        this.systemKeymapProfiles = new HashSet<String>();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(EDITORS_FOLDER);
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                this.init1((FileObject)enumeration.nextElement());
            }
        }
        this.mimeTypesWithColoring = Collections.unmodifiableSet(this.mimeTypesWithColoring);
    }

    private void init1(FileObject fileObject) {
        Enumeration enumeration = fileObject.getChildren(false);
        while (enumeration.hasMoreElements()) {
            this.init2((FileObject)enumeration.nextElement());
        }
    }

    private void init2(FileObject fileObject) {
        if (fileObject.getNameExt().equals("Defaults") && fileObject.isFolder() && fileObject.getFileObject("editorColoring.xml") != null) {
            this.addFontColorsProfile(fileObject, true);
        } else if (fileObject.getNameExt().equals("editorColoring.xml")) {
            this.addFontColorsProfile(fileObject, false);
        } else if (fileObject.getFileObject("NetBeans/Defaults/coloring.xml") != null) {
            this.addMimeType(fileObject);
        } else if (fileObject.getPath().endsWith("text/base") && fileObject.isFolder()) {
            if (fileObject.getFileObject("Defaults/keybindings.xml") != null) {
                this.addKeyMapProfile(fileObject, true);
            } else if (fileObject.getFileObject("keybindings.xml") != null) {
                this.addKeyMapProfile(fileObject, false);
            }
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.getNameExt().equals("Defaults")) continue;
                this.init3(fileObject2);
            }
        }
    }

    private void init3(FileObject fileObject) {
        if (fileObject.getFileObject("Defaults/keybindings.xml") != null) {
            this.addKeyMapProfile(fileObject, true);
        } else if (fileObject.getFileObject("keybindings.xml") != null) {
            this.addKeyMapProfile(fileObject, false);
        }
    }

    private void addMimeType(FileObject fileObject) {
        String string = fileObject.getPath().substring(8);
        this.mimeTypesWithColoring.add(string);
    }

    private void addFontColorsProfile(FileObject fileObject, boolean bl) {
        String string = fileObject.getParent().getNameExt();
        String string2 = Utils.getLocalizedName(fileObject.getParent(), string, string);
        if (bl) {
            this.systemFontColorProfiles.add(string2);
        }
        this.fontColorProfiles.put(string2, string);
    }

    private void addKeyMapProfile(FileObject fileObject, boolean bl) {
        String string = fileObject.getNameExt();
        if (string.equals("base")) {
            string = DEFAULT_PROFILE;
        }
        String string2 = Utils.getLocalizedName(fileObject, string, string);
        if (bl) {
            this.systemKeymapProfiles.add(string2);
        }
        this.keyMapProfiles.put(string2, string);
    }

    String getInternalFontColorProfile(String string) {
        String string2;
        if (this.fontColorProfiles == null) {
            this.init();
        }
        return (string2 = this.fontColorProfiles.get(string)) != null ? string2 : string;
    }

    String getInternalKeymapProfile(String string) {
        String string2;
        if (this.keyMapProfiles == null) {
            this.init();
        }
        if ((string2 = this.keyMapProfiles.get(string)) != null) {
            return string2;
        }
        this.keyMapProfiles.put(string, string);
        return string;
    }

    @Override
    public KeyBindingSettingsFactory getKeyBindingSettings(String[] stringArray) {
        stringArray = this.filter(stringArray);
        return KeyBindingSettingsImpl.get(Utils.mimeTypes2mimePath(stringArray));
    }

    @Override
    public FontColorSettingsFactory getFontColorSettings(String[] stringArray) {
        stringArray = this.filter(stringArray);
        return FontColorSettingsImpl.get(Utils.mimeTypes2mimePath(stringArray));
    }

    private String[] filter(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].startsWith("test")) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[0] = stringArray[0].substring(stringArray[0].indexOf(95) + 1);
            LOG.log(Level.INFO, "Don't use 'test' mime type to access settings through the editor/settings/storage API!", new Throwable("Stacktrace"));
            return stringArray2;
        }
        return stringArray;
    }
}

