/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.XMLStorage;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyMapsStorage {
    private static final Logger LOG = Logger.getLogger(KeyMapsStorage.class.getName());
    static final String KEYBINDING_FILE_NAME = "keybindings.xml";
    static final String DEFAULTS_FOLDER = "Defaults";
    private static final String ROOT = "bindings";
    private static final String E_BIND = "bind";
    private static final String A_ACTION_NAME = "actionName";
    private static final String A_KEY = "key";
    private static final String A_REMOVE = "remove";
    private static final String V_TRUE = "true";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor KeyBindings settings 1.1//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorKeyBindings-1_1.dtd";

    private KeyMapsStorage() {
    }

    public static Object[] loadKeyMaps(MimePath mimePath, String string, boolean bl) {
        String string2;
        FileObject fileObject;
        if (string.equals("NetBeans")) {
            string = null;
        }
        if ((fileObject = Utils.getFileObject(mimePath, string, string2 = bl ? "Defaults/keybindings.xml" : KEYBINDING_FILE_NAME)) == null) {
            return new Object[]{Collections.emptyMap(), Collections.emptySet()};
        }
        return (Object[])XMLStorage.load(fileObject, new KeyMapsReader());
    }

    public static void deleteProfile(MimePath mimePath, String string, boolean bl) {
        if (string.equals("NetBeans")) {
            string = null;
        }
        String string2 = bl ? "Defaults/keybindings.xml" : KEYBINDING_FILE_NAME;
        Utils.deleteFileObject(mimePath, string, string2);
    }

    public static void saveKeyMaps(MimePath mimePath, String string, boolean bl, Collection<MultiKeyBinding> collection, Set<Collection<KeyStroke>> set) {
        if (string.equals("NetBeans")) {
            string = null;
        }
        String string2 = bl ? "Defaults/keybindings.xml" : KEYBINDING_FILE_NAME;
        FileObject fileObject = Utils.createFileObject(mimePath, string, string2);
        KeyMapsStorage.saveKeyMaps(fileObject, collection, set);
    }

    private static void saveKeyMaps(FileObject fileObject, Collection<MultiKeyBinding> collection, Set<Collection<KeyStroke>> set) {
        Object object;
        Document document = XMLUtil.createDocument((String)ROOT, null, (String)PUBLIC_ID, (String)SYSTEM_ID);
        Node node = document.getElementsByTagName(ROOT).item(0);
        for (MultiKeyBinding object2 : collection) {
            object = document.createElement(E_BIND);
            node.appendChild((Node)object);
            object.setAttribute(A_ACTION_NAME, object2.getActionName());
            object.setAttribute(A_KEY, Utils.keyStrokesToString(object2.getKeyStrokeList()));
        }
        for (Collection collection2 : set) {
            object = Utils.keyStrokesToString(collection2);
            Element element = document.createElement(E_BIND);
            node.appendChild(element);
            element.setAttribute(A_KEY, (String)object);
            element.setAttribute(A_REMOVE, V_TRUE);
        }
        XMLStorage.save(fileObject, document);
    }

    private static class KeyMapsReader
    extends XMLStorage.Handler {
        private Map<Collection<KeyStroke>, MultiKeyBinding> keyMap = new HashMap<Collection<KeyStroke>, MultiKeyBinding>();
        private Set<Collection<KeyStroke>> removedShortcuts = new HashSet<Collection<KeyStroke>>();

        private KeyMapsReader() {
        }

        public Object getResult() {
            return new Object[]{this.keyMap, this.removedShortcuts};
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (!string3.equals(KeyMapsStorage.ROOT) && string3.equals(KeyMapsStorage.E_BIND)) {
                    int n;
                    String string4 = attributes.getValue(KeyMapsStorage.A_ACTION_NAME);
                    String string5 = attributes.getValue(KeyMapsStorage.A_KEY);
                    if (!Utilities.isMac() && this.isModuleFile() && string5 != null && string5.length() > 0 && (n = string5.indexOf(45)) != -1 && (string5.charAt(0) == 'A' || string5.charAt(0) == 'C')) {
                        LOG.warning("The keybinding '" + string5 + "' for action '" + string4 + "' in " + this.getProcessedFile().getPath() + " may not work correctly on Mac. " + "Keybindings starting with Alt or Ctrl should " + "be coded with latin capital letters 'O' " + "or 'D' respectively. For details see org.openide.util.Utilities.stringToKey().");
                    }
                    KeyStroke[] keyStrokeArray = Utils.stringToKeyStrokes(string5);
                    String string6 = attributes.getValue(KeyMapsStorage.A_REMOVE);
                    if (Boolean.valueOf(string6).booleanValue()) {
                        this.removedShortcuts.add(Arrays.asList(keyStrokeArray));
                    } else {
                        MultiKeyBinding multiKeyBinding = new MultiKeyBinding(keyStrokeArray, string4);
                        this.keyMap.put(Arrays.asList(keyStrokeArray), multiKeyBinding);
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't parse keybindings file " + this.getProcessedFile().getPath(), exception);
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

