/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.docscan.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

class Choosers {
    public static Node icons = null;

    Choosers() {
    }

    public static Node projectView() {
        Children.SortedArray sortedArray = new Children.SortedArray();
        sortedArray.setComparator(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Node)object).getDisplayName().compareToIgnoreCase(((Node)object2).getDisplayName());
            }
        });
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            Project project = projectArray[i];
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            if (sourceGroupArray.length == 0) continue;
            if (sourceGroupArray.length > 1) {
                sortedArray.add(new Node[]{new ProjectNode(project)});
                continue;
            }
            FileObject fileObject = sourceGroupArray[0].getRootFolder();
            if (!fileObject.isFolder()) continue;
            sortedArray.add(new Node[]{new FolderNode(fileObject, sourceGroupArray[0])});
            Choosers.prepareFolderIcons(fileObject);
        }
        AbstractNode abstractNode = new AbstractNode((Children)sortedArray){

            public void setName(String string) {
                super.setName(string);
                super.setIconBase("org/netbeans/modules/tasklist/docscan/repository");
            }
        };
        abstractNode.setName(Util.getString("projects"));
        return abstractNode;
    }

    private static void prepareFolderIcons(FileObject fileObject) {
        if (icons == null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                icons = dataObject.getNodeDelegate();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static class FolderNode
    extends AbstractNode {
        private final FileObject fileObject;
        private SourceGroup group;

        public FolderNode(FileObject fileObject, SourceGroup sourceGroup) {
            super((Children)new FolderContent(fileObject, sourceGroup), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
            this.group = sourceGroup;
        }

        public FolderNode(FileObject fileObject) {
            super((Children)new FolderContent(fileObject), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            return this.fileObject.getName();
        }

        public Image getIcon(int n) {
            Icon icon;
            if (this.group != null && (icon = this.group.getIcon(false)) != null) {
                return Utilities.icon2Image((Icon)icon);
            }
            if (icons != null) {
                return icons.getIcon(n);
            }
            return super.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            Icon icon;
            if (this.group != null && (icon = this.group.getIcon(true)) != null) {
                return Utilities.icon2Image((Icon)icon);
            }
            if (icons != null) {
                return icons.getOpenedIcon(n);
            }
            return super.getOpenedIcon(n);
        }

        private static class FolderContent
        extends Children.Keys {
            private final FileObject fileObject;
            private final SourceGroup group;

            public FolderContent(FileObject fileObject) {
                this(fileObject, null);
            }

            public FolderContent(FileObject fileObject, SourceGroup sourceGroup) {
                this.fileObject = fileObject;
                this.group = sourceGroup;
            }

            protected void addNotify() {
                FileObject[] fileObjectArray = this.fileObject.getChildren();
                Arrays.sort(fileObjectArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        return ((FileObject)object).getNameExt().compareToIgnoreCase(((FileObject)object2).getNameExt());
                    }
                });
                this.setKeys(Arrays.asList(fileObjectArray));
            }

            protected void removeNotify() {
                this.setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object object) {
                FileObject fileObject = (FileObject)object;
                if (fileObject.isFolder() && (this.group == null || this.group.contains(fileObject))) {
                    return new Node[]{new FolderNode(fileObject)};
                }
                return new Node[0];
            }
        }
    }

    public static class ProjectNode
    extends AbstractNode {
        private final Project project;

        public ProjectNode(Project project) {
            this(new Children.SortedArray(), project);
        }

        private ProjectNode(Children.SortedArray sortedArray, Project project) {
            super((Children)sortedArray);
            this.project = project;
            sortedArray.setComparator(new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Node)object).getDisplayName().compareToIgnoreCase(((Node)object2).getDisplayName());
                }
            });
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            Arrays.sort(sourceGroupArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((SourceGroup)object).getDisplayName().compareToIgnoreCase(((SourceGroup)object2).getDisplayName());
                }
            });
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                FileObject fileObject = sourceGroupArray[i].getRootFolder();
                if (!fileObject.isFolder()) continue;
                sortedArray.add(new Node[]{new FolderNode(fileObject, sourceGroupArray[i])});
                Choosers.prepareFolderIcons(fileObject);
            }
        }

        public String getDisplayName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public Image getIcon(int n) {
            return Utilities.icon2Image((Icon)ProjectUtils.getInformation((Project)this.project).getIcon());
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }
    }
}

