/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.docscan.SourceTaskProvider;

final class FilteredTasksList
implements ObservableList {
    private final TaskList peer;
    private List listeners = new ArrayList(1);
    private List tasks = new LinkedList();
    private EventHandler handler;
    private boolean silent = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FilteredTasksList(TaskList taskList) {
        this.peer = taskList;
    }

    public List getTasks() {
        return this.tasks;
    }

    public synchronized void addTaskListener(TaskListener taskListener) {
        if (!$assertionsDisabled && taskListener == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.listeners.contains(taskListener)) {
            throw new AssertionError();
        }
        ArrayList<TaskListener> arrayList = new ArrayList<TaskListener>(this.listeners);
        arrayList.add(taskListener);
        if (arrayList.size() == 1) {
            this.handler = new EventHandler();
            this.peer.addTaskListener((TaskListener)this.handler);
        }
        this.listeners = arrayList;
    }

    public synchronized void removeTaskListener(TaskListener taskListener) {
        ArrayList arrayList = new ArrayList(this.listeners);
        arrayList.remove(taskListener);
        if (arrayList.size() == 0) {
            this.peer.removeTaskListener((TaskListener)this.handler);
            this.handler = null;
        }
        this.listeners = arrayList;
    }

    synchronized void byebye() {
        if (this.listeners.size() > 0) {
            // empty if block
        }
        this.listeners.clear();
        this.peer.removeTaskListener((TaskListener)this.handler);
        this.handler = null;
    }

    private void fireStructureChanged(Task task) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            TaskListener taskListener = (TaskListener)iterator.next();
            taskListener.structureChanged(task);
        }
    }

    private void refreshSnapshot() {
        this.tasks.clear();
        this.loadSourceTasks(this.peer.getTasks());
    }

    private void loadSourceTasks(List list) {
        if (list.size() == 0) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.getSeed() instanceof SourceTaskProvider) {
                list.add(task);
                continue;
            }
            if (!task.hasSubtasks()) continue;
            this.loadSourceTasks(task.getSubtasks());
        }
    }

    static {
        $assertionsDisabled = !FilteredTasksList.class.desiredAssertionStatus();
    }

    private class EventHandler
    implements TaskListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        private EventHandler() {
        }

        public void selectedTask(Task task) {
            if (FilteredTasksList.this.getTasks().contains(task)) {
                Iterator iterator = FilteredTasksList.this.listeners.iterator();
                while (iterator.hasNext()) {
                    TaskListener taskListener = (TaskListener)iterator.next();
                    taskListener.selectedTask(task);
                }
            }
        }

        public void warpedTask(Task task) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Not implemented");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addedTask(Task task) {
            block7: {
                block6: {
                    if (!(task.getSeed() instanceof SourceTaskProvider)) break block6;
                    try {
                        FilteredTasksList.this.silent = true;
                        FilteredTasksList.this.tasks.add(task);
                    }
                    finally {
                        FilteredTasksList.this.silent = false;
                    }
                    Iterator iterator = FilteredTasksList.this.listeners.iterator();
                    while (iterator.hasNext()) {
                        TaskListener taskListener = (TaskListener)iterator.next();
                        taskListener.addedTask(task);
                    }
                    break block7;
                }
                if (!task.hasSubtasks()) break block7;
                Iterator iterator = task.subtasksIterator();
                while (iterator.hasNext()) {
                    Task task2 = (Task)iterator.next();
                    this.addedTask(task2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedTask(Task task, Task task2, int n) {
            block8: {
                block7: {
                    if (!(task2.getSeed() instanceof SourceTaskProvider)) break block7;
                    boolean bl = false;
                    try {
                        FilteredTasksList.this.silent = true;
                        bl = FilteredTasksList.this.tasks.remove(task2);
                    }
                    finally {
                        FilteredTasksList.this.silent = false;
                    }
                    if (!bl) break block8;
                    Iterator iterator = FilteredTasksList.this.listeners.iterator();
                    while (iterator.hasNext()) {
                        TaskListener taskListener = (TaskListener)iterator.next();
                        taskListener.removedTask(null, task2, n);
                    }
                    break block8;
                }
                if (task2.hasSubtasks()) {
                    Iterator iterator = task2.subtasksIterator();
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        Task task3 = (Task)iterator.next();
                        this.removedTask(null, task3, n2++);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void structureChanged(Task task) {
            try {
                FilteredTasksList.this.silent = true;
                FilteredTasksList.this.refreshSnapshot();
            }
            finally {
                FilteredTasksList.this.silent = false;
            }
            FilteredTasksList.this.fireStructureChanged(task);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$tasklist$docscan$FilteredTasksList == null ? (class$org$netbeans$modules$tasklist$docscan$FilteredTasksList = FilteredTasksList.class$("org.netbeans.modules.tasklist.docscan.FilteredTasksList")) : class$org$netbeans$modules$tasklist$docscan$FilteredTasksList).desiredAssertionStatus();
        }
    }
}

