/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.docscan.TaskTag;
import org.netbeans.modules.tasklist.docscan.TaskTags;
import org.openide.nodes.BeanNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class Settings {
    private static final Settings INSTANCE = new Settings();
    public static final String PROP_SCAN_SKIP = "skipComments";
    public static final String PROP_SCAN_TAGS = "taskTags";
    static final String PROP_MODIFICATION_TIME = "modificationTime";
    public static final String PROP_USABILITY_LIMIT = "usabilityLimit";
    private static final int DEFAULT_USABILITY_LIMIT = 300;
    private TaskTags tags = null;

    private Settings() {
    }

    public static Settings getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule((Class)Settings.class);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)Settings.class, (String)"OPTION_TASK_SETTINGS_NAME");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Settings.class);
    }

    public boolean getSkipComments() {
        return Settings.getPreferences().getBoolean(PROP_SCAN_SKIP, false);
    }

    public void setSkipComments(boolean bl) {
        Settings.getPreferences().putBoolean(PROP_SCAN_SKIP, bl);
        this.modified();
    }

    public void setUsabilityLimit(int n) {
        if (n > 1000) {
            n = 1000;
        }
        if (n <= 0) {
            n = 300;
        }
        Settings.getPreferences().putInt(PROP_USABILITY_LIMIT, n);
    }

    public int getUsabilityLimit() {
        return Settings.getPreferences().getInt(PROP_USABILITY_LIMIT, 300);
    }

    public TaskTags getTaskTags() {
        if (this.tags == null) {
            this.tags = Settings.initTaskTags();
        }
        return this.tags;
    }

    public void setTaskTags(TaskTags taskTags) {
        this.tags = taskTags;
        Settings.storeTaskTags(taskTags);
        this.modified();
    }

    private static TaskTags initTaskTags() {
        TaskTags taskTags = new TaskTags();
        try {
            Preferences preferences = Settings.getPreferences();
            String[] stringArray = preferences.keys();
            ArrayList<TaskTag> arrayList = new ArrayList<TaskTag>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null || !string.startsWith("Tag")) continue;
                arrayList.add(new TaskTag(string.substring("Tag".length()), SuggestionPriority.getPriority((int)preferences.getInt(string, 3))));
            }
            taskTags.setTags(arrayList.toArray(new TaskTag[arrayList.size()]));
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(Settings.class.getName()).log(Level.INFO, null, backingStoreException);
        }
        if (taskTags.getTags().length == 0) {
            taskTags.setTags(new TaskTag[]{new TaskTag("@todo", SuggestionPriority.MEDIUM), new TaskTag("TODO", SuggestionPriority.MEDIUM), new TaskTag("FIXME", SuggestionPriority.MEDIUM), new TaskTag("XXX", SuggestionPriority.MEDIUM), new TaskTag("PENDING", SuggestionPriority.MEDIUM), new TaskTag("<<<<<<<", SuggestionPriority.HIGH)});
        }
        return taskTags;
    }

    private static void storeTaskTags(TaskTags taskTags) {
        Settings.removeTaskTags();
        Preferences preferences = Settings.getPreferences();
        TaskTag[] taskTagArray = taskTags.getTags();
        for (int i = 0; i < taskTagArray.length; ++i) {
            TaskTag taskTag = taskTagArray[i];
            Settings.getPreferences().putInt("Tag" + taskTag.getToken(), taskTag.getPriority().intValue());
        }
    }

    private static void removeTaskTags() {
        Preferences preferences = Settings.getPreferences();
        try {
            String[] stringArray = preferences.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null || !string.startsWith("Tag")) continue;
                Settings.getPreferences().remove(string);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(Settings.class.getName()).log(Level.INFO, null, backingStoreException);
        }
    }

    public long getModificationTime() {
        return Settings.getPreferences().getLong(PROP_MODIFICATION_TIME, 0L);
    }

    public void setModificationTime(long l) {
        Settings.getPreferences().putLong(PROP_MODIFICATION_TIME, l);
    }

    private void modified() {
        Settings.getPreferences().putLong(PROP_MODIFICATION_TIME, System.currentTimeMillis());
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)Settings.getDefault());
    }
}

