/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.tasklist.core.Background;
import org.netbeans.modules.tasklist.core.CancellableRunnable;
import org.netbeans.modules.tasklist.docscan.Settings;
import org.netbeans.modules.tasklist.docscan.SourceTasksAction;
import org.netbeans.modules.tasklist.docscan.SourceTasksProviderAcceptor;
import org.netbeans.modules.tasklist.docscan.SourceTasksView;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionsScanner;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Utilities;

final class SourceTasksScanner {
    SourceTasksScanner() {
    }

    public static Background scanTasksAsync(SourceTasksView sourceTasksView) {
        SuggestionList suggestionList = (SuggestionList)sourceTasksView.getList();
        Bg bg = new Bg(sourceTasksView, suggestionList, null);
        return Background.execute((Runnable)((Object)bg));
    }

    public static Background scanTasksAsync(SourceTasksView sourceTasksView, DataObject.Container[] containerArray) {
        SuggestionList suggestionList = (SuggestionList)sourceTasksView.getList();
        Bg bg = new Bg(sourceTasksView, suggestionList, containerArray);
        return Background.execute((Runnable)((Object)bg));
    }

    static void scanProjectSuggestions(SuggestionList suggestionList, SourceTasksAction.ScanProgressMonitor scanProgressMonitor, Bg bg) {
        Object object;
        DataObject.Container[] containerArray = bg.ctx;
        if (containerArray == null) {
            object = new ArrayList(23);
            boolean bl = false;
            if ("project".equals(System.getProperty("todos.project", "repository"))) {
                bl = SourceTasksScanner.project((List)object);
            }
            if (!bl) {
                object.clear();
                SourceTasksScanner.repository((List)object);
            }
            containerArray = new DataObject.Container[object.size()];
            object.toArray(containerArray);
        }
        object = SuggestionsScanner.getDefault();
        object.setUsabilityLimit(Settings.getDefault().getUsabilityLimit());
        bg.cancellable = (Cancellable)object;
        object.scan(containerArray, suggestionList, (SuggestionsScanner.ScanProgress)scanProgressMonitor, (ProviderAcceptor)new SourceTasksProviderAcceptor());
    }

    static void repository(List list) {
        Repository repository = Repository.getDefault();
        Enumeration enumeration = repository.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            if (fileSystem.isDefault() || fileSystem.isHidden() || fileSystem.isReadOnly() || !fileSystem.isValid()) continue;
            FileObject fileObject = fileSystem.getRoot();
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (!(dataObject instanceof DataObject.Container)) continue;
                list.add(dataObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                dataObjectNotFoundException.printStackTrace();
            }
        }
    }

    static boolean project(List list) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("Services/Hidden/org-netbeans-modules-projects-ProjectCookieImpl.instance");
        if (fileObject == null) {
            return false;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            Object object = instanceCookie.instanceCreate();
            Method method = object.getClass().getMethod("projectDesktop", new Class[0]);
            Node node = (Node)method.invoke(object, new Object[0]);
            DataObject dataObject2 = (DataObject)node.getCookie(DataObject.class);
            if (dataObject2 instanceof DataObject.Container) {
                DataObject[] dataObjectArray = ((DataObject.Container)dataObject2).getChildren();
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    if (!(dataObjectArray[i] instanceof DataObject.Container)) continue;
                    list.add(dataObjectArray[i]);
                }
            }
            return true;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    static class Bg
    implements CancellableRunnable {
        private Cancellable cancellable;
        private final SourceTasksView view;
        private final SuggestionList list;
        private final DataObject.Container[] ctx;

        Bg(SourceTasksView sourceTasksView, SuggestionList suggestionList, DataObject.Container[] containerArray) {
            this.view = sourceTasksView;
            this.list = suggestionList;
            this.ctx = containerArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            Bg.this.view.setCursor(Utilities.createProgressCursor((Component)((Object)Bg.this.view)));
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
                SourceTasksScanner.scanProjectSuggestions(this.list, this.view, this);
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Bg.this.view.statistics(Bg.this.list.size());
                        Bg.this.view.setCursor(null);
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public boolean cancel() {
            if (this.cancellable != null) {
                return this.cancellable.cancel();
            }
            return false;
        }
    }
}

