/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.tasklist.core.Background;
import org.netbeans.modules.tasklist.core.ColumnProperty;
import org.netbeans.modules.tasklist.core.GoToTaskAction;
import org.netbeans.modules.tasklist.core.ObservableList;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskList;
import org.netbeans.modules.tasklist.core.TaskListNode;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.docscan.Cache;
import org.netbeans.modules.tasklist.docscan.Choosers;
import org.netbeans.modules.tasklist.docscan.FilterSourceTasksAction;
import org.netbeans.modules.tasklist.docscan.FilteredTasksList;
import org.netbeans.modules.tasklist.docscan.SourceTaskNode;
import org.netbeans.modules.tasklist.docscan.SourceTaskProperties;
import org.netbeans.modules.tasklist.docscan.SourceTasksAction;
import org.netbeans.modules.tasklist.docscan.SourceTasksFilter;
import org.netbeans.modules.tasklist.docscan.SourceTasksList;
import org.netbeans.modules.tasklist.docscan.SourceTasksProviderAcceptor;
import org.netbeans.modules.tasklist.docscan.SourceTasksScanner;
import org.netbeans.modules.tasklist.docscan.Util;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionView;
import org.netbeans.modules.tasklist.suggestions.SuggestionsBroker;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

final class SourceTasksView
extends TaskListView
implements SourceTasksAction.ScanProgressMonitor,
SuggestionView {
    private static final long serialVersionUID = 1L;
    static final String CATEGORY = "sourcetasks";
    private static final String ICON_PATH = "org/netbeans/modules/tasklist/docscan/todosAction.gif";
    private final int MAIN_COLUMN_UID = 2352;
    private final int PRIORITY_COLUMN_UID = 7896;
    private final int FILE_COLUMN_UID = 8902;
    private final int LINE_COLUMN_UID = 6646;
    private final int LOCATION_COLUMN_UID = 6512;
    private static final int CURRENT_FILE_MODE = 1;
    private static final int OPENED_FILES_MODE = 2;
    private static final int SELECTED_FOLDER_MODE = 3;
    private static final int MODE_COUNT = 3;
    private SuggestionsBroker.Job job;
    private TaskList resultsSnapshot;
    private String reasonMsg;
    private Background background;
    FileObject selectedFolder;
    private static final int RECENT_ITEMS_COUNT = 4;
    private ArrayList recentFolders = new ArrayList(4);
    private SuggestionsBroker.AllOpenedJob allJob;
    private final TabState[] tabStates = new TabState[3];
    private Object windowSystemESCActionKey;
    private ColumnProperty[] allFilesColumns;
    private ColumnProperty[] currentFileColumns;
    private ProgressHandle progress;
    private JButton stop;
    private AbstractButton refresh;
    private JComponent prev;
    private JComponent next;
    private Cancellable cancellable = new Cancellable(){

        public boolean cancel() {
            SourceTasksView.this.handleStop();
            return true;
        }
    };
    private AbstractButton allFilesButton;
    private ButtonGroup group = new ButtonGroup();
    private AbstractButton folderSelector;
    private AbstractButton openedFiles;
    private AbstractButton currentFile;
    private AbstractButton gotoPresenter;
    private final ActionListener dispatcher = new Dispatcher();
    private int realFolders = 0;
    private int estimatedFolders = -1;
    private FileObject scannedFolder;
    private static long lastUISync;
    private JButton filterIconButton = null;
    private JComboBox filterCombo = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$core$GoToTaskAction;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction;

    public SourceTasksView() {
    }

    public SourceTasksView(SourceTasksList sourceTasksList) {
        super(CATEGORY, Util.getString("win-title"), Utilities.loadImage((String)ICON_PATH), true, (ObservableList)sourceTasksList);
        this.init();
    }

    SourceTasksView(SuggestionsBroker.Job job) {
        super(CATEGORY, Util.getString("win-title"), Utilities.loadImage((String)ICON_PATH), true, SourceTasksView.createFilteredList((TaskList)job.getSuggestionsList()));
        this.job = job;
        this.init();
    }

    private void init() {
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(82, 0);
        inputMap.put(keyStroke, keyStroke);
        this.getActionMap().put(keyStroke, new DelegateAction(this.getRefresh()));
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(70, 1);
        inputMap.put(keyStroke2, keyStroke2);
        this.getActionMap().put(keyStroke2, new DelegateAction(this.getFilterIconButton()));
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(70, 0);
        inputMap.put(keyStroke3, "filtercombo");
        AbstractAction abstractAction = new AbstractAction("filtercombo"){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceTasksView.this.filterCombo.showPopup();
                SourceTasksView.this.filterCombo.requestFocus();
            }
        };
        abstractAction.setEnabled(true);
        this.getActionMap().put("filtercombo", abstractAction);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(69, 0);
        inputMap.put(keyStroke4, keyStroke4);
        this.getActionMap().put(keyStroke4, new DelegateAction(this.getGoto()));
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(67, 0);
        inputMap.put(keyStroke5, keyStroke5);
        this.getActionMap().put(keyStroke5, new DelegateAction(this.getCurrentFile()));
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(79, 0);
        inputMap.put(keyStroke6, keyStroke6);
        this.getActionMap().put(keyStroke6, new DelegateAction(this.getOpenedFiles()));
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(83, 0);
        inputMap.put(keyStroke7, keyStroke7);
        this.getActionMap().put(keyStroke7, new DelegateAction(this.getAllFiles()));
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(83, 1);
        inputMap.put(keyStroke8, keyStroke8);
        this.getActionMap().put(keyStroke8, new DelegateAction(this.getFolderSelector()));
    }

    protected Component createCenterComponent() {
        Component component = super.createCenterComponent();
        this.getTable().getAccessibleContext().setAccessibleName(Util.getString("treetable"));
        this.getTable().getAccessibleContext().setAccessibleDescription(Util.getString("treetable_hint"));
        return component;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SourceTasksView.class);
    }

    protected Node createRootNode() {
        return new TaskListNode(this.getModel(), new TaskListNode.NodeFactory(){

            public Node createNode(Object object) {
                if (object instanceof SuggestionImpl) {
                    return new SourceTaskNode((SuggestionImpl)object);
                }
                return ((Task)object).createNode()[0];
            }
        });
    }

    protected ColumnProperty[] createColumns() {
        switch (this.getMode()) {
            case 1: {
                if (this.currentFileColumns == null) {
                    this.currentFileColumns = new ColumnProperty[]{this.createMainColumn(800), this.createPriorityColumn(false, 100), this.createLineColumn(true, 50)};
                }
                return this.currentFileColumns;
            }
            case 2: 
            case 3: {
                if (this.allFilesColumns == null) {
                    this.allFilesColumns = new ColumnProperty[]{this.createMainColumn(800), this.createPriorityColumn(false, 100), this.createLocationColumn(true, 200)};
                }
                return this.allFilesColumns;
            }
        }
        throw new IllegalStateException();
    }

    protected ColumnProperty getMainColumn(int n) {
        return this.createColumns()[0];
    }

    protected void loadColumnsConfiguration() {
    }

    protected void storeColumnsConfiguration() {
    }

    private ColumnProperty createMainColumn(int n) {
        return new ColumnProperty(2352, SourceTaskProperties.PROP_TASK, true, n);
    }

    private ColumnProperty createPriorityColumn(boolean bl, int n) {
        return new ColumnProperty(7896, SourceTaskProperties.PROP_PRIORITY, true, bl, n);
    }

    private ColumnProperty createFileColumn(boolean bl, int n) {
        ColumnProperty columnProperty = new ColumnProperty(8902, SourceTaskProperties.PROP_FILENAME, true, bl, n);
        return columnProperty;
    }

    private ColumnProperty createLineColumn(boolean bl, int n) {
        return new ColumnProperty(6646, SourceTaskProperties.PROP_LINE_NUMBER, true, bl, n);
    }

    private ColumnProperty createLocationColumn(boolean bl, int n) {
        ColumnProperty columnProperty = new ColumnProperty(6512, SourceTaskProperties.PROP_LOCATION, true, bl, n);
        return columnProperty;
    }

    protected void componentOpened() {
        super.componentOpened();
        this.setNorthComponentVisible(true);
        if (this.job == null) {
            this.handleCurrentFile();
        }
        this.updateButtonsState();
    }

    protected void componentClosed() {
        super.componentClosed();
        if (this.background != null) {
            this.background.interrupt();
        }
        Cache.store();
        this.releaseWorkaround();
        if (this.job != null) {
            this.job.stopBroker();
            this.job = null;
        }
        if (this.allJob != null) {
            this.allJob.stopBroker();
            this.allJob = null;
        }
    }

    protected String preferredID() {
        return "todo-window";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Cache.store();
        objectOutput.writeInt(2);
        boolean bl = this.job == null;
        objectOutput.writeBoolean(bl);
        if (bl) {
            // empty if block
        }
        ArrayList arrayList = this.recentFolders;
        if (this.selectedFolder != null) {
            arrayList = new ArrayList(this.recentFolders);
            SourceTasksView.addRecent(arrayList, this.selectedFolder);
        }
        objectOutput.writeObject(arrayList);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.category = CATEGORY;
        super.setName(Util.getString("win-title"));
        super.setIcon(Utilities.loadImage((String)ICON_PATH));
        int n = objectInput.readInt();
        if (n == 1 || n == 2) {
            boolean bl = objectInput.readBoolean();
            this.job = SuggestionsBroker.getDefault().startBroker((ProviderAcceptor)new SourceTasksProviderAcceptor());
            this.category = CATEGORY;
            SourceTasksView.registerTaskListView((TaskListView)this);
            this.setModel(SourceTasksView.createFilteredList((TaskList)this.job.getSuggestionsList()));
            if (n == 2) {
                this.recentFolders = (ArrayList)objectInput.readObject();
            }
        }
        this.init();
    }

    public String getToolTipText() {
        int n = this.getMode();
        switch (n) {
            case 1: {
                return Util.getString("win-tt-c");
            }
            case 2: {
                return Util.getString("win-tt-o");
            }
            case 3: {
                return Util.getString("win-tt-f");
            }
        }
        return null;
    }

    public String toString() {
        return "SourceTasksView@" + this.hashCode();
    }

    private ProgressHandle getProgress() {
        if (this.progress == null) {
            this.progress = ProgressHandleFactory.createHandle((String)Util.getString("searching"), (Cancellable)this.cancellable);
            this.progress.start();
        }
        return this.progress;
    }

    private void updateMiniStatus() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        String string = "";
        this.getMiniStatus().setHorizontalAlignment(2);
        StringBuffer stringBuffer = new StringBuffer(80);
        if (this.job == null && this.allJob == null && this.selectedFolder != null) {
            if (stringBuffer.length() > 0) {
                string = ", ";
            }
            stringBuffer.append(string + Util.getMessage("ctx-flag", SourceTasksView.createLabel(this.selectedFolder)));
        }
        if (this.reasonMsg != null && this.job == null && this.allJob == null) {
            if (stringBuffer.length() > 0) {
                string = ", ";
            }
            stringBuffer.append(string + Util.getMessage("usa-flag", "" + TLUtils.recursiveCount(this.getModel().getTasks().iterator())));
            this.getMiniStatus().setToolTipText(this.reasonMsg);
        } else {
            this.getMiniStatus().setToolTipText("");
        }
        this.getMiniStatus().setText(stringBuffer.toString());
    }

    AbstractButton getRefresh() {
        if (this.refresh == null) {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/refresh.png");
            JButton jButton = new JButton(new ImageIcon(image));
            jButton.setToolTipText(Util.getString("rescan_hint") + " (r)");
            jButton.setEnabled(this.job == null);
            jButton.addActionListener(this.dispatcher);
            this.adjustToobarButton(jButton);
            jButton.getAccessibleContext().setAccessibleName(Util.getString("rescan"));
            jButton.getAccessibleContext().setAccessibleDescription(Util.getString("rescan_hint"));
            this.refresh = jButton;
        }
        return this.refresh;
    }

    private JComponent getPrev() {
        if (this.prev == null) {
            JButton jButton = new JButton("Prev (Shift+F12)");
            jButton.addActionListener(this.dispatcher);
            this.adjustToobarButton(jButton);
            this.prev = jButton;
        }
        return this.prev;
    }

    private JComponent getNext() {
        if (this.next == null) {
            JButton jButton = new JButton("Next (F12)");
            jButton.addActionListener(this.dispatcher);
            this.adjustToobarButton(jButton);
            this.next = jButton;
        }
        return this.next;
    }

    AbstractButton getAllFiles() {
        if (this.allFilesButton == null) {
            JToggleButton jToggleButton = new JToggleButton(Util.getString("see-folder"));
            String string = this.selectedFolder == null ? Util.getString("see-folder_hint1") : Util.getString("see-folder_hint2");
            jToggleButton.setToolTipText(string + " (s)");
            this.group.add(jToggleButton);
            jToggleButton.setSelected(this.job == null);
            jToggleButton.addActionListener(this.dispatcher);
            this.adjustToobarButton(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Util.getString("see-folder"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(string);
            this.allFilesButton = jToggleButton;
        }
        return this.allFilesButton;
    }

    private AbstractButton getFolderSelector() {
        if (this.folderSelector == null) {
            DropDown dropDown = new DropDown();
            dropDown.setToolTipText(Util.getString("selector_hint") + " (S)");
            dropDown.addActionListener(this.dispatcher);
            this.adjustToobarButton(dropDown);
            dropDown.getAccessibleContext().setAccessibleName(Util.getString("select-folder"));
            dropDown.getAccessibleContext().setAccessibleDescription(Util.getString("selector_hint"));
            this.folderSelector = dropDown;
        }
        return this.folderSelector;
    }

    private void showFolderSelectorPopup() {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)jMenuItem2, (String)Util.getString("Lbl_select-folder"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SourceTasksView.this.handleSelectFolder();
            }
        });
        jPopupMenu.add(jMenuItem2);
        Iterator iterator = this.recentFolders.iterator();
        int n = 1;
        if (iterator.hasNext() || this.selectedFolder != null) {
            jPopupMenu.addSeparator();
        }
        if (this.selectedFolder != null) {
            jMenuItem = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)jMenuItem, (String)("&0 " + SourceTasksView.createLabel(this.selectedFolder)));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SourceTasksView.this.getAllFiles().isSelected()) {
                        return;
                    }
                    SourceTasksView.this.handleAllFiles();
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        while (iterator.hasNext()) {
            jMenuItem = (FileObject)iterator.next();
            if (jMenuItem == null || !jMenuItem.isValid() || jMenuItem.equals(this.selectedFolder)) continue;
            JMenuItem jMenuItem3 = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)jMenuItem3, (String)("&" + n + " " + SourceTasksView.createLabel((FileObject)jMenuItem)));
            jMenuItem3.addActionListener(new RecentActionListener((FileObject)jMenuItem));
            jPopupMenu.add(jMenuItem3);
            ++n;
        }
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (SourceTasksView.this.selectedFolder == null) {
                    SourceTasksView.this.getCurrentFile().doClick(0);
                }
            }
        });
        jPopupMenu.show(this.getAllFiles(), 0, this.getAllFiles().getHeight());
    }

    private AbstractButton getOpenedFiles() {
        if (this.openedFiles == null) {
            JToggleButton jToggleButton = new JToggleButton(Util.getString("opened"));
            jToggleButton.setToolTipText(Util.getString("opened_desc"));
            this.group.add(jToggleButton);
            jToggleButton.setSelected(this.getMode() == 2);
            jToggleButton.addActionListener(this.dispatcher);
            this.adjustToobarButton(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Util.getString("opened"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Util.getString("opened_desc"));
            this.openedFiles = jToggleButton;
        }
        return this.openedFiles;
    }

    private AbstractButton getCurrentFile() {
        if (this.currentFile == null) {
            JToggleButton jToggleButton = new JToggleButton(Util.getString("see-file"));
            jToggleButton.setToolTipText(Util.getString("see-file_hint") + " (c)");
            this.group.add(jToggleButton);
            jToggleButton.setSelected(this.getMode() == 1);
            jToggleButton.addActionListener(this.dispatcher);
            this.adjustToobarButton(jToggleButton);
            jToggleButton.getAccessibleContext().setAccessibleName(Util.getString("see-file"));
            jToggleButton.getAccessibleContext().setAccessibleDescription(Util.getString("see-file_hint"));
            this.currentFile = jToggleButton;
        }
        return this.currentFile;
    }

    private AbstractButton getGoto() {
        if (this.gotoPresenter == null) {
            Image image = Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/gotosource.png");
            JButton jButton = new JButton(new ImageIcon(image));
            jButton.setToolTipText(Util.getString("goto_hint") + " (e)");
            jButton.addActionListener(this.dispatcher);
            this.adjustToobarButton(jButton);
            jButton.getAccessibleContext().setAccessibleName(Util.getString("goto"));
            jButton.getAccessibleContext().setAccessibleDescription(Util.getString("goto_hint"));
            this.gotoPresenter = jButton;
        }
        return this.gotoPresenter;
    }

    private void adjustToobarButton(final AbstractButton abstractButton) {
        abstractButton.setMargin(new Insets(0, 3, 0, 3));
        if (!(abstractButton instanceof JToggleButton)) {
            abstractButton.setContentAreaFilled(false);
            abstractButton.setBorderPainted(false);
            abstractButton.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    abstractButton.setContentAreaFilled(true);
                    abstractButton.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    abstractButton.setContentAreaFilled(false);
                    abstractButton.setBorderPainted(false);
                }
            });
        }
        this.adjustToolbarComponentSize(abstractButton);
    }

    private void adjustToolbarComponentSize(JComponent jComponent) {
        if (jComponent.getBorder() instanceof CompoundBorder) {
            Dimension dimension = jComponent.getPreferredSize();
            dimension.height = SourceTasksView.getToolbarHeight();
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                dimension.width += 9;
            }
            jComponent.setPreferredSize(dimension);
        }
    }

    public void updateFilterCount() {
    }

    protected Component createNorthComponent() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, jToolBar.getBackground().darker().darker());
        jToolBar.setBorder(matteBorder);
        jToolBar.setLayout(new ToolbarLayout());
        jToolBar.add(this.getCurrentFile());
        jToolBar.add(this.getOpenedFiles());
        jToolBar.add(this.getAllFiles());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add(this.getFolderSelector());
        jToolBar.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jToolBar.add(jPanel2);
        jToolBar.add(this.getGoto());
        jToolBar.add(this.getRefresh());
        jToolBar.add(this.getFilterIconButton());
        jToolBar.add(this.getFilterCombo());
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jToolBar.add(jPanel3);
        jToolBar.add(this.getMiniStatus());
        jToolBar.setPreferredSize(new Dimension(Integer.MAX_VALUE, SourceTasksView.getToolbarHeight()));
        return jToolBar;
    }

    public void estimate(final int n) {
        this.scannedFolder = null;
        this.estimatedFolders = n;
        if (n == -1) {
            this.getProgress().switchToIndeterminate();
        } else {
            this.getProgress().switchToDeterminate(this.estimatedFolders);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n == -1) {
                    Cache.load();
                }
            }
        });
    }

    public void scanStarted() {
        this.realFolders = 0;
        this.reasonMsg = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceTasksView.this.getRefresh().setEnabled(false);
            }
        });
    }

    public void folderEntered(FileObject fileObject) {
        this.scannedFolder = fileObject;
        if (this.estimatedFolders > 0) {
            ++this.realFolders;
            if (this.realFolders > this.estimatedFolders) {
                this.estimatedFolders = this.realFolders;
                this.getProgress().switchToDeterminate(this.estimatedFolders);
            }
            this.getProgress().progress(this.realFolders);
        }
        SourceTasksView.handlePendingAWTEvents();
    }

    public void fileScanned(FileObject fileObject) {
        SourceTasksView.handlePendingAWTEvents();
    }

    public void folderScanned(FileObject fileObject) {
        SourceTasksView.handlePendingAWTEvents();
    }

    public void scanTerminated(int n) {
        if (n == -1) {
            this.reasonMsg = Util.getString("mem_ter");
        } else if (n == -2) {
            this.reasonMsg = Util.getString("usr-ter");
        } else if (n == -3) {
            this.reasonMsg = Util.getString("usa-ter");
        }
    }

    public void scanFinished() {
        this.estimatedFolders = -1;
        this.progressFinished();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceTasksView.this.getRefresh().setEnabled(SourceTasksView.this.job == null);
                SourceTasksView.this.updateMiniStatus();
            }
        });
    }

    private void progressFinished() {
        this.getProgress().finish();
        this.progress = null;
    }

    public void statistics(int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceTasksView.this.updateMiniStatus();
            }
        });
    }

    private void handleStop() {
        this.background.interrupt();
        this.getMiniStatus().setText(Util.getString("stopping"));
    }

    protected void componentHidden() {
        super.componentHidden();
    }

    ObservableList discloseModel() {
        return this.getModel();
    }

    Object discloseTable() {
        return this.treeTable;
    }

    Node discloseNode() {
        return this.rootNode;
    }

    private void handleOpenedFiles() {
        this.saveFilterState();
        switch (this.getMode()) {
            case 1: {
                this.job.stopBroker();
                this.job = null;
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                if (this.background != null) {
                    this.handleStop();
                }
                this.background = null;
            }
        }
        this.releaseWorkaround();
        this.allJob = SuggestionsBroker.getDefault().startAllOpenedBroker((ProviderAcceptor)new SourceTasksProviderAcceptor());
        this.treeTable.setProperties((Node.Property[])this.createColumns());
        this.treeTable.setTreePreferredWidth(this.createColumns()[0].getWidth());
        SuggestionList suggestionList = this.allJob.getSuggestionList();
        this.setModel((ObservableList)suggestionList);
        this.loadFilterState(2);
        this.getRefresh().setEnabled(false);
        this.getTable().requestFocusInWindow();
        this.updateMiniStatus();
        this.putClientProperty("ToolTipText", this.getToolTipText());
    }

    private void handleAllFiles() {
        if (this.selectedFolder == null) {
            if (this.recentFolders.size() > 0) {
                this.showFolderSelectorPopup();
            } else {
                this.handleSelectFolder();
            }
            return;
        }
        Object object = null;
        try {
            object = DataObject.find((FileObject)this.selectedFolder);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (object == null) {
            if (this.recentFolders.size() > 0) {
                this.showFolderSelectorPopup();
            } else {
                this.handleSelectFolder();
            }
            return;
        }
        this.saveFilterState();
        switch (this.getMode()) {
            case 1: {
                this.job.stopBroker();
                this.job = null;
                break;
            }
            case 2: {
                this.allJob.stopBroker();
                this.allJob = null;
                break;
            }
        }
        this.allFilesButton.setToolTipText(Util.getMessage("see-folder-hint2", SourceTasksView.createLabel(this.selectedFolder)) + " (s)");
        ((JToggleButton)this.allFilesButton).setSelected(true);
        this.treeTable.setProperties((Node.Property[])this.createColumns());
        this.treeTable.setTreePreferredWidth(this.createColumns()[0].getWidth());
        object = this.resultsSnapshot == null ? new SourceTasksList() : this.resultsSnapshot;
        this.releaseWorkaround();
        this.setModel((ObservableList)object);
        this.loadFilterState(3);
        this.getRefresh().setEnabled(true);
        this.getTable().requestFocusInWindow();
        if (object != this.resultsSnapshot) {
            try {
                DataObject.Container container = (DataObject.Container)DataObject.find((FileObject)this.selectedFolder);
                DataObject.Container[] containerArray = new DataObject.Container[]{container};
                this.background = SourceTasksScanner.scanTasksAsync(this, containerArray);
                this.resultsSnapshot = object;
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                this.selectedFolder = null;
            }
        } else {
            this.getMiniStatus().setText(Util.getMessage("restored", SourceTasksView.createLabel(this.selectedFolder)));
        }
        this.putClientProperty("ToolTipText", this.getToolTipText());
    }

    private void handleRefresh() {
        this.getList().clear();
        try {
            DataObject.Container container = (DataObject.Container)DataObject.find((FileObject)this.selectedFolder);
            DataObject.Container[] containerArray = new DataObject.Container[]{container};
            this.background = SourceTasksScanner.scanTasksAsync(this, containerArray);
            this.getTable().requestFocusInWindow();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.getMiniStatus().setText(Util.getMessage("refresh-err", SourceTasksView.createLabel(this.selectedFolder)));
        }
    }

    private static String createLabel(FileObject fileObject) {
        String string;
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            string = fileObject.getPath();
            try {
                string = fileObject.getFileSystem().getDisplayName() + string;
            }
            catch (FileStateInvalidException fileStateInvalidException) {}
        } else {
            string = file.getPath();
        }
        if (string.length() > 60) {
            return "..." + string.substring(string.length() - 57);
        }
        return string;
    }

    private int getMode() {
        if (this.job != null) {
            return 1;
        }
        if (this.allJob != null) {
            return 2;
        }
        return 3;
    }

    private void saveFilterState() {
        int n = this.getMode();
        TabState tabState = this.tabStates[n - 1];
        if (tabState == null) {
            this.tabStates[n - 1] = new TabState();
            tabState = this.tabStates[n - 1];
        }
        tabState.filtered = this.isFiltered();
        tabState.filter = this.getFilter();
    }

    private void loadFilterState(int n) {
    }

    private void releaseWorkaround() {
        ObservableList observableList = this.getModel();
        if (observableList instanceof FilteredTasksList) {
            ((FilteredTasksList)observableList).byebye();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCurrentFile() {
        this.saveFilterState();
        switch (this.getMode()) {
            case 1: {
                return;
            }
            case 2: {
                this.allJob.stopBroker();
                this.allJob = null;
                break;
            }
            case 3: {
                if (this.background != null) {
                    this.handleStop();
                }
                this.background = null;
            }
        }
        try {
            this.job = SuggestionsBroker.getDefault().startBroker((ProviderAcceptor)new SourceTasksProviderAcceptor());
            this.treeTable.setProperties((Node.Property[])this.createColumns());
            this.treeTable.setTreePreferredWidth(this.createColumns()[0].getWidth());
            this.setModel(SourceTasksView.createFilteredList((TaskList)this.job.getSuggestionsList()));
            this.loadFilterState(1);
        }
        finally {
            this.getRefresh().setEnabled(false);
            this.getTable().requestFocusInWindow();
            this.updateMiniStatus();
            this.putClientProperty("ToolTipText", this.getToolTipText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelectFolder() {
        if (this.background != null) {
            this.handleStop();
        }
        this.background = null;
        final Node node = Choosers.projectView();
        NodeOperation nodeOperation = NodeOperation.getDefault();
        try {
            Node[] nodeArray = nodeOperation.select(Util.getString("sel_title"), Util.getString("sel-head"), node, new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodeArray) {
                    return nodeArray.length == 1 && nodeArray[0] != node && nodeArray[0].getLookup().lookup(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = SourceTasksView.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject) != null;
                }
            });
            this.resultsSnapshot = null;
            this.updateRecent(this.selectedFolder);
            this.selectedFolder = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
            this.handleAllFiles();
        }
        catch (UserCancelException userCancelException) {
        }
        finally {
            Choosers.icons = null;
        }
    }

    private void updateRecent(FileObject fileObject) {
        SourceTasksView.addRecent(this.recentFolders, fileObject);
    }

    private static void addRecent(List list, FileObject fileObject) {
        if (fileObject == null) {
            return;
        }
        if (!list.contains(fileObject)) {
            if (list.size() == 4) {
                list.remove(list.size() - 1);
            }
            list.add(0, fileObject);
        } else {
            list.remove(fileObject);
            list.add(0, fileObject);
        }
    }

    private void handlePrev() {
        this.prevTask();
    }

    private void handleNext() {
        this.nextTask();
    }

    final void setBackground(Background background) {
        this.background = background;
    }

    private void updateButtonsState() {
        switch (this.getMode()) {
            case 1: {
                this.currentFile.setSelected(true);
                this.openedFiles.setSelected(false);
                this.folderSelector.setSelected(false);
                break;
            }
            case 2: {
                this.currentFile.setSelected(false);
                this.openedFiles.setSelected(true);
                this.folderSelector.setSelected(false);
                break;
            }
            case 3: {
                this.currentFile.setSelected(false);
                this.openedFiles.setSelected(false);
                this.folderSelector.setSelected(true);
            }
        }
    }

    public static void handlePendingAWTEvents() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - lastUISync < 103L) {
            return;
        }
        lastUISync = l;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public boolean isObserved(String string) {
        return this.isShowing() && "nb-tasklist-scannedtask".equals(string);
    }

    public SuggestionList getSuggestionsModel() {
        return null;
    }

    private static ObservableList createFilteredList(TaskList taskList) {
        return new FilteredTasksList(taskList);
    }

    public Filter createFilter() {
        return new SourceTasksFilter(NbBundle.getMessage((Class)SourceTaskNode.class, (String)"new-filter-name"));
    }

    public AccessibleContext getAccessibleContext() {
        AccessibleContext accessibleContext = super.getAccessibleContext();
        switch (this.getMode()) {
            case 1: {
                accessibleContext.setAccessibleDescription(Util.getString("file_desc11"));
                break;
            }
            case 2: {
                accessibleContext.setAccessibleDescription(Util.getString("opened_desc11"));
                break;
            }
            case 3: {
                accessibleContext.setAccessibleDescription(Util.getMessage("folder_desc11", SourceTasksView.createLabel(this.selectedFolder)));
            }
        }
        return accessibleContext;
    }

    protected void setFiltered() {
        super.setFiltered();
    }

    private AbstractButton getFilterIconButton() {
        if (this.filterIconButton == null) {
            ImageIcon imageIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/filter.png"));
            this.filterIconButton = new JButton(imageIcon);
            this.adjustToobarButton(this.filterIconButton);
            this.filterIconButton.setToolTipText(Util.getString("filter_hint") + " (shift+f)");
            this.filterIconButton.addActionListener(this.dispatcher);
            this.filterIconButton.getAccessibleContext().setAccessibleName(Util.getString("filter"));
            this.filterIconButton.getAccessibleContext().setAccessibleDescription(Util.getString("filter_hint"));
        }
        return this.filterIconButton;
    }

    private JComboBox getFilterCombo() {
        if (this.filterCombo == null) {
            this.filterCombo = new JComboBox(new FiltersComboModel(this.getFilters()));
            this.filterCombo.addActionListener(this.dispatcher);
            this.adjustToolbarComponentSize(this.filterCombo);
            Dimension dimension = this.filterCombo.getPreferredSize();
            dimension.width = 150;
            dimension.height = SourceTasksView.getToolbarHeight();
            this.filterCombo.setPreferredSize(dimension);
            this.filterCombo.setToolTipText(Util.getString("choose-filter_hint") + " (f)");
            this.filterCombo.getAccessibleContext().setAccessibleName(Util.getString("choose-filter"));
            this.filterCombo.getAccessibleContext().setAccessibleDescription(Util.getString("choose-filter_hint"));
        }
        return this.filterCombo;
    }

    static {
        $assertionsDisabled = !SourceTasksView.class.desiredAssertionStatus();
        lastUISync = System.currentTimeMillis();
    }

    private static class DelegateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        AbstractButton target;

        DelegateAction(AbstractButton abstractButton) {
            this.target = abstractButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.target.doClick();
        }
    }

    private class Dispatcher
    implements ActionListener {
        private Dispatcher() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SourceTasksView.this.getGoto()) {
                GoToTaskAction goToTaskAction = (GoToTaskAction)SystemAction.get((Class)(class$org$netbeans$modules$tasklist$core$GoToTaskAction == null ? (class$org$netbeans$modules$tasklist$core$GoToTaskAction = SourceTasksView.class$("org.netbeans.modules.tasklist.core.GoToTaskAction")) : class$org$netbeans$modules$tasklist$core$GoToTaskAction));
                if (goToTaskAction.isEnabled()) {
                    goToTaskAction.performAction();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (object == SourceTasksView.this.getCurrentFile()) {
                SourceTasksView.this.handleCurrentFile();
            } else if (object == SourceTasksView.this.getOpenedFiles()) {
                SourceTasksView.this.handleOpenedFiles();
            } else if (object == SourceTasksView.this.getFolderSelector()) {
                if (SourceTasksView.this.recentFolders.size() > 0 || SourceTasksView.this.selectedFolder != null) {
                    SourceTasksView.this.showFolderSelectorPopup();
                } else {
                    SourceTasksView.this.handleSelectFolder();
                }
            } else if (object == SourceTasksView.this.getAllFiles()) {
                SourceTasksView.this.handleAllFiles();
            } else if (object == SourceTasksView.this.getRefresh()) {
                SourceTasksView.this.handleRefresh();
            } else if (object == SourceTasksView.this.getPrev()) {
                SourceTasksView.this.handlePrev();
            } else if (object == SourceTasksView.this.getNext()) {
                SourceTasksView.this.handleNext();
            } else if (object == SourceTasksView.this.getFilterCombo()) {
                if (SourceTasksView.this.filterCombo.getSelectedItem() != null) {
                    SourceTasksView.this.setFilter(((Filter.ListModelElement)((SourceTasksView)SourceTasksView.this).filterCombo.getSelectedItem()).filter);
                }
            } else if (object == SourceTasksView.this.getFilterIconButton()) {
                FilterSourceTasksAction filterSourceTasksAction = (FilterSourceTasksAction)SystemAction.get((Class)(class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction == null ? (class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction = SourceTasksView.class$("org.netbeans.modules.tasklist.docscan.FilterSourceTasksAction")) : class$org$netbeans$modules$tasklist$docscan$FilterSourceTasksAction));
                SourceTasksView.this.putClientProperty("fp-selected-filter", SourceTasksView.this.getFilterCombo().getSelectedItem());
                filterSourceTasksAction.actionPerformed(actionEvent);
            }
        }
    }

    class DropDown
    extends JButton {
        private static final long serialVersionUID = 1L;
        private static final int DROPDOWN_WIDTH = 15;

        DropDown() {
            super(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/tasklist/docscan/dropdown.gif")));
        }

        public Dimension getPreferredSize() {
            return new Dimension(15, TaskListView.getToolbarHeight());
        }
    }

    private static class FiltersComboModel
    implements ComboBoxModel {
        private List lsnrs = Collections.synchronizedList(new LinkedList());
        private Filter.ListModelElement[] elements = null;
        private int activei = -1;
        private FilterRepository rep = null;

        public FiltersComboModel(FilterRepository filterRepository) {
            this.rep = filterRepository;
            filterRepository.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FiltersComboModel.this.onFiltersChanged(propertyChangeEvent);
                }
            });
        }

        public void addListDataListener(ListDataListener listDataListener) {
            if (this.lsnrs.indexOf(listDataListener) == -1) {
                this.lsnrs.add(listDataListener);
            }
        }

        public Object getElementAt(int n) {
            if (this.elements == null) {
                this.prepareElements();
            }
            return this.elements[n];
        }

        private void prepareElements() {
            this.elements = new Filter.ListModelElement[this.rep.size() + 1];
            this.elements[0] = new Filter.ListModelElement(null);
            Iterator iterator = this.rep.iterator();
            for (int i = 1; i < this.rep.size() + 1; ++i) {
                this.elements[i] = new Filter.ListModelElement((Filter)iterator.next());
            }
            if (this.activei >= this.rep.size() + 1) {
                this.activei = -1;
            }
        }

        public Object getSelectedItem() {
            if (this.elements == null) {
                this.prepareElements();
            }
            if (this.activei == -1) {
                Filter filter = this.rep.getActive();
                for (int i = 0; i < this.elements.length; ++i) {
                    if (this.elements[i].filter != filter) continue;
                    this.activei = i;
                    break;
                }
            }
            return this.activei >= 0 ? this.elements[this.activei] : null;
        }

        public int getSize() {
            return this.rep.size() + 1;
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.lsnrs.remove(listDataListener);
        }

        public void setSelectedItem(Object object) {
            this.rep.setActive(((Filter.ListModelElement)object).filter);
        }

        private void onFiltersChanged(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("propFilters")) {
                this.elements = null;
                this.fireContentsChanged();
            } else if (propertyChangeEvent.getPropertyName().equals("propActiveFilter")) {
                this.activei = -1;
                this.fireContentsChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireContentsChanged() {
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, Integer.MAX_VALUE);
            ArrayList arrayList = null;
            Object object = this.lsnrs;
            synchronized (object) {
                arrayList = new ArrayList(this.lsnrs);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                ((ListDataListener)object.next()).contentsChanged(listDataEvent);
            }
        }
    }

    private class RecentActionListener
    implements ActionListener {
        private final FileObject fo;

        RecentActionListener(FileObject fileObject) {
            this.fo = fileObject;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SourceTasksView.this.updateRecent(SourceTasksView.this.selectedFolder);
            SourceTasksView.this.selectedFolder = this.fo;
            SourceTasksView.this.resultsSnapshot = null;
            SourceTasksView.this.handleAllFiles();
        }
    }

    private static class TabState {
        boolean filtered;
        Filter filter;

        private TabState() {
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private ToolbarLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            int n = dimension.width - this.preferredLayoutSize((Container)container).width;
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                JComponent jComponent = (JComponent)container.getComponent(i);
                if (!jComponent.isVisible()) continue;
                jComponent.setLocation(n3, 0);
                Dimension dimension2 = jComponent.getPreferredSize();
                int n4 = dimension2.width;
                if (jComponent == SourceTasksView.this.getMiniStatus()) {
                    n4 = n;
                }
                jComponent.setSize(n4, TaskListView.getToolbarHeight() - 1);
                n3 += n4;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = container.getComponentCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                component.setLocation(n2, 0);
                Dimension dimension = component.getPreferredSize();
                n2 += dimension.width;
            }
            return new Dimension(n2, TaskListView.getToolbarHeight());
        }

        public Dimension preferredLayoutSize(Container container) {
            return SourceTasksView.this.getMinimumSize();
        }
    }
}

