/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.tasklist.docscan.TaskTag;
import org.openide.ErrorManager;

public final class TaskTags
implements Externalizable {
    static final long serialVersionUID = 1L;
    private TaskTag[] tags = null;
    private Pattern regexp = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setTags(TaskTag[] taskTagArray) {
        this.tags = taskTagArray;
    }

    public TaskTag[] getTags() {
        return this.tags;
    }

    public TaskTag getTag(CharSequence charSequence, int n, int n2) {
        if (this.tags == null) {
            return null;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            if (!TaskTags.same(this.tags[i].getToken(), charSequence, n, n2)) continue;
            return this.tags[i];
        }
        return null;
    }

    private static boolean same(String string, CharSequence charSequence, int n, int n2) {
        if (string.length() != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == charSequence.charAt(n + i)) continue;
            return false;
        }
        return true;
    }

    public Pattern getScanRegexp() {
        if (this.regexp == null) {
            StringBuffer stringBuffer = new StringBuffer(200);
            TaskTag[] taskTagArray = this.getTags();
            for (int i = 0; i < taskTagArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append('|');
                }
                String string = taskTagArray[i].getToken();
                int n = string.length();
                if (Character.isJavaIdentifierPart(string.charAt(0))) {
                    stringBuffer.append("\\W");
                }
                for (int j = 0; j < n; ++j) {
                    char c = string.charAt(j);
                    if (c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '?' || c == '*' || c == '+' || c == '!' || c == '|' || c == '\\' || c == '^' || c == '$') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
                if (!Character.isJavaIdentifierPart(string.charAt(n - 1))) continue;
                stringBuffer.append("\\b");
            }
            try {
                this.regexp = Pattern.compile(stringBuffer.toString());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ErrorManager.getDefault().notify(65536, (Throwable)patternSyntaxException);
                return null;
            }
        }
        return this.regexp;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.read();
        if (!$assertionsDisabled && n != 1) {
            throw new AssertionError((Object)"serialization version incorrect; should be 1");
        }
        int n2 = (Integer)objectInput.readObject();
        this.tags = new TaskTag[n2];
        for (int i = 0; i < n2; ++i) {
            this.tags[i] = (TaskTag)objectInput.readObject();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.write(1);
        objectOutput.writeObject(new Integer(this.tags.length));
        for (int i = 0; i < this.tags.length; ++i) {
            objectOutput.writeObject(this.tags[i]);
        }
    }

    static {
        $assertionsDisabled = !TaskTags.class.desiredAssertionStatus();
    }
}

