/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.guards;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.InteriorSection;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.java.guards.GuardTag;
import org.netbeans.modules.java.guards.SectionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavaGuardedWriter {
    private Iterator<SectionDescriptor> descs;
    private CharArrayWriter writer;
    private SectionDescriptor current;
    private int offsetCounter;
    boolean wasNewLine;
    int spaces;

    public void setGuardedSection(List<GuardedSection> list) {
        assert (this.descs == null);
        this.descs = this.prepareSections(list).iterator();
    }

    public char[] translate(char[] cArray) {
        if (this.descs == null || !this.descs.hasNext()) {
            return cArray;
        }
        this.writer = new CharArrayWriter(cArray.length);
        this.offsetCounter = 0;
        this.wasNewLine = false;
        this.nextSection();
        try {
            for (char c : cArray) {
                this.writeOneChar(c);
            }
            char[] cArray2 = this.writer.toCharArray();
            return cArray2;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        finally {
            this.writer = null;
            this.current = null;
        }
    }

    void writeOneChar(int n) throws IOException {
        if (n == 13) {
            return;
        }
        if (this.current != null) {
            if (this.offsetCounter == this.current.getBegin()) {
                this.wasNewLine = false;
            }
            if (n == 10 && this.current.getBegin() <= this.offsetCounter) {
                switch (this.current.getType()) {
                    case LINE: {
                        if (!this.wasNewLine) {
                            if (this.offsetCounter + 1 >= this.current.getEnd()) {
                                this.writeMagic(GuardTag.LINE, this.current.getName());
                                this.nextSection();
                                break;
                            }
                            this.writeMagic(GuardTag.BEGIN, this.current.getName());
                            this.wasNewLine = true;
                            break;
                        }
                        if (this.offsetCounter + 1 < this.current.getEnd()) break;
                        this.writeMagic(GuardTag.END, this.current.getName());
                        this.nextSection();
                        break;
                    }
                    case FIRST: 
                    case HEADER: {
                        if (!this.wasNewLine) {
                            if (this.offsetCounter + 1 >= this.current.getEnd()) {
                                this.writeMagic(GuardTag.FIRST, this.current.getName());
                                this.nextSection();
                                break;
                            }
                            this.writeMagic(GuardTag.FIRST, this.current.getName());
                            this.wasNewLine = true;
                            break;
                        }
                        if (this.offsetCounter + 1 < this.current.getEnd()) break;
                        this.writeMagic(GuardTag.HEADEREND, this.current.getName());
                        this.nextSection();
                        break;
                    }
                    case LAST: 
                    case END: {
                        this.writeMagic(GuardTag.LAST, this.current.getName());
                        this.nextSection();
                    }
                }
            }
        }
        if (n == 32) {
            ++this.spaces;
        } else {
            if (this.spaces > 0) {
                char[] cArray = new char[this.spaces];
                Arrays.fill(cArray, ' ');
                this.writer.write(cArray);
                this.spaces = 0;
            }
            this.writer.write(n);
        }
        ++this.offsetCounter;
    }

    private void nextSection() {
        this.current = this.descs.hasNext() ? this.descs.next() : null;
    }

    private void writeMagic(GuardTag guardTag, String string) throws IOException {
        this.spaces = 0;
        String string2 = "//GEN-" + guardTag.name() + ':';
        this.writer.write(string2, 0, string2.length());
        this.writer.write(string, 0, string.length());
    }

    private List<SectionDescriptor> prepareSections(List<? extends GuardedSection> list) {
        ArrayList<SectionDescriptor> arrayList = new ArrayList<SectionDescriptor>(list.size());
        for (GuardedSection guardedSection : list) {
            SectionDescriptor sectionDescriptor;
            if (guardedSection instanceof SimpleSection) {
                sectionDescriptor = new SectionDescriptor(GuardTag.LINE, guardedSection.getName(), guardedSection.getStartPosition().getOffset(), guardedSection.getEndPosition().getOffset());
                arrayList.add(sectionDescriptor);
                continue;
            }
            sectionDescriptor = new SectionDescriptor(GuardTag.HEADER, guardedSection.getName(), guardedSection.getStartPosition().getOffset(), ((InteriorSection)guardedSection).getBodyStartPosition().getOffset() - 1);
            arrayList.add(sectionDescriptor);
            sectionDescriptor = new SectionDescriptor(GuardTag.END, guardedSection.getName(), ((InteriorSection)guardedSection).getBodyEndPosition().getOffset() + 1, guardedSection.getEndPosition().getOffset());
            arrayList.add(sectionDescriptor);
        }
        return arrayList;
    }
}

