/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.text;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.core.DTDDataObject;
import org.netbeans.modules.xml.core.EntityDataObject;
import org.netbeans.modules.xml.core.XMLDataObject;
import org.netbeans.modules.xml.core.XMLDataObjectLook;
import org.netbeans.modules.xml.core.cookies.DataObjectCookieManager;
import org.netbeans.modules.xml.core.lib.Convertors;
import org.netbeans.modules.xml.core.lib.EncodingHelper;
import org.netbeans.modules.xml.core.settings.CoreSettings;
import org.netbeans.modules.xml.core.sync.Representation;
import org.netbeans.modules.xml.core.sync.Synchronizator;
import org.netbeans.modules.xml.core.text.DTDTextRepresentation;
import org.netbeans.modules.xml.core.text.EntityTextRepresentation;
import org.netbeans.modules.xml.core.text.TextEditorComponent;
import org.netbeans.modules.xml.core.text.Util;
import org.netbeans.modules.xml.core.text.XMLTextRepresentation;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class TextEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
EditCookie,
CloseCookie,
PrintCookie {
    public static final String PROP_DOCUMENT_URL = "doc-url";
    static final CoreSettings settings = CoreSettings.getDefault();
    private Timer timer;
    private static Container awtLock;
    private Representation rep;
    private volatile boolean encodingErr = false;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie$Observable;
    static /* synthetic */ Class class$org$openide$cookies$CloseCookie;
    static /* synthetic */ Class class$org$openide$cookies$PrintCookie;

    protected TextEditorSupport(XMLDataObjectLook xMLDataObjectLook, Env env, String string) {
        super((DataObject)xMLDataObjectLook, (CloneableEditorSupport.Env)env);
        this.setMIMEType(string);
        this.initTimer();
        this.initListeners();
    }

    public TextEditorSupport(XMLDataObjectLook xMLDataObjectLook, String string) {
        this(xMLDataObjectLook, new Env(xMLDataObjectLook), string);
    }

    private void initTimer() {
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("$$ TextEditorSupport::initTimer::actionPerformed: event = " + actionEvent);
                }
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        TextEditorSupport.this.syncDocument(false);
                    }
                });
            }
        });
        this.timer.setInitialDelay(settings.getAutoParsingDelay());
        this.timer.setRepeats(false);
    }

    private void initListeners() {
        final DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::insertUpdate: event = " + documentEvent);
                }
                this.restartTime();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::changedUpdate: event = " + documentEvent);
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::removeUpdate: event = " + documentEvent);
                }
                this.restartTime();
            }

            private void restartTime() {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("** TextEditorSupport::DocumentListener::restartTime: isInSync = " + TextEditorSupport.this.getXMLDataObjectLook().getSyncInterface().isInSync());
                }
                if (TextEditorSupport.this.getXMLDataObjectLook().getSyncInterface().isInSync()) {
                    return;
                }
                TextEditorSupport.this.restartTimer(false);
            }
        };
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TextEditorSupport.this.isDocumentLoaded()) {
                    StyledDocument styledDocument = TextEditorSupport.this.getDocument();
                    if (styledDocument == null) {
                        return;
                    }
                    styledDocument.addDocumentListener(WeakListeners.document((DocumentListener)documentListener, (Object)styledDocument));
                    if (TextEditorSupport.this.rep == null) {
                        XMLDataObjectLook xMLDataObjectLook = (XMLDataObjectLook)TextEditorSupport.this.getDataObject();
                        Synchronizator synchronizator = xMLDataObjectLook.getSyncInterface();
                        if (xMLDataObjectLook instanceof XMLDataObject) {
                            TextEditorSupport.this.rep = new XMLTextRepresentation(TextEditorSupport.this, synchronizator);
                        } else if (xMLDataObjectLook instanceof DTDDataObject) {
                            TextEditorSupport.this.rep = new DTDTextRepresentation(TextEditorSupport.this, synchronizator);
                        } else if (xMLDataObjectLook instanceof EntityDataObject) {
                            TextEditorSupport.this.rep = new EntityTextRepresentation(TextEditorSupport.this, synchronizator);
                        }
                        if (TextEditorSupport.this.rep != null) {
                            synchronizator.addRepresentation(TextEditorSupport.this.rep);
                        }
                    }
                }
            }
        });
    }

    protected void notifyClosed() {
        super.notifyClosed();
        if (((Object)((Object)this)).getClass() != TextEditorSupport.class) {
            return;
        }
        XMLDataObjectLook xMLDataObjectLook = (XMLDataObjectLook)this.getDataObject();
        Synchronizator synchronizator = xMLDataObjectLook.getSyncInterface();
        Representation representation = this.rep;
        this.rep = null;
        if (representation != null) {
            synchronizator.removeRepresentation(representation);
        }
    }

    Env getEnv() {
        return (Env)this.env;
    }

    protected XMLDataObjectLook getXMLDataObjectLook() {
        return this.getEnv().getXMLDataObjectLook();
    }

    protected boolean notifyModified() {
        if (this.getEnv().isModified()) {
            return true;
        }
        if (!super.notifyModified()) {
            return false;
        }
        DataObjectCookieManager dataObjectCookieManager = this.getEnv().getXMLDataObjectLook().getCookieManager();
        dataObjectCookieManager.addCookie((Node.Cookie)this.getEnv());
        return true;
    }

    protected void notifyUnmodified() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Notifing unmodified");
        }
        super.notifyUnmodified();
        DataObjectCookieManager dataObjectCookieManager = this.getEnv().getXMLDataObjectLook().getCookieManager();
        dataObjectCookieManager.removeCookie((Node.Cookie)this.getEnv());
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        String string = EncodingHelper.detectEncoding(inputStream);
        if (string == null) {
            string = "UTF8";
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string);
            editorKit.read(inputStreamReader, (Document)styledDocument, 0);
        }
        catch (CharConversionException charConversionException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\n!!! TextEditorSupport.loadFromStreamToKit: enc = '" + string + "'", charConversionException);
            }
            this.encodingErr = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\n!!! TextEditorSupport.loadFromStreamToKit: enc = '" + string + "'", unsupportedEncodingException);
            }
            this.encodingErr = true;
        }
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        String string = EncodingHelper.detectEncoding(styledDocument);
        if (string == null) {
            string = "UTF8";
        }
        try {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Saving using encoding");
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!! TextEditorSupport::saveFromKitToStream: enc = " + string);
            }
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!!                  ::saveFromKitToStream: after first test -> OK");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!!                  ::saveFromKitToStream: writer = " + outputStreamWriter);
            }
            editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            IOException iOException = new IOException("Unsupported encoding " + string);
            errorManager.annotate((Throwable)iOException, Util.THIS.getString("MSG_unsupported_encoding", string));
            throw iOException;
        }
    }

    public void saveDocument() throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("saveDocument()...");
        }
        final StyledDocument styledDocument = this.getDocument();
        String string = EncodingHelper.detectEncoding(styledDocument);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("!!! TextEditorSupport::saveDocument: enc = " + string);
        }
        if (string == null) {
            string = "UTF8";
        }
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), string);
            if (!this.checkCharsetConversion(Convertors.java2iana(string))) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Let unsaved.");
                }
                return;
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
            this.getXMLDataObjectLook().getSyncInterface().representationChanged(Document.class);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(Util.THIS.getString("TEXT_SAVE_AS_UTF"), string));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object.equals(NotifyDescriptor.YES_OPTION)) {
                try {
                    int n;
                    int n2 = Math.min(1000, styledDocument.getLength());
                    final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                    int n3 = 0;
                    if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                        for (n = 3; n < n2; ++n) {
                            if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                            n3 = n + 1;
                            break;
                        }
                    }
                    n = n3;
                    Runnable runnable = new Runnable(){

                        public void run() {
                            block2: {
                                try {
                                    styledDocument.remove(0, n + 1);
                                    styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                                }
                                catch (BadLocationException badLocationException) {
                                    if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                    badLocationException.printStackTrace();
                                }
                            }
                        }
                    };
                    NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                    super.saveDocument();
                    this.getDataObject().setModified(false);
                    this.getXMLDataObjectLook().getSyncInterface().representationChanged(Document.class);
                    if (Util.THIS.isLoggable()) {
                        Util.THIS.debug("Saved.");
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Let unsaved.");
            }
            return;
        }
    }

    private boolean checkCharsetConversion(String string) {
        boolean bl = true;
        try {
            CharsetEncoder charsetEncoder = Charset.forName(string).newEncoder();
            if (!charsetEncoder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)TextEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string}), 0, 2);
                confirmation.setValue(NotifyDescriptor.NO_OPTION);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                    bl = false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
        }
        return bl;
    }

    protected void syncDocument(boolean bl) {
        XMLDataObjectLook xMLDataObjectLook;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("@@ TextEditorSupport::syncDocument: fromFocus = " + bl);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("@@                  ::syncDocument: timer.isRunning = " + this.timer.isRunning());
        }
        if (bl && !this.timer.isRunning()) {
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if ((xMLDataObjectLook = this.getXMLDataObjectLook()) != null) {
            xMLDataObjectLook.getSyncInterface().representationChanged(Document.class);
        }
    }

    void restartTimer(boolean bl) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("## TextEditorSupport::restartTimer: onlyIfRunning = " + bl);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("##                  ::restartTimer: timer.isRunning = " + this.timer.isRunning());
        }
        if (bl && !this.timer.isRunning()) {
            return;
        }
        int n = settings.getAutoParsingDelay();
        if (n > 0) {
            this.timer.setInitialDelay(n);
            this.timer.restart();
        }
    }

    public final void edit() {
        try {
            this.openDocument();
            if (this.encodingErr) {
                String string = Util.THIS.getString("TEXT_WRONG_ENCODING");
                String string2 = MessageFormat.format(string, this.getDataObject().getPrimaryFile().toString());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            } else {
                Mutex.EVENT.writeAccess(new Runnable(){

                    public void run() {
                        CloneableEditor cloneableEditor = TextEditorSupport.this.openCloneableEditor();
                        cloneableEditor.requestActive();
                    }
                });
            }
        }
        catch (UserQuestionException userQuestionException) {
            this.open();
            if (this.isDocumentLoaded()) {
                if (this.encodingErr) {
                    String string = Util.THIS.getString("TEXT_WRONG_ENCODING");
                    String string3 = MessageFormat.format(string, this.getDataObject().getPrimaryFile().toString());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 0));
                } else {
                    Mutex.EVENT.writeAccess(new Runnable(){

                        public void run() {
                            CloneableEditor cloneableEditor = TextEditorSupport.this.openCloneableEditor();
                            cloneableEditor.requestActive();
                        }
                    });
                }
            }
        }
        catch (IOException iOException) {
            String string = Util.THIS.getString("TEXT_LOADING_ERROR");
            String string4 = MessageFormat.format(string, this.getDataObject().getPrimaryFile().toString());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string4, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CloneableEditor openCloneableEditor() {
        CloneableEditor cloneableEditor = null;
        Object object = this.getLock();
        synchronized (object) {
            CloneableTopComponent cloneableTopComponent;
            String string = this.messageOpening();
            if (string != null) {
                StatusDisplayer.getDefault().setStatusText(string);
            }
            Enumeration enumeration = this.allEditors.getComponents();
            while (enumeration.hasMoreElements()) {
                cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
                if (!(cloneableTopComponent instanceof CloneableEditor)) continue;
                cloneableTopComponent.open();
                cloneableEditor = (CloneableEditor)cloneableTopComponent;
            }
            if (cloneableEditor == null) {
                cloneableTopComponent = (CloneableEditor)this.createCloneableTopComponent();
                cloneableTopComponent.setReference(this.allEditors);
                cloneableTopComponent.open();
                cloneableEditor = cloneableTopComponent;
            }
            if ((string = this.messageOpened()) == null) {
                string = "";
            }
            StatusDisplayer.getDefault().setStatusText(string);
            return cloneableEditor;
        }
    }

    protected Object getLock() {
        if (awtLock == null) {
            awtLock = new Container();
        }
        return awtLock.getTreeLock();
    }

    protected CloneableEditor createCloneableEditor() {
        return new TextEditorComponent(this);
    }

    protected final CloneableTopComponent createCloneableTopComponent() {
        return super.createCloneableTopComponent();
    }

    public static final TextEditorSupportFactory findEditorSupportFactory(XMLDataObjectLook xMLDataObjectLook, String string) {
        return new TextEditorSupportFactory(xMLDataObjectLook, string);
    }

    protected static class Env
    extends DataEditorSupport.Env
    implements SaveCookie {
        private static final long serialVersionUID = -5285524519399090028L;

        public Env(XMLDataObjectLook xMLDataObjectLook) {
            super((DataObject)xMLDataObjectLook);
        }

        protected XMLDataObjectLook getXMLDataObjectLook() {
            return (XMLDataObjectLook)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public synchronized void save() throws IOException {
            this.findTextEditorSupport().saveDocument();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return this.findTextEditorSupport();
        }

        public TextEditorSupport findTextEditorSupport() {
            return (TextEditorSupport)this.getDataObject().getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = TextEditorSupport.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                this.changeFile();
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    public static class TextEditorSupportFactory
    implements CookieSet.Factory {
        private WeakReference editorRef;
        private final XMLDataObjectLook dataObject;
        private final String mime;

        public TextEditorSupportFactory(XMLDataObjectLook xMLDataObjectLook, String string) {
            this.dataObject = xMLDataObjectLook;
            this.mime = string;
        }

        protected Class[] supportedCookies() {
            return new Class[]{class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = TextEditorSupport.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie, class$org$openide$cookies$EditorCookie$Observable == null ? (class$org$openide$cookies$EditorCookie$Observable = TextEditorSupport.class$("org.openide.cookies.EditorCookie$Observable")) : class$org$openide$cookies$EditorCookie$Observable, class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = TextEditorSupport.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie, class$org$openide$cookies$CloseCookie == null ? (class$org$openide$cookies$CloseCookie = TextEditorSupport.class$("org.openide.cookies.CloseCookie")) : class$org$openide$cookies$CloseCookie, class$org$openide$cookies$PrintCookie == null ? (class$org$openide$cookies$PrintCookie = TextEditorSupport.class$("org.openide.cookies.PrintCookie")) : class$org$openide$cookies$PrintCookie};
        }

        public final void registerCookies(CookieSet cookieSet) {
            Class[] classArray = this.supportedCookies();
            for (int i = 0; i < classArray.length; ++i) {
                cookieSet.add(classArray[i], (CookieSet.Factory)this);
            }
        }

        public final Node.Cookie createCookie(Class clazz) {
            Class[] classArray = this.supportedCookies();
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].isAssignableFrom(clazz)) continue;
                return this.createEditor();
            }
            return null;
        }

        private final synchronized TextEditorSupport createEditor() {
            TextEditorSupport textEditorSupport = null;
            if (this.editorRef != null) {
                textEditorSupport = (TextEditorSupport)((Object)this.editorRef.get());
            }
            if (textEditorSupport == null) {
                textEditorSupport = this.prepareEditor();
                this.editorRef = new WeakReference<TextEditorSupport>(textEditorSupport);
            }
            return textEditorSupport;
        }

        protected TextEditorSupport prepareEditor() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Initializing TextEditorSupport ...");
            }
            return new TextEditorSupport(this.getDataObject(), this.getMIMEType());
        }

        protected final XMLDataObjectLook getDataObject() {
            return this.dataObject;
        }

        protected final String getMIMEType() {
            return this.mime;
        }
    }
}

