/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.Component;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.core.wizard.DocumentModel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

public abstract class AbstractPanel
extends JPanel
implements Customizer {
    private static final long serialVersionUID = 508989667995691L;
    protected DocumentModel model;
    private WizardStep step;

    protected abstract void updateModel();

    protected abstract void initView();

    protected abstract void updateView();

    public void setObject(Object object) {
        if (AbstractPanel.not(object instanceof DocumentModel)) {
            throw new IllegalArgumentException("DocumentModel class expected.");
        }
        this.model = (DocumentModel)object;
        this.initView();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    protected static boolean not(boolean bl) {
        return !bl;
    }

    protected final WizardStep getStep() {
        if (this.step == null) {
            throw new IllegalStateException("new WizardStep(this) have not been called!");
        }
        return this.step;
    }

    public static class WizardStep
    implements WizardDescriptor.Panel {
        private final AbstractPanel peer;
        private Vector listeners = new Vector();
        private final ChangeEvent EVENT = new ChangeEvent(this);
        private boolean valid = true;

        public WizardStep(AbstractPanel abstractPanel) {
            if (abstractPanel == null) {
                throw new NullPointerException();
            }
            this.peer = abstractPanel;
            abstractPanel.step = this;
        }

        public Component getComponent() {
            return this.peer;
        }

        public void readSettings(Object object) {
            this.peer.updateView();
        }

        public final HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void storeSettings(Object object) {
            this.peer.updateModel();
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void setValid(boolean bl) {
            if (this.valid == bl) {
                return;
            }
            this.valid = bl;
            Vector vector = this.listeners;
            synchronized (vector) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ChangeListener changeListener = (ChangeListener)iterator.next();
                    changeListener.stateChanged(this.EVENT);
                }
            }
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }
    }
}

