/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.core.lib.AbstractUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.ActionManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

class Util
extends AbstractUtil {
    private static File lastDirectory;
    public static final Util THIS;

    private Util() {
    }

    public static File selectSchemaFile(final String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreElements()) {
                    if (!file.getName().endsWith(stringTokenizer.nextToken())) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return THIS.getString("PROP_schema_mask");
            }
        });
        if (lastDirectory != null) {
            jFileChooser.setCurrentDirectory(lastDirectory);
        }
        jFileChooser.setDialogTitle(THIS.getString("PROP_schema_dialog_name"));
        while (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), THIS.getString("PROP_schema_select_button")) == 0) {
            File file = jFileChooser.getSelectedFile();
            lastDirectory = jFileChooser.getCurrentDirectory();
            if (file != null && file.isFile()) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreElements()) {
                    if (!file.getName().endsWith(stringTokenizer.nextToken())) continue;
                    return file;
                }
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)THIS.getString("MSG_inValidFile"), 2));
        }
        return null;
    }

    public static String[] getKnownDTDPublicIDs() {
        UserCatalog userCatalog = UserCatalog.getDefault();
        if (userCatalog != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator iterator = userCatalog.getPublicIDs();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = string.toLowerCase();
                if (string2.startsWith("schema:") || string2.endsWith(".xsd")) continue;
                treeSet.add(string);
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }
        THIS.debug("Note SourceResolver not found!");
        return new String[0];
    }

    public static void performDefaultAction(DataObject dataObject) {
        Node node = dataObject.getNodeDelegate();
        SystemAction systemAction = node.getDefaultAction();
        if (systemAction != null) {
            ActionManager actionManager = (ActionManager)Lookup.getDefault().lookup(ActionManager.class);
            actionManager.invokeAction((Action)systemAction, new ActionEvent(node, 1001, ""));
        }
    }

    static {
        THIS = new Util();
    }
}

