/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineAnnotations;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapter;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusPart;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.tigris.subversion.svnclientadapter.commandline.SvnAdminCommandLine;
import org.tigris.subversion.svnclientadapter.commandline.SvnCommandLine;
import org.tigris.subversion.svnclientadapter.commandline.SvnCommandLine12;
import org.tigris.subversion.svnclientadapter.commandline.SvnMultiArgCommandLine;
import org.tigris.subversion.svnclientadapter.utils.StringUtils;

public class CmdLineClientAdapter12
extends CmdLineClientAdapter {
    private static boolean availabilityCached = false;
    private static boolean available;

    public CmdLineClientAdapter12(String subversionPath, CmdLineNotificationHandler notificationHandler) {
        super(notificationHandler, new SvnCommandLine12(subversionPath + "svn", notificationHandler), new SvnMultiArgCommandLine(subversionPath + "svn", notificationHandler), new SvnAdminCommandLine(subversionPath + "svnadmin", notificationHandler));
    }

    public static boolean isAvailable(String subversionPath) {
        if (!availabilityCached) {
            SvnCommandLine cmd = new SvnCommandLine(subversionPath + "svn", new CmdLineNotificationHandler());
            try {
                cmd.version();
                available = true;
            }
            catch (Exception e) {
                available = false;
            }
            availabilityCached = true;
        }
        return available;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws SVNClientException {
        return super.getStatus(path, descend, getAll, false);
    }

    protected CmdLineStatusPart[] getCmdStatuses(String[] paths, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws CmdLineException {
        if (paths.length == 0) {
            return new CmdLineStatusPart[0];
        }
        String statusLinesString = ((SvnCommandLine12)this._cmd).statusByStdout(paths, descend, getAll, false, ignoreExternals);
        String[] parts = StringUtils.split(statusLinesString, Helper.NEWLINE);
        CmdLineStatusPart[] cmdLineStatusParts = new CmdLineStatusPart[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            cmdLineStatusParts[i] = new CmdLineStatusPart.CmdLineStatusPartFromStdout(parts[i]);
        }
        return cmdLineStatusParts;
    }

    protected ISVNAnnotations annotate(String target, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (revisionStart == null) {
                revisionStart = new SVNRevision.Number(1L);
            }
            if (revisionEnd == null) {
                revisionEnd = SVNRevision.HEAD;
            }
            String annotations = ((SvnCommandLine12)this._cmd).annotateByStdout(target, CmdLineClientAdapter12.toString(revisionStart), CmdLineClientAdapter12.toString(revisionEnd));
            return CmdLineAnnotations.createFromStdOut(annotations, Helper.NEWLINE);
        }
        catch (CmdLineException e) {
            throw SVNClientException.wrapException(e);
        }
    }
}

