/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public final class Background {
    private static boolean loaded = false;
    private static boolean loadfailed = false;
    private Thread peer;
    private Cancellable cancel;

    private Background(Thread thread, Cancellable cancellable) {
        this.peer = thread;
        this.cancel = cancellable;
    }

    public static Background execute(Runnable runnable) {
        Cancellable cancellable = (Cancellable)(runnable instanceof Cancellable ? runnable : null);
        if (Background.useHack()) {
            Thread thread = new Thread((Runnable)new Wrapper(runnable), "Background");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
            return new Background(thread, cancellable);
        }
        ThreadExtractor threadExtractor = new ThreadExtractor(runnable);
        RequestProcessor.getDefault().post((Runnable)threadExtractor, 0, 1);
        return new Background(threadExtractor.getThread(), cancellable);
    }

    public final void interrupt() {
        if (this.peer != null) {
            this.peer.interrupt();
            this.peer.interrupt();
        }
        if (this.cancel != null) {
            this.cancel.cancel();
        }
    }

    private static boolean useHack() {
        String string = System.getProperty("os.name");
        if (!"Linux".equals(string)) {
            return false;
        }
        String string2 = "" + System.getProperty("os.version");
        if (!string2.startsWith("2.4")) {
            return false;
        }
        String string3 = "" + System.getProperty("java.vm.vendor");
        if (!string3.startsWith("Sun")) {
            return false;
        }
        String string4 = "" + System.getProperty("java.vm.version");
        if (!string4.startsWith("1.4")) {
            return false;
        }
        String string5 = System.getProperty("os.arch");
        if (!"i386".equals(string5)) {
            return false;
        }
        Background.loadLibrary();
        return loaded;
    }

    private static void loadLibrary() {
        if (loadfailed) {
            return;
        }
        if (!loaded) {
            try {
                System.loadLibrary("tasklist_bgthreads");
                loaded = true;
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().notify(1, throwable);
                loadfailed = true;
            }
        }
    }

    private static native void native_nice();

    public static void main(String[] stringArray) throws Exception {
        if (Background.useHack()) {
            Background.native_nice();
            System.out.println("I'm niced for 1 minute. Check it by top utility.");
            Thread.sleep(60000L);
        }
    }

    private static class ThreadExtractor
    implements Runnable {
        private final Runnable peer;
        private Thread thread;

        ThreadExtractor(Runnable runnable) {
            this.peer = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread();
            Thread.interrupted();
            ThreadExtractor threadExtractor = this;
            synchronized (threadExtractor) {
                this.thread = Thread.currentThread();
                this.notifyAll();
            }
            this.peer.run();
        }

        public synchronized Thread getThread() {
            while (this.thread == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.thread;
        }
    }

    private static class Wrapper
    implements Runnable {
        private final Runnable peer;

        public Wrapper(Runnable runnable) {
            this.peer = runnable;
        }

        public void run() {
            Background.native_nice();
            this.peer.run();
        }
    }
}

