/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.core.TaskChildren;
import org.netbeans.modules.tasklist.core.TaskListener;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class Task
extends Suggestion
implements Cloneable,
Node.Cookie {
    private static final Logger LOGGER = TLUtils.getLogger(Task.class);
    static final String PROP_ATTRS_CHANGED = "attrs";
    protected EventListenerList listeners = new EventListenerList();
    private boolean visitable;
    private Task parent;
    private Object key;
    private List subtasks = null;
    private List subtasksCopy;
    private boolean zombie = false;

    public Task() {
        super(null, null, null, null);
        this.parent = null;
        this.visitable = true;
        this.key = new Object();
    }

    public Task(String string, Task task) {
        super(null, null, string, null);
        this.parent = task;
        this.visitable = true;
        this.key = new Object();
    }

    public int indexOf(Task task) {
        if (!this.hasSubtasks()) {
            return -1;
        }
        return this.subtasks.indexOf(task);
    }

    public void clear() {
        if (this.hasSubtasks()) {
            this.subtasks.clear();
            this.subtasksCopy = null;
            this.fireStructureChanged();
        }
    }

    public int getLevel() {
        int n = 0;
        for (Task task = this.getParent(); task != null; task = task.getParent()) {
            ++n;
        }
        return n;
    }

    public void setSummary(String string) {
        super.setSummary(string);
    }

    public void setDetails(String string) {
        super.setDetails(string);
    }

    public void setPriority(SuggestionPriority suggestionPriority) {
        super.setPriority(suggestionPriority);
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public void setVisitable(boolean bl) {
        this.visitable = bl;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    public void addTaskListener(TaskListener taskListener) {
        if (LOGGER.isLoggable(Level.FINE)) {
            Thread.dumpStack();
        }
        this.listeners.add(TaskListener.class, taskListener);
    }

    public void removeTaskListener(TaskListener taskListener) {
        if (LOGGER.isLoggable(Level.FINE)) {
            Thread.dumpStack();
        }
        this.listeners.remove(TaskListener.class, taskListener);
    }

    protected final void fireStructureChanged() {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TaskListener.class) continue;
            ((TaskListener)objectArray[i + 1]).structureChanged(this);
        }
        if (this instanceof TaskListener) {
            ((TaskListener)((Object)this)).structureChanged(this);
        }
    }

    protected final void fireAddedTask(Task task) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TaskListener.class) continue;
            ((TaskListener)objectArray[i + 1]).addedTask(task);
        }
        if (this instanceof TaskListener) {
            ((TaskListener)((Object)this)).addedTask(task);
        }
    }

    protected final void fireRemovedTask(Task task, int n) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TaskListener.class) continue;
            ((TaskListener)objectArray[i + 1]).removedTask(this, task, n);
        }
        if (this instanceof TaskListener) {
            ((TaskListener)((Object)this)).removedTask(this, task, n);
        }
    }

    protected void recursivePropertyChange() {
        this.firePropertyChange(PROP_ATTRS_CHANGED, null, null);
        if (this.subtasks != null) {
            for (Task task : this.getSubtasks()) {
                task.recursivePropertyChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getSubtasks() {
        if (this.subtasks == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.subtasksCopy == null) {
            List list = this.subtasks;
            synchronized (list) {
                this.subtasksCopy = Collections.unmodifiableList(new ArrayList(this.subtasks));
            }
        }
        return this.subtasksCopy;
    }

    public final Iterator subtasksIterator() {
        return this.getSubtasks().iterator();
    }

    public final int subtasksCount() {
        if (this.subtasks == null) {
            return 0;
        }
        return this.subtasks.size();
    }

    public final boolean containsSubtask(Task task) {
        if (this.subtasks == null) {
            return false;
        }
        return this.subtasks.contains(task);
    }

    public void addSubtask(Task task) {
        this.addSubtask(task, false);
    }

    public void addSubtask(Task task, Task task2) {
        task.parent = this;
        if (this.subtasks == null) {
            ErrorManager.getDefault().log("addSubtask(subtask,after) called where subtasks==null");
            return;
        }
        int n = this.subtasks.indexOf(task2);
        this.subtasks.add(n + 1, task);
        this.subtasksCopy = null;
        this.fireAddedTask(task);
    }

    public void addSubtasks(List list, boolean bl, Task task) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Task task2 = (Task)listIterator.next();
            task2.parent = this;
        }
        if (this.subtasks == null) {
            this.subtasks = Collections.synchronizedList(new LinkedList());
        }
        if (task != null) {
            int n = this.subtasks.indexOf(task);
            this.subtasks.addAll(n + 1, list);
        } else if (bl) {
            this.subtasks.addAll(list);
        } else {
            this.subtasks.addAll(0, list);
        }
        this.subtasksCopy = null;
        this.fireStructureChanged();
    }

    public void addSubtask(Task task, boolean bl) {
        task.parent = this;
        if (this.subtasks == null) {
            this.subtasks = Collections.synchronizedList(new LinkedList());
        }
        if (this.subtasks.contains(task)) {
            return;
        }
        if (bl) {
            this.subtasks.add(task);
        } else {
            this.subtasks.add(0, task);
        }
        this.subtasksCopy = null;
        this.fireAddedTask(task);
    }

    public void removeSubtask(Task task) {
        task.zombie = true;
        if (this.subtasks == null) {
            return;
        }
        int n = this.subtasks.indexOf(task);
        this.subtasks.remove(n);
        if (this.subtasks.size() == 0) {
            this.subtasks = null;
        }
        this.subtasksCopy = null;
        this.fireRemovedTask(task, n);
    }

    public final boolean hasSubtasks() {
        return this.subtasks != null && this.subtasks.size() != 0;
    }

    public final Task getParent() {
        return this.parent;
    }

    public final Task getRoot() {
        Task task = this.getParent();
        if (task != null) {
            return task.getRoot();
        }
        return this;
    }

    public final boolean isParentOf(Task task) {
        if (task.getKey() == this.getKey()) {
            return true;
        }
        Task task2 = task.getParent();
        if (task2 == null) {
            return false;
        }
        return this.isParentOf(task2);
    }

    public boolean isZombie() {
        return this.zombie;
    }

    public static void generate(Task task, Writer writer) throws IOException {
        writer.write(task.getSummary());
    }

    public static Task parse(Reader reader) throws IOException {
        LOGGER.fine("parsing");
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        if (string != null) {
            Task task = new Task();
            task.setSummary(string);
            return task;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSubtaskCountRecursively() {
        if (this.subtasks == null) {
            return 0;
        }
        int n = 0;
        List list = this.subtasks;
        synchronized (list) {
            for (Task task : this.subtasks) {
                n += task.getSubtaskCountRecursively() + 1;
            }
            return n;
        }
    }

    public Node[] createNode() {
        if (this.subtasks != null) {
            return new Node[]{new TaskNode(this, (Children)new TaskChildren(this))};
        }
        return new Node[]{new TaskNode(this)};
    }

    protected Object clone() {
        Task task = new Task();
        task.copyFrom(this);
        return task;
    }

    public final Object getKey() {
        return this.key;
    }

    public Object getSeed() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFrom(Task task) {
        this.visitable = task.visitable;
        this.zombie = task.zombie;
        assert (task.key != null);
        this.key = task.key;
        super.setSummary(task.getSummary());
        super.setPriority(task.getPriority());
        super.setIcon(task.getIcon());
        super.setType(task.getType());
        super.setLine(task.getLine());
        super.setAction(task.getAction());
        super.setDetails(task.getDetails());
        this.parent = task.parent;
        if (task.subtasks != null) {
            List list = task.subtasks;
            synchronized (list) {
                Iterator iterator = task.subtasks.iterator();
                this.subtasks = Collections.synchronizedList(new LinkedList());
                while (iterator.hasNext()) {
                    Task task2 = (Task)iterator.next();
                    Task task3 = (Task)task2.clone();
                    task3.parent = this;
                    this.subtasks.add(task3);
                }
                this.subtasksCopy = null;
            }
        }
    }

    static {
        LOGGER.setLevel(Level.OFF);
    }
}

