/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.columns;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.tasklist.core.columns.ColumnsConfiguration;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ColumnsConfigurationConvertor
extends DOMConvertor
implements ChangeListener {
    private Saver saver;

    private static Object create(FileObject fileObject) {
        ColumnsConfigurationConvertor columnsConfigurationConvertor = new ColumnsConfigurationConvertor();
        return columnsConfigurationConvertor;
    }

    public ColumnsConfigurationConvertor() {
        super("-//NetBeans org.netbeans.modules.tasklist//DTD Columns 1.0//EN", "http://tasklist.netbeans.org/dtd/columns-1_0.dtd", "columns");
    }

    protected Object readElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = true;
        String string = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element2 = (Element)nodeList.item(i);
            arrayList2.add(element2.getAttribute("property"));
            arrayList.add(element2.getAttribute("width"));
            if (string != null) continue;
            String string2 = element2.getAttribute("sort");
            if (string2.equals("ascending")) {
                string = element2.getAttribute("property");
                bl = true;
                continue;
            }
            if (!string2.equals("descending")) continue;
            string = element2.getAttribute("property");
            bl = false;
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                nArray[i] = Integer.parseInt((String)arrayList.get(i));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager.getDefault().notify((Throwable)numberFormatException);
            }
        }
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        return new ColumnsConfiguration(stringArray, nArray, string, bl);
    }

    protected void writeElement(Document document, Element element, Object object) {
        ColumnsConfiguration columnsConfiguration = (ColumnsConfiguration)object;
        int[] nArray = columnsConfiguration.getWidths();
        String[] stringArray = columnsConfiguration.getProperties();
        String string = columnsConfiguration.getSortingColumn();
        boolean bl = columnsConfiguration.getSortingOrder();
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = document.createElement("column");
            element2.setAttribute("property", stringArray[i]);
            element2.setAttribute("width", String.valueOf(nArray[i]));
            if (stringArray[i].equals(string)) {
                element2.setAttribute("sort", bl ? "ascending" : "descending");
            }
            element.appendChild(element2);
        }
    }

    public void registerSaver(Object object, Saver saver) {
        this.saver = saver;
        ((ColumnsConfiguration)object).addChangeListener(this);
    }

    public void unregisterSaver(Object object, Saver saver) {
        if (saver == null || saver != this.saver) {
            ErrorManager.getDefault().notify(65536, (Throwable)new IllegalArgumentException("Wrong argument for unregisterSaver(Object=" + object + ", Saver=" + saver + ")"));
        }
        this.saver = null;
        ((ColumnsConfiguration)object).removeChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.saver.requestSave();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }
}

